/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.meta.DBException;
import org.netbeans.modules.db.dataview.output.DataView;
import org.netbeans.modules.db.dataview.output.InsertRecordTableUI;
import org.netbeans.modules.db.dataview.output.SQLExecutionHelper;
import org.netbeans.modules.db.dataview.output.SQLStatementGenerator;
import org.netbeans.modules.db.dataview.table.JXTableRowHeader;
import org.netbeans.modules.db.dataview.util.DBReadWriteHelper;
import org.netbeans.modules.db.dataview.util.DataViewUtils;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

class InsertRecordDialog
extends JDialog {
    private final DataView dataView;
    InsertRecordTableUI jTable1;
    private JXTableRowHeader rowHeader;
    private Clipboard clipBoard = Toolkit.getDefaultToolkit().getSystemClipboard();
    private JButton addBtn;
    private JPanel btnPanel;
    private JButton cancelBtn;
    private JButton executeBtn;
    private JEditorPane jEditorPane1;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JTextArea jTextArea1;
    private JButton previewBtn;
    private JButton removeBtn;

    public InsertRecordDialog(DataView dataView) {
        super(WindowManager.getDefault().getMainWindow(), true);
        this.dataView = dataView;
        this.jTable1 = new InsertRecordTableUI(dataView){

            public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
                AWTEvent aWTEvent;
                if (n != -1 && n2 != -1) {
                    InsertRecordDialog.this.removeBtn.setEnabled(true);
                }
                if ((aWTEvent = EventQueue.getCurrentEvent()) instanceof KeyEvent) {
                    KeyEvent keyEvent = (KeyEvent)aWTEvent;
                    if (keyEvent.getSource() != this) {
                        return;
                    }
                    if (n == 0 && n2 == 0 && KeyStroke.getKeyStrokeForEvent(keyEvent).equals(KeyStroke.getKeyStroke(9, 0))) {
                        DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
                        defaultTableModel.addRow(this.createNewRow());
                        n = this.getRowCount() - 1;
                        this.editCellAt(n, 0);
                    } else if (KeyStroke.getKeyStrokeForEvent(keyEvent).equals(KeyStroke.getKeyStroke(25, 0))) {
                        this.editCellAt(n, n2);
                    } else {
                        this.editCellAt(n, n2);
                    }
                }
                super.changeSelection(n, n2, bl, bl2);
            }
        };
        this.initComponents();
        this.addInputFields();
        this.jTable1.addKeyListener(new TableKeyListener());
        TableSelectionListener tableSelectionListener = new TableSelectionListener((JTable)((Object)this.jTable1));
        this.jTable1.getSelectionModel().addListSelectionListener(tableSelectionListener);
        this.jTable1.getColumnModel().getSelectionModel().addListSelectionListener(tableSelectionListener);
        this.jSplitPane1.setBottomComponent(null);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0, false);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                InsertRecordDialog.this.executeBtnActionPerformed(null);
            }
        };
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction abstractAction2 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                InsertRecordDialog.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(keyStroke2, "ESCAPE");
        this.getRootPane().getInputMap(2).put(keyStroke, "ENTER");
        this.getRootPane().getActionMap().put("ESCAPE", abstractAction2);
        this.getRootPane().getActionMap().put("ENTER", abstractAction);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((dimension.width - 50) / 2, (dimension.height - 200) / 2, (dimension.width - 50) / 2, (dimension.height - 50) / 2);
    }

    private void initComponents() {
        this.jTextArea1 = new JTextArea();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel3 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jEditorPane1 = new JEditorPane();
        this.btnPanel = new JPanel();
        this.previewBtn = new JButton();
        this.addBtn = new JButton();
        this.removeBtn = new JButton();
        this.executeBtn = new JButton();
        this.cancelBtn = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.title"));
        this.setBackground(Color.white);
        this.setFont(new Font("Dialog", 0, 12));
        this.setForeground(Color.black);
        this.setLocationByPlatform(true);
        this.setModal(true);
        this.jTextArea1.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setFont(this.jTextArea1.getFont());
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(3);
        this.jTextArea1.setText(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.jTextArea1.text"));
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setAutoscrolls(false);
        this.jTextArea1.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().add((Component)this.jTextArea1, "North");
        this.jTextArea1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InsertRecordDialog.class, (String)"insertRecodrDialog.jTextArea"));
        this.jTextArea1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InsertRecordDialog.class, (String)"insertRecord.textarea.desc"));
        this.jSplitPane1.setDividerLocation(250);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setLastDividerLocation(250);
        this.jSplitPane1.setRequestFocusEnabled(false);
        this.jScrollPane1.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 255)));
        this.jScrollPane1.setFont(this.jScrollPane1.getFont());
        this.jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel3.setForeground(new Color(204, 204, 255));
        this.jPanel3.setFont(this.jPanel3.getFont().deriveFont((float)this.jPanel3.getFont().getSize() + 1.0f));
        this.jPanel3.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.jPanel3);
        this.jSplitPane1.setTopComponent(this.jScrollPane1);
        this.jScrollPane2.setFont(this.jScrollPane2.getFont());
        this.jEditorPane1.setContentType(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.jEditorPane1.contentType"));
        this.jEditorPane1.setEditable(false);
        this.jEditorPane1.setEditorKit(CloneableEditorSupport.getEditorKit((String)"text/x-sql"));
        this.jEditorPane1.setFont(this.jEditorPane1.getFont());
        this.jEditorPane1.setToolTipText(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.jEditorPane1.toolTipText"));
        this.jEditorPane1.setOpaque(false);
        this.jScrollPane2.setViewportView(this.jEditorPane1);
        this.jSplitPane1.setBottomComponent(this.jScrollPane2);
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.btnPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 20, 10));
        this.btnPanel.setFont(this.btnPanel.getFont());
        this.btnPanel.setPreferredSize(new Dimension(550, 50));
        this.btnPanel.setLayout(new FlowLayout(2));
        this.previewBtn.setFont(this.previewBtn.getFont());
        this.previewBtn.setMnemonic('S');
        this.previewBtn.setText(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.previewBtn.text"));
        this.previewBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InsertRecordDialog.this.previewBtnActionPerformed(actionEvent);
            }
        });
        this.btnPanel.add(this.previewBtn);
        this.previewBtn.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.previewBtn.text"));
        this.previewBtn.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.previewBtn.text"));
        this.addBtn.setMnemonic('A');
        this.addBtn.setText(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.addBtn.text_1"));
        this.addBtn.setToolTipText(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.addBtn.toolTipText"));
        this.addBtn.setMaximumSize(this.previewBtn.getMaximumSize());
        this.addBtn.setMinimumSize(this.previewBtn.getMinimumSize());
        this.addBtn.setPreferredSize(this.previewBtn.getPreferredSize());
        this.addBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InsertRecordDialog.this.addBtnActionPerformed(actionEvent);
            }
        });
        this.btnPanel.add(this.addBtn);
        this.removeBtn.setMnemonic('R');
        this.removeBtn.setText(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.removeBtn.text_1"));
        this.removeBtn.setToolTipText(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.removeBtn.toolTipText"));
        this.removeBtn.setEnabled(false);
        this.removeBtn.setMaximumSize(this.previewBtn.getMaximumSize());
        this.removeBtn.setMinimumSize(this.previewBtn.getMinimumSize());
        this.removeBtn.setPreferredSize(this.previewBtn.getPreferredSize());
        this.removeBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InsertRecordDialog.this.removeBtnActionPerformed(actionEvent);
            }
        });
        this.btnPanel.add(this.removeBtn);
        this.executeBtn.setFont(this.executeBtn.getFont());
        this.executeBtn.setMnemonic('O');
        this.executeBtn.setText(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.executeBtn.text"));
        this.executeBtn.setMaximumSize(this.previewBtn.getMaximumSize());
        this.executeBtn.setMinimumSize(this.previewBtn.getMinimumSize());
        this.executeBtn.setPreferredSize(this.previewBtn.getPreferredSize());
        this.executeBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InsertRecordDialog.this.executeBtnActionPerformed(actionEvent);
            }
        });
        this.btnPanel.add(this.executeBtn);
        this.executeBtn.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.executeBtn.text"));
        this.executeBtn.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.executeBtn.text"));
        this.cancelBtn.setFont(this.cancelBtn.getFont());
        this.cancelBtn.setMnemonic('C');
        this.cancelBtn.setText(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.cancelBtn.text"));
        this.cancelBtn.setMaximumSize(this.previewBtn.getMaximumSize());
        this.cancelBtn.setMinimumSize(this.previewBtn.getMinimumSize());
        this.cancelBtn.setPreferredSize(this.previewBtn.getPreferredSize());
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InsertRecordDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        this.btnPanel.add(this.cancelBtn);
        this.cancelBtn.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.cancelBtn.text"));
        this.cancelBtn.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.cancelBtn.text"));
        this.getContentPane().add((Component)this.btnPanel, "South");
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleParent(null);
    }

    private void addBtnActionPerformed(ActionEvent actionEvent) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.jTable1.getModel();
        defaultTableModel.addRow(this.jTable1.createNewRow());
    }

    private void removeBtnActionPerformed(ActionEvent actionEvent) {
        this.jTable1.removeRows();
        this.removeBtn.setEnabled(false);
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    private void executeBtnActionPerformed(ActionEvent actionEvent) {
        if (this.jTable1.isEditing()) {
            this.jTable1.getCellEditor().stopCellEditing();
        }
        String string = null;
        SQLStatementGenerator sQLStatementGenerator = this.dataView.getSQLStatementGenerator();
        SQLExecutionHelper sQLExecutionHelper = this.dataView.getSQLExecutionHelper();
        for (int i = 0; i < this.jTable1.getRowCount(); ++i) {
            try {
                Object[] objectArray = this.getInsertValues(i);
                string = sQLStatementGenerator.generateInsertStatement(objectArray);
                sQLExecutionHelper.executeInsertRow(string, objectArray);
                continue;
            }
            catch (DBException dBException) {
                if (this.jSplitPane1.getBottomComponent() == null) {
                    this.jSplitPane1.setDividerLocation(this.jSplitPane1.getHeight() / 2);
                    this.jSplitPane1.setBottomComponent(this.jScrollPane2);
                    this.previewBtn.setText(NbBundle.getMessage(InsertRecordDialog.class, (String)"LBL_hide_sql"));
                }
                this.jEditorPane1.setContentType("text/html");
                String string2 = "<html> <body><font color=#FF0000>" + dBException.getMessage().replaceAll("\\n", "<br>") + "</font></body></html>";
                this.jEditorPane1.setText(string2);
                return;
            }
        }
        this.dispose();
    }

    private void previewBtnActionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equalsIgnoreCase(NbBundle.getMessage(InsertRecordDialog.class, (String)"LBL_show_sql"))) {
            this.jSplitPane1.setDividerLocation(this.jSplitPane1.getHeight() / 2);
            this.jSplitPane1.setBottomComponent(this.jScrollPane2);
            this.refreshSQL();
            this.previewBtn.setText(NbBundle.getMessage(InsertRecordDialog.class, (String)"LBL_hide_sql"));
        } else {
            this.jSplitPane1.setBottomComponent(null);
            this.previewBtn.setText(NbBundle.getMessage(InsertRecordDialog.class, (String)"LBL_show_sql"));
        }
    }

    public void refreshSQL() {
        try {
            this.jEditorPane1.setContentType("text/x-sql");
            String string = "";
            if (this.jSplitPane1.getBottomComponent() != null) {
                SQLStatementGenerator sQLStatementGenerator = this.dataView.getSQLStatementGenerator();
                for (int i = 0; i < this.jTable1.getRowCount(); ++i) {
                    String string2 = sQLStatementGenerator.generateRawInsertStatement(this.getInsertValues(i));
                    string = string + string2 + "\n";
                }
                this.jEditorPane1.setText(string);
            }
        }
        catch (DBException dBException) {
            this.jEditorPane1.setContentType("text/html");
            String string = "<html> <body><font color=#FF0000>" + dBException.getMessage().replaceAll("\\n", "<br>") + "</font></body></html>";
            this.jEditorPane1.setText(string);
            return;
        }
    }

    private void addInputFields() {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        arrayList.add(this.jTable1.createNewRow());
        this.jScrollPane1.setViewportView((Component)((Object)this.jTable1));
        this.rowHeader = new JXTableRowHeader((JTable)((Object)this.jTable1));
        final Component[] componentArray = new Component[]{this.rowHeader, this.jTable1};
        FocusTraversalPolicy focusTraversalPolicy = new FocusTraversalPolicy(){
            List componentList;
            {
                this.componentList = Arrays.asList(componentArray);
            }

            public Component getFirstComponent(Container container) {
                return componentArray[0];
            }

            public Component getLastComponent(Container container) {
                return componentArray[componentArray.length - 1];
            }

            public Component getComponentAfter(Container container, Component component) {
                if (component instanceof JXTableRowHeader) {
                    int n = InsertRecordDialog.this.jTable1.getRowCount() - 1;
                    InsertRecordDialog.this.jTable1.editCellAt(n, 0);
                    InsertRecordDialog.this.jTable1.setRowSelectionInterval(n, 0);
                }
                return InsertRecordDialog.this.jTable1;
            }

            public Component getComponentBefore(Container container, Component component) {
                int n = this.componentList.indexOf(component);
                return componentArray[(n - 1 + componentArray.length) % componentArray.length];
            }

            public Component getDefaultComponent(Container container) {
                return componentArray[0];
            }
        };
        this.setFocusTraversalPolicy(focusTraversalPolicy);
        this.jScrollPane1.setRowHeaderView(this.rowHeader);
        this.jScrollPane1.setCorner("UPPER_LEFT_CORNER", this.rowHeader.getTableHeader());
        this.jTable1.createTableModel(arrayList, this.rowHeader);
    }

    private Object[] getInsertValues(int n) throws DBException {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.jTable1.getModel();
        Object[] objectArray = new Object[this.jTable1.getRSColumnCount()];
        int n2 = this.jTable1.getRSColumnCount();
        for (int i = 0; i < n2; ++i) {
            DBColumn dBColumn = this.jTable1.getDBColumn(i);
            Object object = defaultTableModel.getValueAt(n, i);
            objectArray[i] = DataViewUtils.isSQLConstantString(object) ? object : DBReadWriteHelper.validate(object, dBColumn);
        }
        return objectArray;
    }

    private void processKeyEvents(KeyEvent keyEvent) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(67, 2, false);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(86, 2, false);
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(9, 0);
        if (KeyStroke.getKeyStrokeForEvent(keyEvent).equals(keyStroke)) {
            this.copy();
        } else if (KeyStroke.getKeyStrokeForEvent(keyEvent).equals(keyStroke2)) {
            this.paste();
        }
        if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 127) {
            this.jTable1.removeRows();
        } else if (keyEvent.getKeyCode() == 10) {
            this.setFocusable(false);
        } else if (keyEvent.isControlDown() && keyEvent.getKeyChar() == '0') {
            this.control0Event();
        } else if (keyEvent.isControlDown() && keyEvent.getKeyChar() == '1') {
            this.control1Event();
        } else if (KeyStroke.getKeyStrokeForEvent(keyEvent).equals(keyStroke3)) {
            // empty if block
        }
    }

    private void copy() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.jTable1.getSelectedColumnCount();
        int n2 = this.jTable1.getSelectedRowCount();
        int[] nArray = this.jTable1.getSelectedRows();
        int[] nArray2 = this.jTable1.getSelectedColumns();
        if (n2 - 1 != nArray[nArray.length - 1] - nArray[0] || n2 != nArray.length || n - 1 != nArray2[nArray2.length - 1] - nArray2[0] || n != nArray2.length) {
            JOptionPane.showMessageDialog(null, "Invalid Copy Selection", "Invalid Copy Selection", 0);
            return;
        }
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                stringBuffer.append(this.jTable1.getValueAt(nArray[i], nArray2[j]));
                if (j >= n - 1) continue;
                stringBuffer.append("\t");
            }
            stringBuffer.append("\n");
        }
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        this.clipBoard = Toolkit.getDefaultToolkit().getSystemClipboard();
        this.clipBoard.setContents(stringSelection, stringSelection);
    }

    private void paste() {
        int n = this.jTable1.getSelectedRows()[0];
        int n2 = this.jTable1.getSelectedColumns()[0];
        try {
            int n3;
            String string = (String)this.clipBoard.getContents(this).getTransferData(DataFlavor.stringFlavor);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            if (this.jTable1.getSelectedRows().length < stringTokenizer.countTokens()) {
                n3 = stringTokenizer.countTokens() - this.jTable1.getSelectedRows().length;
                for (int i = 0; i < n3; ++i) {
                    this.addBtnActionPerformed(null);
                }
            }
            n3 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "\t");
                int n4 = 0;
                while (stringTokenizer2.hasMoreTokens()) {
                    String string3 = stringTokenizer2.nextToken();
                    if (n + n3 < this.jTable1.getRowCount() && n2 + n4 < this.jTable1.getColumnCount()) {
                        this.jTable1.setValueAt(string3, n + n3, n2 + n4);
                    }
                    ++n4;
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            Logger.getLogger(InsertRecordDialog.class.getName()).info("Failed to paste the contents " + exception);
        }
    }

    private void control0Event() {
        int n = this.jTable1.getSelectedRow();
        int n2 = this.jTable1.getSelectedColumn();
        if (n == -1) {
            return;
        }
        this.jTable1.editCellAt(n, n2);
        TableCellEditor tableCellEditor = this.jTable1.getCellEditor();
        if (tableCellEditor != null) {
            DBColumn dBColumn = this.dataView.getDataViewDBTable().getColumn(n2);
            if (dBColumn.isGenerated() || !dBColumn.isNullable()) {
                Toolkit.getDefaultToolkit().beep();
                tableCellEditor.stopCellEditing();
            } else {
                tableCellEditor.getTableCellEditorComponent((JTable)((Object)this.jTable1), null, this.jTable1.isRowSelectionAllowed, n, n2);
                this.jTable1.setValueAt(null, n, n2);
                tableCellEditor.stopCellEditing();
            }
            this.jTable1.setRowSelectionInterval(n, n);
        }
    }

    private void control1Event() {
        int n = this.jTable1.getSelectedRow();
        int n2 = this.jTable1.getSelectedColumn();
        if (n == -1) {
            return;
        }
        this.jTable1.editCellAt(n, n2);
        TableCellEditor tableCellEditor = this.jTable1.getCellEditor();
        if (tableCellEditor != null) {
            DBColumn dBColumn = this.dataView.getDataViewDBTable().getColumn(n2);
            Object object = this.jTable1.getValueAt(n, n2);
            if (dBColumn.isGenerated() || !dBColumn.hasDefault()) {
                Toolkit.getDefaultToolkit().beep();
                tableCellEditor.stopCellEditing();
            } else if (object != null && object instanceof String && ((String)object).equals("<DEFAULT>")) {
                tableCellEditor.getTableCellEditorComponent((JTable)((Object)this.jTable1), "", this.jTable1.isRowSelectionAllowed, n, n2);
                this.jTable1.setValueAt(null, n, n2);
                tableCellEditor.stopCellEditing();
            } else {
                tableCellEditor.getTableCellEditorComponent((JTable)((Object)this.jTable1), "<DEFAULT>", this.jTable1.isRowSelectionAllowed, n, n2);
                this.jTable1.setValueAt("<DEFAULT>", n, n2);
                tableCellEditor.stopCellEditing();
            }
            this.jTable1.setRowSelectionInterval(n, n);
        }
    }

    private class TableKeyListener
    implements KeyListener {
        public void keyTyped(KeyEvent keyEvent) {
            InsertRecordDialog.this.processKeyEvents(keyEvent);
        }

        public void keyPressed(KeyEvent keyEvent) {
            InsertRecordDialog.this.processKeyEvents(keyEvent);
        }

        public void keyReleased(KeyEvent keyEvent) {
            InsertRecordDialog.this.processKeyEvents(keyEvent);
        }
    }

    public class TableSelectionListener
    implements ListSelectionListener {
        JTable table;

        TableSelectionListener(JTable jTable) {
            this.table = jTable;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getSource() == this.table.getSelectionModel() && this.table.getRowSelectionAllowed()) {
                InsertRecordDialog.this.refreshSQL();
            }
        }
    }
}

