/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.editors.ui;

import java.awt.Color;
import java.awt.Font;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class MessageArea
extends JLabel {
    private static final int WIDTH = 600;
    private static final int[] sizeMap = new int[]{8, 10, 12, 14, 18, 24, 36};
    private static final char[] hexVals = new char[]{'A', 'B', 'C', 'D', 'E', 'F'};
    private int width = 600;
    private String fontString;
    private boolean isBold;
    private boolean isItalic;
    private String msgs;
    private String msgString;
    private String endMsgs;
    private String endMsgString;
    private Vector bulletItems = new Vector();
    private String bulletItemString;

    public MessageArea() {
    }

    public MessageArea(String string) {
        this();
        this.setText(string);
    }

    public void addNotify() {
        super.addNotify();
        UIDefaults uIDefaults = UIManager.getDefaults();
        Color color = uIDefaults.getColor("OptionPane.background");
        if (color != null) {
            this.setBackground(color);
        }
        if ((color = uIDefaults.getColor("OptionPane.foreground")) != null) {
            this.setForeground(color);
        }
        if (this.fontString == null) {
            this.makeFontString(this.getFont(), this.getForeground());
        }
    }

    private void makeEntireMsg() {
        StringBuffer stringBuffer = new StringBuffer("<html><table width=\"" + this.width + "\"><tr>");
        if (this.fontString != null) {
            stringBuffer.append(this.fontString);
        }
        if (this.msgString != null) {
            stringBuffer.append(this.msgString);
        }
        if (this.bulletItemString != null) {
            stringBuffer.append(this.bulletItemString);
        }
        if (this.endMsgString != null) {
            stringBuffer.append(this.endMsgString);
        }
        if (this.isItalic) {
            stringBuffer.append("</i>");
        }
        if (this.isBold) {
            stringBuffer.append("</b>");
        }
        if (this.fontString != null) {
            stringBuffer.append("</font>");
        }
        stringBuffer.append("</tr></table></html>");
        super.setText(stringBuffer.toString());
    }

    private void makeMsgString() {
        if (this.msgs == null || this.msgs.length() < 1) {
            this.msgString = null;
        }
        this.msgString = this.msgs;
        this.makeEntireMsg();
    }

    private void makeEndMsgString() {
        if (this.endMsgs == null || this.endMsgs.length() < 1) {
            this.endMsgString = null;
        }
        this.endMsgString = this.endMsgs;
        this.makeEntireMsg();
    }

    private String toHex(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n / 16;
        if (n2 > 10) {
            stringBuffer.append(hexVals[n2 - 10]);
        } else {
            stringBuffer.append(n2);
        }
        n2 = n % 16;
        if (n2 > 10) {
            stringBuffer.append(hexVals[n2 - 10]);
        } else {
            stringBuffer.append(n2);
        }
        return stringBuffer.toString();
    }

    private String indexToOffset(int n) {
        int n2 = sizeMap.length / 2;
        if (n < n2) {
            return "-" + (n2 - n);
        }
        return "+" + (n - n2);
    }

    private String closestSize(int n) {
        if (n < sizeMap[0]) {
            return this.indexToOffset(0);
        }
        if (n >= sizeMap[sizeMap.length - 1]) {
            return this.indexToOffset(sizeMap.length - 1);
        }
        for (int i = 0; i < sizeMap.length - 1; ++i) {
            if (n == sizeMap[i]) {
                return this.indexToOffset(i);
            }
            if (n <= sizeMap[i] || n >= sizeMap[i + 1]) continue;
            int n2 = n - sizeMap[i];
            int n3 = sizeMap[i + 1] - n;
            if (n2 < n3) {
                return this.indexToOffset(i);
            }
            return this.indexToOffset(i + 1);
        }
        return this.indexToOffset(sizeMap.length / 2);
    }

    private void makeFontString(Font font, Color color) {
        StringBuffer stringBuffer = new StringBuffer("<font");
        if (font != null) {
            stringBuffer.append(" face=");
            stringBuffer.append(font.getName());
            stringBuffer.append(" size=");
            stringBuffer.append(this.closestSize(font.getSize()));
        }
        if (color != null) {
            stringBuffer.append(" color=\"#");
            stringBuffer.append(this.toHex(color.getRed()));
            stringBuffer.append(this.toHex(color.getGreen()));
            stringBuffer.append(this.toHex(color.getBlue()));
            stringBuffer.append("\"");
        }
        stringBuffer.append(">");
        if (font != null) {
            if ((font.getStyle() & 1) == 1) {
                stringBuffer.append("<b>");
                this.isBold = true;
            }
            if ((font.getStyle() & 2) == 2) {
                stringBuffer.append("<i>");
                this.isItalic = true;
            }
        }
        this.fontString = stringBuffer.toString();
        this.makeEntireMsg();
    }

    private void makeBulletItems() {
        if (this.bulletItems.isEmpty()) {
            this.bulletItemString = null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<ul>");
        for (int i = 0; i < this.bulletItems.size(); ++i) {
            String string = (String)this.bulletItems.elementAt(i);
            stringBuffer.append("<li>" + string + "</li>");
        }
        stringBuffer.append("</ul>");
        this.bulletItemString = stringBuffer.toString();
        this.makeEntireMsg();
    }

    public void setWidth(int n) {
        this.width = n;
        this.makeEntireMsg();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.makeFontString(font, this.getForeground());
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.makeFontString(this.getFont(), color);
    }

    private void tokenizeString(String string, Vector vector) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        if (stringTokenizer.countTokens() > 1) {
            while (stringTokenizer.hasMoreTokens()) {
                vector.add(stringTokenizer.nextToken());
            }
        } else {
            vector.add(string);
        }
    }

    public void setText(String string) {
        this.msgs = string.replace('\n', ' ');
        this.makeMsgString();
    }

    public void setEndText(String string) {
        this.endMsgs = string.replace('\n', ' ');
        this.makeEndMsgString();
    }

    public void appendText(String string) {
        String string2 = string.replace('\n', ' ');
        this.msgs = this.msgs.concat(string2);
        this.makeMsgString();
    }

    public void setBulletItems(String string) {
        this.bulletItems.clear();
        this.tokenizeString(string, this.bulletItems);
        this.makeBulletItems();
    }

    public void setBulletItems(List list) {
        this.bulletItems.clear();
        this.bulletItems.addAll(list);
        this.makeBulletItems();
    }

    public void setBulletItems(String[] stringArray) {
        this.bulletItems.clear();
        for (int i = 0; i < stringArray.length; ++i) {
            this.bulletItems.add(stringArray[i]);
        }
        this.makeBulletItems();
    }

    public void appendBulletItem(String string) {
        this.tokenizeString(string, this.bulletItems);
        this.makeBulletItems();
    }

    public void appendBulletItems(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.bulletItems.add(stringArray[i]);
        }
        this.makeBulletItems();
    }

    public void appendBulletItems(List list) {
        this.bulletItems.addAll(list);
        this.makeBulletItems();
    }
}

