/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.indicators.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import org.netbeans.modules.dlight.indicators.graph.CyclicArray;
import org.netbeans.modules.dlight.indicators.graph.Graph;
import org.netbeans.modules.dlight.indicators.graph.GraphConfig;
import org.netbeans.modules.dlight.indicators.graph.GraphDescriptor;

class GraphPainter {
    private static final int MAX_ALPHA = 255;
    private static final Stroke BALL_STROKE = new BasicStroke(1.0f);
    private static final Stroke LINE_STROKE = new BasicStroke(2.0f);
    private final Graph.LabelRenderer renderer;
    private final GraphDescriptor[] descriptors;
    private final int seriesCount;
    private CyclicArray<int[]> data;
    private final Object dataLock = new Object();

    public GraphPainter(Graph.LabelRenderer labelRenderer, GraphDescriptor ... graphDescriptorArray) {
        this.descriptors = graphDescriptorArray;
        this.renderer = labelRenderer;
        this.seriesCount = graphDescriptorArray.length;
        this.data = new CyclicArray(1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addData(int ... nArray) {
        Object object = this.dataLock;
        synchronized (object) {
            if (nArray.length != this.seriesCount) {
                throw new IllegalArgumentException(String.format("New data size %d differs from series count %d", nArray.length, this.seriesCount));
            }
            this.data.add((int[])nArray.clone());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
        Object object = this.dataLock;
        synchronized (object) {
            GraphPainter.paintGradient(graphics, n2, n3, n4, n5);
            if (10 < n4 && 10 < n5) {
                this.paintGrid(graphics, n2, n3, n4, n5, bl);
                this.paintGraph(graphics, n, n2, n3, n4, n5);
            }
        }
    }

    private static void paintGradient(Graphics graphics, int n, int n2, int n3, int n4) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, GraphConfig.GRADIENT_TOP_COLOR, 0.0f, n4, GraphConfig.GRADIENT_BOTTOM_COLOR);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(n, n2, n3, n4);
        graphics2D.setPaint(paint);
    }

    private void paintGrid(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        int n5;
        graphics.setColor(GraphConfig.GRID_COLOR);
        int n6 = 5 * (this.data.size() - n3 / 5 + 1);
        int n7 = n6 > 0 ? 10 - n6 % 10 : 0;
        for (n5 = n + n7; n5 < n + n3; n5 += 10) {
            graphics.drawLine(n5, n2, n5, n2 + n4 - 1);
        }
        if (bl) {
            graphics.setColor(GraphConfig.BORDER_COLOR);
            for (n5 = n + n7; n5 < n + n3; n5 += 10) {
                graphics.drawLine(n5, n2 + n4 - 1, n5, n2 + n4 - 5);
            }
        }
        GraphPainter.paintHLine(graphics, n, n + n3 - 1, n2 + 5, 255, bl);
        GraphPainter.paintHLine(graphics, n, n + n3 - 1, n2 + n4 - 1, 255, bl);
        GraphPainter.paintHLines(graphics, n, n2 + 5, n + n3 - 1, n2 + n4 - 1, bl);
    }

    private static void paintHLines(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        if (n4 - n2 <= 10) {
            return;
        }
        int n5 = (n2 + n4) / 2;
        GraphPainter.paintHLine(graphics, n, n3, n5, GraphPainter.map(n4 - n2, 15, 20, 0, 255), bl);
        if (20 <= n4 - n2) {
            GraphPainter.paintHLines(graphics, n, n2, n3, n5, bl);
            GraphPainter.paintHLines(graphics, n, n5, n3, n4, bl);
        }
    }

    private static void paintHLine(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        graphics.setColor(GraphPainter.transparent(GraphConfig.GRID_COLOR, n4));
        graphics.drawLine(n, n3, n2, n3);
        if (bl) {
            graphics.setColor(GraphPainter.transparent(GraphConfig.BORDER_COLOR, n4));
            graphics.drawLine(n, n3, n + 5, n3);
        }
    }

    private void paintGraph(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Stroke stroke = graphics2D.getStroke();
        int n6 = Math.min(n4 / 5, this.data.size()) - 1;
        if (0 < n6) {
            int[] nArray = new int[n6 + 2];
            int[] nArray2 = new int[n6 + 2];
            int n7 = Math.max(0, this.data.size() - n6);
            int n8 = (int)((float)(n5 - 2) - 5.0f);
            block4: for (int i = 0; i < this.seriesCount; ++i) {
                int n9 = 0;
                int n10 = 0;
                for (int j = 0; j < n6; ++j) {
                    int n11;
                    int[] nArray3 = this.data.get(n7 + j);
                    int n12 = nArray3[i];
                    int n13 = 0;
                    if (this.descriptors[i].getKind() == GraphDescriptor.Kind.REL_SURFACE) {
                        for (n11 = i + 1; n11 < this.seriesCount; ++n11) {
                            if (this.descriptors[n11].getKind() != GraphDescriptor.Kind.REL_SURFACE) continue;
                            n12 += nArray3[n11];
                        }
                    } else if (this.descriptors[i].getKind() == GraphDescriptor.Kind.ABS_SURFACE) {
                        for (n11 = i + 1; n11 < this.seriesCount; ++n11) {
                            if (this.descriptors[n11].getKind() != GraphDescriptor.Kind.ABS_SURFACE) continue;
                            n13 += 2;
                        }
                    }
                    nArray[j] = n9 = n2 + 5 * j;
                    nArray2[j] = n10 = (int)((long)(n3 + n5 - 2) - (long)n12 * (long)n8 / (long)n) - n13;
                }
                graphics2D.setColor(this.descriptors[i].getColor());
                switch (this.descriptors[i].getKind()) {
                    case LINE: {
                        graphics2D.setStroke(LINE_STROKE);
                        graphics2D.drawPolyline(nArray, nArray2, n6);
                        graphics2D.setStroke(BALL_STROKE);
                        graphics2D.setColor(Color.WHITE);
                        graphics2D.fillOval(n9 - 2, n10 - 2, 4, 4);
                        graphics2D.setColor(this.descriptors[i].getColor());
                        graphics2D.drawOval(n9 - 2, n10 - 2, 4, 4);
                        continue block4;
                    }
                    case ABS_SURFACE: 
                    case REL_SURFACE: {
                        nArray[n6] = n9;
                        nArray[n6 + 1] = n2;
                        int n14 = n3 + n5;
                        nArray2[n6 + 1] = n14;
                        nArray2[n6] = n14;
                        graphics2D.fillPolygon(nArray, nArray2, n6 + 2);
                        continue block4;
                    }
                    default: {
                        System.err.println("Uknown graph kind: " + (Object)((Object)this.descriptors[i].getKind()));
                    }
                }
            }
        }
        graphics2D.setStroke(stroke);
    }

    public void paintVerticalAxis(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(color);
        graphics2D.fillRect(n, n2, n3, n4);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setFont(graphics2D.getFont().deriveFont(10.0f));
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        this.paintVLabel(graphics, n5, n + n3 - 1 - fontMetrics.getAscent() / 2, n2 + fontMetrics.getAscent() / 2, 255, fontMetrics);
        this.paintVLabels(graphics, n, n3, n2 + fontMetrics.getAscent() / 2, n2 + n4 - 1, n5, 0, fontMetrics);
    }

    private void paintVLabels(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, FontMetrics fontMetrics) {
        if (n4 - n3 <= 2 * fontMetrics.getAscent() || n5 <= n6 + 1) {
            return;
        }
        int n7 = (n4 + n3) / 2;
        int n8 = (n5 + n6) / 2;
        this.paintVLabel(graphics, n8, n + n2 - 1 - fontMetrics.getAscent() / 2, n7, GraphPainter.map(n4 - n3, 5 * fontMetrics.getAscent() / 2, 3 * fontMetrics.getAscent(), 0, 255), fontMetrics);
        if (4 * fontMetrics.getAscent() <= n4 - n3) {
            this.paintVLabels(graphics, n, n2, n3, n7, n5, n8, fontMetrics);
            this.paintVLabels(graphics, n, n2, n7, n4, n8, n6, fontMetrics);
        }
    }

    private void paintVLabel(Graphics graphics, int n, int n2, int n3, int n4, FontMetrics fontMetrics) {
        String string = this.renderer == null ? Integer.toString(n) : this.renderer.render(n);
        int n5 = fontMetrics.stringWidth(string);
        graphics.setColor(GraphPainter.transparent(GraphConfig.TEXT_COLOR, n4));
        graphics.drawString(string, n2 - n5, n3 + fontMetrics.getAscent() / 2);
    }

    private static int map(int n, int n2, int n3, int n4, int n5) {
        if (n <= n2) {
            return n4;
        }
        if (n < n3) {
            return n4 + (n - n2) * (n5 - n4) / (n3 - n2);
        }
        return n5;
    }

    private static Color transparent(Color color, int n) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
    }
}

