/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.indicators.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.dlight.indicators.graph.GraphConfig;
import org.netbeans.modules.dlight.indicators.graph.GraphDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Legend
extends JPanel {
    public Legend(List<GraphDescriptor> list, Map<String, String> map) {
        super(new GridBagLayout());
        GridBagConstraints gridBagConstraints;
        JLabel jLabel;
        this.setBackground(GraphConfig.LEGEND_COLOR);
        this.setBorder(BorderFactory.createLineBorder(GraphConfig.BORDER_COLOR));
        this.setSize(new Dimension(80, 60));
        this.setMinimumSize(new Dimension(80, 60));
        this.setPreferredSize(new Dimension(80, 60));
        this.setOpaque(true);
        for (GraphDescriptor object : list) {
            jLabel = new JLabel(object.getDescription(), new ColorIcon(object.getColor()), 10);
            jLabel.setForeground(GraphConfig.TEXT_COLOR);
            jLabel.setFont(jLabel.getFont().deriveFont(10.0f));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(4, 4, 0, 4);
            this.add((Component)jLabel, gridBagConstraints);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(Box.createVerticalStrut(4), gridBagConstraints);
        for (Map.Entry entry : map.entrySet()) {
            jLabel = new JLabel((String)entry.getValue());
            jLabel.setForeground(GraphConfig.TEXT_COLOR);
            jLabel.setFont(jLabel.getFont().deriveFont(10.0f));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 4, 4, 4);
            this.add((Component)jLabel, gridBagConstraints);
            JLabel jLabel2 = new JLabel();
            jLabel2.setName((String)entry.getKey());
            jLabel2.setForeground(GraphConfig.TEXT_COLOR);
            jLabel2.setFont(jLabel2.getFont().deriveFont(1, 10.0f));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 4, 4);
            this.add((Component)jLabel2, gridBagConstraints);
        }
    }

    public void updateDetail(final String string, final String string2) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateDetailImpl(string, string2);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Legend.this.updateDetailImpl(string, string2);
                }
            });
        }
    }

    private void updateDetailImpl(String string, String string2) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof JLabel) || !string.equals(component.getName())) continue;
            ((JLabel)component).setText(string2);
            this.repaint();
            break;
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.isEnabled()) {
            super.paintComponent(graphics);
        } else {
            graphics.setColor(GraphConfig.LEGEND_COLOR);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    protected void paintChildren(Graphics graphics) {
        if (this.isEnabled()) {
            super.paintChildren(graphics);
        }
    }

    private static class ColorIcon
    implements Icon {
        private static final int WIDTH = 10;
        private static final int HEIGHT = 10;
        private final Color color;

        public ColorIcon(Color color) {
            this.color = color;
        }

        public int getIconWidth() {
            return 10;
        }

        public int getIconHeight() {
            return 10;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setPaint(this.color);
            graphics2D.fillRect(n, n2, 9, 9);
            graphics2D.setPaint(GraphConfig.BORDER_COLOR);
            graphics2D.drawRect(n, n2, 9, 9);
        }
    }
}

