/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.vcs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.util.BugtrackingOwnerSupport;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugtracking.vcs.FormatPanel;
import org.netbeans.modules.bugtracking.vcs.HookPanel;
import org.netbeans.modules.bugtracking.vcs.VCSHooksConfig;
import org.netbeans.modules.subversion.hooks.spi.SvnHook;
import org.netbeans.modules.subversion.hooks.spi.SvnHookContext;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnHookImpl
extends SvnHook {
    private HookPanel panel;
    private final String name = NbBundle.getMessage(SvnHookImpl.class, (String)"LBL_VCSHook");
    private static Logger LOG = Logger.getLogger("org.netbeans.modules.bugtracking.vcshooks.SvnHook");
    private static final SimpleDateFormat CC_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public SvnHookContext beforeCommit(SvnHookContext svnHookContext) throws IOException {
        Object object;
        Repository repository = this.panel.getSelectedRepository();
        if (svnHookContext.getFiles().length == 0) {
            if (repository != null) {
                BugtrackingOwnerSupport.getInstance().setLooseAssociation(BugtrackingOwnerSupport.ContextType.MAIN_OR_SINGLE_PROJECT, repository);
            }
            LOG.warning("calling svn beforeCommit for zero files");
            return null;
        }
        if (repository != null) {
            BugtrackingOwnerSupport.getInstance().setFirmAssociations(svnHookContext.getFiles(), repository);
        }
        File file = svnHookContext.getFiles()[0];
        LOG.log(Level.FINE, "svn beforeCommit start for " + file);
        String string = svnHookContext.getMessage();
        if (this.panel.addIssueCheckBox.isSelected()) {
            object = VCSHooksConfig.getInstance().getSvnIssueFormat();
            String string2 = ((VCSHooksConfig.Format)object).getFormat();
            string2 = string2.replaceAll("\\{id\\}", "\\{0\\}");
            string2 = string2.replaceAll("\\{summary\\}", "\\{1\\}");
            Issue issue = this.panel.getIssue();
            if (issue == null) {
                LOG.log(Level.FINE, " no issue set for " + file);
                return null;
            }
            String string3 = new MessageFormat(string2).format(new Object[]{issue.getID(), issue.getSummary()}, new StringBuffer(), (FieldPosition)null).toString();
            LOG.log(Level.FINER, " svn commit hook issue info '" + string3 + "'");
            string = ((VCSHooksConfig.Format)object).isAbove() ? string3 + "\n" + string : string + "\n" + string3;
        }
        object = null;
        if (this.panel.addRevisionCheckBox.isSelected()) {
            object = new ArrayList();
        }
        return new SvnHookContext(svnHookContext.getFiles(), string, (List)object);
    }

    public void afterCommit(SvnHookContext svnHookContext) {
        if (svnHookContext.getFiles().length == 0) {
            LOG.warning("calling svn afterCommit for zero files");
            return;
        }
        File file = svnHookContext.getFiles()[0];
        LOG.log(Level.FINE, "svn afterCommit start for " + file);
        if (!(this.panel.addCommentCheckBox.isSelected() || this.panel.addRevisionCheckBox.isSelected() || this.panel.resolveCheckBox.isSelected())) {
            LOG.log(Level.FINER, " nothing to do in svn afterCommit for " + file);
            return;
        }
        Issue issue = this.panel.getIssue();
        if (issue == null) {
            LOG.log(Level.FINE, " no issue set for " + file);
            return;
        }
        String string = svnHookContext.getMessage();
        if (!this.panel.addCommentCheckBox.isSelected() || string == null || string.trim().equals("")) {
            string = null;
        }
        if (this.panel.addRevisionCheckBox.isSelected()) {
            List list = svnHookContext.getLogEntries();
            assert (list.size() > 0);
            SvnHookContext.LogEntry logEntry = (SvnHookContext.LogEntry)list.get(0);
            String string2 = logEntry.getAuthor();
            String string3 = this.getRevisions(list);
            Date date = logEntry.getDate();
            String string4 = logEntry.getMessage();
            String string5 = VCSHooksConfig.getInstance().getSvnCommentFormat().getFormat();
            string5 = string5.replaceAll("\\{revision\\}", "\\{0\\}");
            string5 = string5.replaceAll("\\{author\\}", "\\{1\\}");
            string5 = string5.replaceAll("\\{date\\}", "\\{2\\}");
            string5 = string5.replaceAll("\\{message\\}", "\\{3\\}");
            string = new MessageFormat(string5).format(new Object[]{string3, string2, date != null ? CC_DATE_FORMAT.format(date) : "", string4}, new StringBuffer(), (FieldPosition)null).toString();
            LOG.log(Level.FINER, " svn commit hook message '" + string + "'");
        }
        issue.addComment(string, this.panel.resolveCheckBox.isSelected());
        issue.open();
        LOG.log(Level.FINE, "svn commit hook end for " + file);
    }

    public JPanel createComponent(SvnHookContext svnHookContext) {
        Repository[] repositoryArray = BugtrackingUtil.getKnownRepositories();
        if (svnHookContext.getFiles().length == 0) {
            LOG.warning("creating svn hook component for zero files");
            Repository repository = BugtrackingOwnerSupport.getInstance().getRepository(BugtrackingOwnerSupport.ContextType.ALL_PROJECTS);
            this.panel = new HookPanel(repositoryArray, repository);
        } else {
            File file = svnHookContext.getFiles()[0];
            Repository repository = BugtrackingOwnerSupport.getInstance().getRepository(file, false);
            if (repository == null) {
                LOG.log(Level.FINE, " could not find issue tracker for " + file);
            }
            this.panel = new HookPanel(repositoryArray, repository);
        }
        this.panel.commitRadioButton.setVisible(false);
        this.panel.pushRadioButton.setVisible(false);
        this.panel.changeRevisionFormatButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SvnHookImpl.this.onShowRevisionFormat();
            }
        });
        this.panel.changeIssueFormatButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SvnHookImpl.this.onShowIssueFormat();
            }
        });
        return this.panel;
    }

    public String getDisplayName() {
        return this.name;
    }

    private String getRevisions(List<SvnHookContext.LogEntry> list) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<SvnHookContext.LogEntry> iterator = list.iterator();
        while (iterator.hasNext()) {
            SvnHookContext.LogEntry logEntry = iterator.next();
            stringBuffer.append(logEntry.getRevision());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    private void onShowRevisionFormat() {
        FormatPanel formatPanel = new FormatPanel(VCSHooksConfig.getInstance().getSvnCommentFormat());
        if (BugtrackingUtil.show((JPanel)formatPanel, (String)NbBundle.getMessage(HookPanel.class, (String)"LBL_FormatTitle"), (String)NbBundle.getMessage(HookPanel.class, (String)"LBL_OK"))) {
            VCSHooksConfig.getInstance().setSvnCommentFormat(formatPanel.getFormat());
        }
    }

    private void onShowIssueFormat() {
        FormatPanel formatPanel = new FormatPanel(VCSHooksConfig.getInstance().getSvnIssueFormat());
        if (BugtrackingUtil.show((JPanel)formatPanel, (String)NbBundle.getMessage(HookPanel.class, (String)"LBL_FormatTitle"), (String)NbBundle.getMessage(HookPanel.class, (String)"LBL_OK"))) {
            VCSHooksConfig.getInstance().setSvnIssueFormat(formatPanel.getFormat());
        }
    }
}

