/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools;

import java.awt.Container;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.jellytools.EditorOperator;
import org.netbeans.jellytools.MainWindowOperator;
import org.netbeans.jellytools.TopComponentOperator;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JTableOperator;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class EditorWindowOperator {
    private static JButtonOperator _btLeft;
    private static JButtonOperator _btRight;
    private static JButtonOperator _btDown;

    public static JButtonOperator btLeft() {
        if (_btLeft == null) {
            _btLeft = new JButtonOperator(new ContainerOperator(EditorWindowOperator.getEditor().findTabDisplayer()), 0);
        }
        return _btLeft;
    }

    public static JButtonOperator btRight() {
        if (_btRight == null) {
            _btRight = new JButtonOperator(new ContainerOperator(EditorWindowOperator.getEditor().findTabDisplayer()), 1);
        }
        return _btRight;
    }

    public static JButtonOperator btDown() {
        if (_btDown == null) {
            _btDown = new JButtonOperator(new ContainerOperator(EditorWindowOperator.getEditor().findTabDisplayer()), 2);
        }
        return _btDown;
    }

    public static void closeDiscard() {
        EditorWindowOperator.closeDiscard(EditorWindowOperator.findEditorMode());
    }

    public static void closeDiscard(final Mode mode) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    Iterator<TopComponent> iterator = Arrays.asList(mode.getTopComponents()).iterator();
                    while (iterator.hasNext()) {
                        EditorOperator.close(iterator.next(), false);
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            throw new JemmyException("Interrupted!", (Throwable)interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new JemmyException("Exception while closing.", (Throwable)invocationTargetException);
        }
    }

    public static EditorOperator selectPage(String string) {
        return new EditorOperator(string);
    }

    public static EditorOperator selectPage(int n) {
        try {
            new TopComponentOperator((JComponent)((TopComponent)EditorWindowOperator.getEditor().findTabbedAdapter().getModel().getTab(n).getComponent()));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new JemmyException("Index " + n + " out of bounds.", (Throwable)indexOutOfBoundsException);
        }
        return EditorWindowOperator.getEditor();
    }

    public static EditorOperator getEditor() {
        final Mode mode = EditorWindowOperator.findEditorMode();
        String string = (String)new QueueTool().invokeSmoothly(new QueueTool.QueueAction("getSelectedTopComponent().getName()"){

            public Object launch() {
                return mode.getSelectedTopComponent().getName();
            }
        });
        return new EditorOperator(string);
    }

    public static EditorOperator getEditor(String string) {
        return EditorWindowOperator.selectPage(string);
    }

    public static EditorOperator getEditor(int n) {
        return EditorWindowOperator.selectPage(n);
    }

    public boolean jumpLeft() {
        if (EditorWindowOperator.btLeft().isEnabled()) {
            Container container = EditorWindowOperator.getEditor().findTabDisplayer();
            new ContainerOperator(container).clickMouse(container.getX() + 1, container.getY() + container.getHeight() / 2, 1);
            return true;
        }
        return false;
    }

    public static void moveTabsRight() {
        EditorWindowOperator.btRight().push();
    }

    public static void moveTabsLeft() {
        EditorWindowOperator.btLeft().push();
    }

    public static void selectDocument(int n) {
        EditorWindowOperator.btDown().push();
        JTableOperator jTableOperator = new JTableOperator((ContainerOperator)MainWindowOperator.getDefault());
        jTableOperator.selectCell(n, 0);
    }

    public static void selectDocument(String string) {
        EditorWindowOperator.btDown().push();
        JTableOperator jTableOperator = new JTableOperator((ContainerOperator)MainWindowOperator.getDefault());
        int n = jTableOperator.findCellRow(string);
        if (n <= -1) {
            throw new JemmyException("Cannot select document \"" + string + "\".");
        }
        jTableOperator.selectCell(n, 0);
    }

    public static void verify() {
        EditorWindowOperator.getEditor().verify();
    }

    private static Mode findEditorMode() {
        return (Mode)new QueueTool().invokeSmoothly(new QueueTool.QueueAction("findMode"){

            public Object launch() {
                return WindowManager.getDefault().findMode("editor");
            }
        });
    }
}

