/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.compilers.Tool;
import org.netbeans.modules.cnd.api.compilers.ToolchainProject;
import org.netbeans.modules.cnd.api.execution.ExecutionListener;
import org.netbeans.modules.cnd.api.execution.NativeExecutor;
import org.netbeans.modules.cnd.api.remote.RemoteProject;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.builds.MakeExecSupport;
import org.netbeans.modules.cnd.settings.CppSettings;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.spi.project.FileOwnerQueryImplementation;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public abstract class AbstractExecutorRunAction
extends NodeAction {
    protected boolean enable(Node[] nodeArray) {
        DataObject dataObject;
        boolean bl = false;
        bl = nodeArray == null || nodeArray.length == 0 || nodeArray.length > 1 ? false : this.accept(dataObject = (DataObject)nodeArray[0].getCookie(DataObject.class));
        return bl;
    }

    protected abstract boolean accept(DataObject var1);

    protected static ExecutionEnvironment getExecutionEnvironment(FileObject fileObject, Project project) {
        ExecutionEnvironment executionEnvironment;
        RemoteProject remoteProject;
        if (project == null) {
            project = AbstractExecutorRunAction.findInOpenedProject(fileObject);
        }
        ExecutionEnvironment executionEnvironment2 = CompilerSetManager.getDefaultExecutionEnvironment();
        if (project != null && (remoteProject = (RemoteProject)project.getLookup().lookup(RemoteProject.class)) != null && (executionEnvironment = remoteProject.getDevelopmentHost()) != null) {
            executionEnvironment2 = executionEnvironment;
        }
        return executionEnvironment2;
    }

    private static Project findInOpenedProject(FileObject fileObject) {
        Collection collection = Lookup.getDefault().lookupAll(FileOwnerQueryImplementation.class);
        for (FileOwnerQueryImplementation fileOwnerQueryImplementation : collection) {
            Project project = fileOwnerQueryImplementation.getOwner(fileObject);
            if (project == null) continue;
            for (Project project2 : OpenProjects.getDefault().getOpenProjects()) {
                if (project != project2) continue;
                return project;
            }
        }
        return null;
    }

    private Project findProject(Node node) {
        Node node2 = node;
        while (true) {
            Project project;
            if ((project = (Project)node2.getLookup().lookup(Project.class)) != null) {
                return project;
            }
            Node node3 = node2.getParentNode();
            if (node3 == null || node3 == node2) break;
            node2 = node3;
        }
        return null;
    }

    protected String getMakeCommand(Node node, Project project) {
        Object object;
        Object object2;
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        FileObject fileObject = dataObject.getPrimaryFile();
        if (project == null) {
            project = this.findProject(node);
        }
        if (project == null) {
            project = AbstractExecutorRunAction.findInOpenedProject(fileObject);
        }
        CompilerSet compilerSet = null;
        if (project != null && (object2 = (ToolchainProject)project.getLookup().lookup(ToolchainProject.class)) != null) {
            compilerSet = object2.getCompilerSet();
        }
        if (compilerSet == null) {
            compilerSet = CompilerSetManager.getDefault().getDefaultCompilerSet();
        }
        object2 = null;
        if (compilerSet != null && (object = compilerSet.findTool(5)) != null) {
            object2 = ((Tool)object).getPath();
        }
        if (object2 == null || ((String)object2).length() == 0) {
            object = (MakeExecSupport)node.getCookie(MakeExecSupport.class);
            object2 = object != null ? ((MakeExecSupport)object).getMakeCommand() : "make";
        }
        return object2;
    }

    protected File getBuildDirectory(Node node) {
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        FileObject fileObject = dataObject.getPrimaryFile();
        File file = FileUtil.toFile((FileObject)fileObject);
        MakeExecSupport makeExecSupport = (MakeExecSupport)node.getCookie(MakeExecSupport.class);
        String string = makeExecSupport != null ? makeExecSupport.getBuildDirectory() : file.getParent();
        File file2 = AbstractExecutorRunAction.getAbsoluteBuildDir(string, file);
        return file2;
    }

    protected static String[] prepareEnv(ExecutionEnvironment executionEnvironment) {
        Object object;
        CompilerSet compilerSet = null;
        String string = "";
        String string2 = CppSettings.getDefault().getCompilerSetName();
        PlatformInfo platformInfo = PlatformInfo.getDefault(executionEnvironment);
        if (string2 != null && string2.length() > 0 && (compilerSet = CompilerSetManager.getDefault(executionEnvironment).getCompilerSet(string2)) != null) {
            string = compilerSet.getDirectory();
            object = compilerSet.getCompilerFlavor().getCommandFolder(platformInfo.getPlatform());
            if (object != null && ((String)object).length() > 0) {
                string = string + platformInfo.pathSeparator() + (String)object;
            }
        }
        object = string.length() > 0 ? new String[]{platformInfo.getPathAsStringWith(string)} : new String[]{};
        return object;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected static final String getString(String string) {
        return NbBundle.getBundle(AbstractExecutorRunAction.class).getString(string);
    }

    protected static final String getString(String string, String string2) {
        return NbBundle.getMessage(AbstractExecutorRunAction.class, (String)string, (Object)string2);
    }

    private static ProgressHandle createPogressHandle(final AbstractAction abstractAction, final NativeExecutor nativeExecutor) {
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)nativeExecutor.getTabeName(), (Cancellable)new Cancellable(){

            public boolean cancel() {
                abstractAction.actionPerformed(null);
                return true;
            }
        }, (Action)new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                nativeExecutor.getTab().select();
            }
        });
        progressHandle.setInitialDelay(0);
        return progressHandle;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected static File getAbsoluteBuildDir(String string, File file) {
        File file2 = string.length() == 0 || string.equals(".") ? file.getParentFile() : (IpeUtils.isPathAbsolute(string) ? new File(string) : new File(file.getParentFile(), string));
        file2 = CndFileUtils.normalizeFile((File)file2.getAbsoluteFile());
        return file2;
    }

    private static final class StopAction
    extends AbstractAction {
        private final ShellExecuter shellExecutor;

        public StopAction(ShellExecuter shellExecuter) {
            this.shellExecutor = shellExecuter;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            this.setEnabled(false);
            if (this.shellExecutor.getExecutorTask() != null) {
                this.shellExecutor.getExecutorTask().stop();
            }
        }
    }

    protected static class ShellExecuter
    implements ExecutionListener {
        private final NativeExecutor nativeExecutor;
        private final ProgressHandle progressHandle;
        private ExecutorTask executorTask = null;

        public ShellExecuter(NativeExecutor nativeExecutor, ExecutionListener executionListener) {
            this.nativeExecutor = nativeExecutor;
            nativeExecutor.addExecutionListener(this);
            if (executionListener != null) {
                nativeExecutor.addExecutionListener(executionListener);
            }
            this.progressHandle = AbstractExecutorRunAction.createPogressHandle(new StopAction(this), nativeExecutor);
        }

        public void execute() {
            try {
                this.executorTask = this.nativeExecutor.execute();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void executionFinished(int n) {
            this.progressHandle.finish();
        }

        public void executionStarted() {
            this.progressHandle.start();
        }

        public ExecutorTask getExecutorTask() {
            return this.executorTask;
        }
    }
}

