/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.actions;

import java.io.File;
import java.io.IOException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

class OpenWithQtDesignerAction
extends NodeAction {
    private static final String QTUI_MIME_TYPE = "text/qtui+xml";
    private static final String DESIGNER_EXECUTABLE = "designer";
    private final String name = NbBundle.getMessage(OpenWithQtDesignerAction.class, (String)"LBL_OpenWithQtDesigner");

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return this.name;
    }

    protected boolean enable(Node[] nodeArray) {
        return OpenWithQtDesignerAction.getUiFile(nodeArray) != null;
    }

    protected void performAction(Node[] nodeArray) {
        File file = OpenWithQtDesignerAction.getUiFile(nodeArray);
        if (file != null) {
            ProcessBuilder processBuilder = new ProcessBuilder(DESIGNER_EXECUTABLE, file.getAbsolutePath());
            try {
                processBuilder.start();
            }
            catch (IOException iOException) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(OpenWithQtDesignerAction.class, (String)"MSG_OpenWithQtDesignerFailed", (Object)DESIGNER_EXECUTABLE)));
            }
        }
    }

    private static File getUiFile(Node[] nodeArray) {
        File file;
        FileObject fileObject;
        DataObject dataObject;
        if (nodeArray != null && nodeArray.length == 1 && (dataObject = (DataObject)nodeArray[0].getCookie(DataObject.class)) != null && (fileObject = dataObject.getPrimaryFile()) != null && QTUI_MIME_TYPE.equals(fileObject.getMIMEType()) && (file = FileUtil.toFile((FileObject)fileObject)) != null) {
            return file;
        }
        return null;
    }
}

