/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.compilers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;

public class CompilerSetManagerEvents {
    private static final Map<ExecutionEnvironment, CompilerSetManagerEvents> map = new HashMap<ExecutionEnvironment, CompilerSetManagerEvents>();
    private final ExecutionEnvironment executionEnvironment;
    private boolean isCodeModelInfoReady;
    private List<Runnable> tasks = new ArrayList<Runnable>();

    public static synchronized CompilerSetManagerEvents get(ExecutionEnvironment executionEnvironment) {
        CompilerSetManagerEvents compilerSetManagerEvents = map.get(executionEnvironment);
        if (compilerSetManagerEvents == null) {
            compilerSetManagerEvents = new CompilerSetManagerEvents(executionEnvironment);
            map.put(executionEnvironment, compilerSetManagerEvents);
        }
        return compilerSetManagerEvents;
    }

    public CompilerSetManagerEvents(ExecutionEnvironment executionEnvironment) {
        this.executionEnvironment = executionEnvironment;
        this.isCodeModelInfoReady = CompilerSetManager.getDefault(this.executionEnvironment).isComplete();
    }

    public void runOnCodeModelReadiness(Runnable runnable) {
        if (this.executionEnvironment.isLocal() || this.isCodeModelInfoReady) {
            runnable.run();
        } else {
            this.tasks.add(runnable);
        }
    }

    void runTasks() {
        this.isCodeModelInfoReady = true;
        if (this.tasks != null) {
            for (Runnable runnable : this.tasks) {
                runnable.run();
            }
        }
        this.tasks = null;
    }
}

