/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.builds;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.NbBundle;

public class TargetEditor
extends JPanel
implements PropertyChangeListener {
    private JList targetList = null;
    private Vector<String> listData = new Vector();
    private Timer isVisibleTimer;
    private PropertyEditorSupport editor;
    private JDialog dialog = null;
    private JButton okButton;
    private JButton cancelButton;
    private int returnValue = 0;
    public static final int OK_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    private ResourceBundle bundle = NbBundle.getBundle(TargetEditor.class);
    private JButton addButton;
    private JPanel controlsPanel;
    private JPanel dataPanel;
    private JButton downButton;
    private JButton editButton;
    private JLabel listLabel;
    private JButton removeButton;
    private JScrollPane scrollPane;
    private JButton upButton;

    public TargetEditor(String[] stringArray, PropertyEditorSupport propertyEditorSupport, PropertyEnv propertyEnv) {
        this.editor = propertyEditorSupport;
        this.initComponents();
        this.addButton.setMnemonic(this.bundle.getString("TARGET_EDITOR_ADD_BUTTON_MNEMONIC").toCharArray()[0]);
        this.editButton.setMnemonic(this.bundle.getString("TARGET_EDITOR_CHANGE_BUTTON_MNEMONIC").toCharArray()[0]);
        this.removeButton.setMnemonic(this.bundle.getString("TARGET_EDITOR_REMOVE_BUTTON_MNEMONIC").toCharArray()[0]);
        this.upButton.setMnemonic(this.bundle.getString("TARGET_EDITOR_UP_BUTTON_MNEMONIC").toCharArray()[0]);
        this.downButton.setMnemonic(this.bundle.getString("TARGET_EDITOR_DOWN_BUTTON_MNEMONIC").toCharArray()[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            this.listData.add(stringArray[i]);
        }
        this.targetList = new JList();
        this.targetList.setListData(this.listData);
        this.targetList.addListSelectionListener(new TargetSelectionListener());
        this.targetList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                TargetEditor.this.targetListKeyPressed(keyEvent);
            }
        });
        this.scrollPane.setViewportView(this.targetList);
        this.listLabel.setLabelFor(this.targetList);
        this.checkSelection();
        this.initAccessibility();
        this.isVisibleTimer = new Timer(100, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TargetEditor.this.addButton.isVisible()) {
                    if (TargetEditor.this.targetList.getModel().getSize() > 0) {
                        TargetEditor.this.targetList.setSelectedIndex(0);
                        TargetEditor.this.targetList.requestFocus();
                    } else {
                        TargetEditor.this.addButton.requestFocus();
                    }
                    TargetEditor.this.isVisibleTimer.stop();
                }
            }
        });
        this.isVisibleTimer.start();
        if (propertyEnv != null) {
            propertyEnv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
            propertyEnv.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    private void initAccessibility() {
        AccessibleContext accessibleContext = this.getAccessibleContext();
        accessibleContext.setAccessibleName(this.bundle.getString("ACSN_TARGET_EDITOR"));
        accessibleContext.setAccessibleDescription(this.bundle.getString("ACSD_TARGET_EDITOR"));
        accessibleContext = this.targetList.getAccessibleContext();
        accessibleContext.setAccessibleName(this.bundle.getString("ACSN_TARGET_LIST"));
        accessibleContext.setAccessibleDescription(this.bundle.getString("ACSD_TARGET_LIST"));
        accessibleContext = this.scrollPane.getAccessibleContext();
        accessibleContext.setAccessibleName(this.bundle.getString("ACSN_TARGET_LIST"));
        accessibleContext.setAccessibleDescription(this.bundle.getString("ACSD_TARGET_LIST"));
        accessibleContext = this.scrollPane.getHorizontalScrollBar().getAccessibleContext();
        accessibleContext.setAccessibleName(this.bundle.getString("ACSN_TARGET_LIST"));
        accessibleContext.setAccessibleDescription(this.bundle.getString("ACSD_TARGET_LIST"));
        accessibleContext = this.scrollPane.getVerticalScrollBar().getAccessibleContext();
        accessibleContext.setAccessibleName(this.bundle.getString("ACSN_TARGET_LIST"));
        accessibleContext.setAccessibleDescription(this.bundle.getString("ACSD_TARGET_LIST"));
        this.addButton.getAccessibleContext().setAccessibleDescription(this.addButton.getText());
        this.editButton.getAccessibleContext().setAccessibleDescription(this.editButton.getText());
        this.removeButton.getAccessibleContext().setAccessibleDescription(this.removeButton.getText());
        this.upButton.getAccessibleContext().setAccessibleDescription(this.upButton.getText());
        this.downButton.getAccessibleContext().setAccessibleDescription(this.downButton.getText());
    }

    private void initComponents() {
        this.dataPanel = new JPanel();
        this.listLabel = new JLabel();
        this.scrollPane = new JScrollPane();
        this.controlsPanel = new JPanel();
        this.addButton = new JButton();
        this.editButton = new JButton();
        this.removeButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.setLayout(new BorderLayout());
        this.setRequestFocusEnabled(false);
        this.dataPanel.setLayout(new GridBagLayout());
        this.dataPanel.setRequestFocusEnabled(false);
        this.listLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/builds/Bundle").getString("TARGET_EDITOR_LIST_MNEMONIC").charAt(0));
        this.listLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/builds/Bundle").getString("TARGET_EDITOR_LIST_LBL"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 10, 0, 0);
        this.dataPanel.add((Component)this.listLabel, gridBagConstraints);
        this.scrollPane.setBackground(new Color(255, 255, 255));
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.dataPanel.add((Component)this.scrollPane, gridBagConstraints);
        this.controlsPanel.setLayout(new GridBagLayout());
        this.controlsPanel.setRequestFocusEnabled(false);
        this.addButton.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/builds/Bundle").getString("TARGET_EDITOR_ADD_BUTTON_LBL"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TargetEditor.this.addButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.controlsPanel.add((Component)this.addButton, gridBagConstraints);
        this.editButton.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/builds/Bundle").getString("TARGET_EDITOR_CHANGE_BUTTON_LBL"));
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TargetEditor.this.editButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.controlsPanel.add((Component)this.editButton, gridBagConstraints);
        this.removeButton.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/builds/Bundle").getString("TARGET_EDITOR_REMOVE_BUTTON_LBL"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TargetEditor.this.removeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.controlsPanel.add((Component)this.removeButton, gridBagConstraints);
        this.upButton.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/builds/Bundle").getString("TARGET_EDITOR_UP_BUTTON_LBL"));
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TargetEditor.this.upButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.controlsPanel.add((Component)this.upButton, gridBagConstraints);
        this.downButton.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/builds/Bundle").getString("TARGET_EDITOR_DOWN_BUTTON_LBL"));
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TargetEditor.this.downButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.controlsPanel.add((Component)this.downButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        this.dataPanel.add((Component)this.controlsPanel, gridBagConstraints);
        this.add((Component)this.dataPanel, "Center");
    }

    private void targetListKeyPressed(KeyEvent keyEvent) {
        this.processKeyEvent(keyEvent);
    }

    private void handleEscape(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        if (keyEvent.getKeyChar() == '\u001b') {
            keyEvent.consume();
            this.closeAction(this.dialog, 1);
        }
    }

    private void editAction() {
        NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine("", this.bundle.getString("TARGET_DIALOG_TITLE"));
        int n = this.targetList.getSelectedIndex();
        inputLine.setInputText(this.listData.elementAt(n));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine);
        if (inputLine.getValue() == NotifyDescriptor.OK_OPTION && inputLine.getInputText().length() > 0) {
            this.listData.removeElementAt(n);
            this.listData.add(n, inputLine.getInputText());
            this.targetList.setListData(this.listData);
            this.targetList.setSelectedIndex(n);
        }
        this.checkSelection();
        if (this.dialog != null) {
            this.dialog.setVisible(true);
        }
        this.editButton.requestFocus();
    }

    private void editButtonActionPerformed(ActionEvent actionEvent) {
        this.editAction();
    }

    private void downAction() {
        int n = this.targetList.getSelectedIndex();
        if (n < 0) {
            return;
        }
        if (n >= this.listData.size() - 1) {
            return;
        }
        String string = this.listData.elementAt(n);
        this.listData.removeElementAt(n);
        this.listData.add(++n, string);
        this.targetList.setListData(this.listData);
        if (n >= 0) {
            this.targetList.ensureIndexIsVisible(n);
            this.targetList.setSelectedIndex(n);
        }
        this.checkSelection();
        if (this.dialog != null) {
            this.dialog.setVisible(true);
        }
        if (this.downButton.isEnabled()) {
            this.downButton.requestFocus();
        } else {
            this.upButton.requestFocus();
        }
    }

    private void downButtonActionPerformed(ActionEvent actionEvent) {
        this.downAction();
    }

    private void upAction() {
        int n = this.targetList.getSelectedIndex();
        if (n <= 0) {
            return;
        }
        String string = this.listData.elementAt(n);
        this.listData.removeElementAt(n);
        this.listData.add(--n, string);
        this.targetList.setListData(this.listData);
        if (n >= 0) {
            this.targetList.ensureIndexIsVisible(n);
            this.targetList.setSelectedIndex(n);
        }
        this.checkSelection();
        if (this.dialog != null) {
            this.dialog.setVisible(true);
        }
        if (this.upButton.isEnabled()) {
            this.upButton.requestFocus();
        } else {
            this.downButton.requestFocus();
        }
    }

    private void upButtonActionPerformed(ActionEvent actionEvent) {
        this.upAction();
    }

    private void removeAction() {
        int n = this.targetList.getSelectedIndex();
        if (n < 0) {
            return;
        }
        this.listData.removeElementAt(n);
        this.targetList.setListData(this.listData);
        int n2 = n = n >= this.listData.size() ? n - 1 : n;
        if (n >= 0) {
            this.targetList.ensureIndexIsVisible(n);
            this.targetList.setSelectedIndex(n);
        }
        this.checkSelection();
        if (this.dialog != null) {
            this.dialog.setVisible(true);
        }
        if (this.removeButton.isEnabled()) {
            this.removeButton.requestFocus();
        } else {
            this.addButton.requestFocus();
        }
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        this.removeAction();
    }

    private void addAction() {
        NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine("", this.bundle.getString("TARGET_DIALOG_TITLE"));
        int n = 0;
        int n2 = this.targetList.getSelectedIndex();
        if (n2 >= 0 && n2 <= this.listData.size() - 1) {
            n = n2 + 1;
        }
        DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine);
        if (inputLine.getValue() == NotifyDescriptor.OK_OPTION && inputLine.getInputText() != null && inputLine.getInputText().length() > 0) {
            this.listData.add(n, inputLine.getInputText());
            this.targetList.setListData(this.listData);
            this.targetList.setSelectedIndex(n);
        }
        this.addButton.requestFocus();
        this.checkSelection();
        if (this.dialog != null) {
            this.dialog.setVisible(true);
        }
        this.addButton.requestFocus();
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        this.addAction();
    }

    private void checkSelection() {
        int n = this.targetList.getSelectedIndex();
        if (n >= 0) {
            this.addButton.setEnabled(true);
            this.removeButton.setEnabled(true);
            this.editButton.setEnabled(true);
            if (n == 0) {
                this.upButton.setEnabled(false);
            } else {
                this.upButton.setEnabled(true);
            }
            if (n >= this.listData.size() - 1) {
                this.downButton.setEnabled(false);
            } else {
                this.downButton.setEnabled(true);
            }
        } else {
            this.addButton.setEnabled(true);
            this.removeButton.setEnabled(false);
            this.editButton.setEnabled(false);
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
    }

    public String getTargets() {
        String string = null;
        for (int i = 0; i < this.targetList.getModel().getSize(); ++i) {
            string = i == 0 ? (String)this.targetList.getModel().getElementAt(0) : string + ", " + this.targetList.getModel().getElementAt(i);
        }
        return string;
    }

    private Object getPropertyValue() throws IllegalStateException {
        return this.getTargets();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("state".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getNewValue() == PropertyEnv.STATE_VALID) {
            this.editor.setValue(this.getPropertyValue());
        }
    }

    private void closeAction(JDialog jDialog, int n) {
        if (jDialog != null) {
            jDialog.setVisible(false);
            jDialog.dispose();
            this.returnValue = n;
        }
    }

    public int showOpenDialog(JFrame jFrame) {
        this.dialog = new JDialog((Frame)jFrame, true);
        this.dialog.getContentPane().add(this);
        this.dialog.setTitle(this.bundle.getString("TARGET_EDITOR_TITLE"));
        AccessibleContext accessibleContext = this.dialog.getAccessibleContext();
        accessibleContext.setAccessibleName(this.bundle.getString("ACSN_TARGET_EDITOR"));
        accessibleContext.setAccessibleDescription(this.bundle.getString("ACSD_TARGET_EDITOR"));
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                TargetEditor.this.handleEscape(keyEvent);
            }
        };
        JPanel jPanel = new JPanel();
        this.okButton = new JButton();
        this.okButton.setText(this.bundle.getString("TARGET_EDITOR_OK_BUTTON_LBL"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TargetEditor.this.closeAction(TargetEditor.this.dialog, 0);
            }
        });
        this.okButton.getAccessibleContext().setAccessibleDescription(this.okButton.getText());
        this.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton = new JButton();
        this.cancelButton.setText(this.bundle.getString("TARGET_EDITOR_CANCEL_BUTTON_LBL"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TargetEditor.this.closeAction(TargetEditor.this.dialog, 1);
            }
        });
        this.cancelButton.getAccessibleContext().setAccessibleDescription(this.cancelButton.getText());
        this.okButton.addKeyListener(keyAdapter);
        this.cancelButton.addKeyListener(keyAdapter);
        this.addButton.addKeyListener(keyAdapter);
        this.editButton.addKeyListener(keyAdapter);
        this.removeButton.addKeyListener(keyAdapter);
        this.upButton.addKeyListener(keyAdapter);
        this.downButton.addKeyListener(keyAdapter);
        this.addKeyListener(keyAdapter);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.okButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        jPanel.add((Component)this.cancelButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(12, 0, 10, 10);
        gridBagConstraints.anchor = 13;
        this.dataPanel.add((Component)jPanel, gridBagConstraints);
        this.okButton.setPreferredSize(this.cancelButton.getPreferredSize());
        this.dialog.pack();
        this.dialog.setLocation(this.findScreenCenter(this.dialog));
        this.dialog.setVisible(true);
        return this.returnValue;
    }

    private Point findScreenCenter(JDialog jDialog) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int n = toolkit.getScreenSize().width / 2 - jDialog.getHeight() / 2;
        int n2 = toolkit.getScreenSize().height / 2 - jDialog.getWidth() / 2;
        return new Point(n, n2);
    }

    private class TargetSelectionListener
    implements ListSelectionListener {
        private TargetSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            TargetEditor.this.checkSelection();
        }
    }
}

