/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.filecreation;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.cnd.editor.filecreation.PhysicalView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public abstract class CndPanelGUI
extends JPanel
implements DocumentListener {
    protected Project project;
    protected SourceGroup[] folders;
    private static final Dimension PREF_DIM = new Dimension(500, 340);
    protected static final String NEW_FILE_PREFIX = CndPanelGUI.getMessage("LBL_NewCndFileChooserPanelGUI_NewFilePrefix");
    protected final ListCellRenderer CELL_RENDERER = new GroupCellRenderer();
    protected final ChangeSupport changeSupport = new ChangeSupport((Object)this);

    public CndPanelGUI(Project project, SourceGroup[] sourceGroupArray) {
        this.project = project;
        this.folders = sourceGroupArray;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public abstract SourceGroup getTargetGroup();

    public abstract String getTargetFolder();

    public abstract String getTargetName();

    protected abstract void updateCreatedFile();

    public abstract void initValues(FileObject var1, FileObject var2, String var3);

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateCreatedFile();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateCreatedFile();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateCreatedFile();
    }

    public Dimension getPreferredSize() {
        return PREF_DIM;
    }

    protected static SourceGroup getPreselectedGroup(SourceGroup[] sourceGroupArray, FileObject fileObject) {
        for (int i = 0; fileObject != null && i < sourceGroupArray.length; ++i) {
            if (!FileUtil.isParentOf((FileObject)sourceGroupArray[i].getRootFolder(), (FileObject)fileObject) && !sourceGroupArray[i].getRootFolder().equals(fileObject)) continue;
            return sourceGroupArray[i];
        }
        return sourceGroupArray[0];
    }

    protected static String getRelativeNativeName(FileObject fileObject, FileObject fileObject2) {
        if (fileObject == null) {
            throw new NullPointerException("null root passed to getRelativeNativeName");
        }
        String string = fileObject2 == null ? "" : FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2);
        return string == null ? "" : string.replace('/', File.separatorChar);
    }

    protected static String generateUniqueSuffix(FileObject fileObject, String string, String ... stringArray) {
        int n = 0;
        while (true) {
            String string2 = n == 0 ? "" : String.valueOf(n);
            String string3 = string + string2;
            boolean bl = true;
            for (String string4 : stringArray) {
                if (fileObject.getFileObject(string3, string4) == null) continue;
                bl = false;
                break;
            }
            if (bl) {
                return string2;
            }
            ++n;
        }
    }

    protected static String getMessage(String string) {
        return NbBundle.getMessage(CndPanelGUI.class, (String)string);
    }

    protected class GroupCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public GroupCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof SourceGroup) {
                String string;
                SourceGroup sourceGroup = (SourceGroup)object;
                String string2 = ProjectUtils.getInformation((Project)CndPanelGUI.this.project).getDisplayName();
                if (string2.equals(string = sourceGroup.getDisplayName())) {
                    this.setText(string);
                } else {
                    this.setText(MessageFormat.format(PhysicalView.GroupNode.GROUP_NAME_PATTERN, string, string2, sourceGroup.getRootFolder().getName()));
                }
                this.setIcon(sourceGroup.getIcon(false));
            } else {
                this.setText(object.toString());
                this.setIcon(null);
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }
}

