/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.execution;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.netbeans.modules.cnd.execution41.org.openide.loaders.ExecutionSupport;
import org.netbeans.modules.cnd.settings.ShellSettings;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShellExecSupport
extends ExecutionSupport {
    private static final String PROP_RUN_DIRECTORY = "rundirectory";
    private static final String PROP_SHELL_COMMAND = "shellcommand";
    private ResourceBundle bundle = null;

    public ShellExecSupport(MultiDataObject.Entry entry) {
        super(entry);
    }

    @Override
    public void addProperties(Sheet.Set set) {
        set.put(this.createParamsProperty());
        set.put(this.createRunDirectoryProperty());
        set.put(this.createShellCommandProperty());
    }

    private PropertySupport<String> createRunDirectoryProperty() {
        return new PropertySupport.ReadWrite<String>(PROP_RUN_DIRECTORY, String.class, this.getString("PROP_RUN_DIRECTORY"), this.getString("HINT_RUN_DIRECTORY")){

            public String getValue() {
                return ShellExecSupport.this.getRunDirectory();
            }

            public void setValue(String string) {
                ShellExecSupport.this.setRunDirectory(string);
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() {
                this.setValue(null);
            }

            public boolean canWrite() {
                return ShellExecSupport.this.getEntry().getFile().getParent().canWrite();
            }
        };
    }

    private PropertySupport<String> createShellCommandProperty() {
        return new PropertySupport.ReadWrite<String>(PROP_SHELL_COMMAND, String.class, this.getString("PROP_SHELL_COMMAND"), this.getString("HINT_SHELL_COMMAND")){

            public String getValue() {
                return ShellExecSupport.this.getShellCommand();
            }

            public void setValue(String string) {
                ShellExecSupport.this.setShellCommand(string);
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() {
                this.setValue(null);
            }

            public boolean canWrite() {
                return ShellExecSupport.this.getEntry().getFile().getParent().canWrite();
            }
        };
    }

    public String getRunDirectory() {
        String string = (String)this.getEntry().getFile().getAttribute(PROP_RUN_DIRECTORY);
        if (string == null) {
            string = ".";
            this.setRunDirectory(string);
        }
        return string;
    }

    public void setRunDirectory(String string) {
        block2: {
            FileObject fileObject = this.getEntry().getFile();
            try {
                fileObject.setAttribute(PROP_RUN_DIRECTORY, (Object)string);
            }
            catch (IOException iOException) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block2;
                iOException.printStackTrace();
            }
        }
    }

    public String getShellCommand() {
        String string = (String)this.getEntry().getFile().getAttribute(PROP_SHELL_COMMAND);
        if (string == null || string.length() == 0) {
            string = "";
        }
        return string;
    }

    public String[] getShellCommandAndArgs(FileObject fileObject) {
        Object object;
        String[] stringArray;
        String string = this.getShellCommand();
        if (string == null || string.length() == 0) {
            stringArray = FileUtil.toFile((FileObject)fileObject).getPath();
            try {
                object = new BufferedReader(new FileReader((String)stringArray));
                if (object != null) {
                    String string2 = ((BufferedReader)object).readLine();
                    if (string2 != null && string2.startsWith("#!") && string2.length() > 2) {
                        int n = 2;
                        while (Character.isWhitespace(string2.charAt(n))) {
                            ++n;
                        }
                        string = string2.substring(n);
                    }
                    ((BufferedReader)object).close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string == null || string.length() == 0) && (object = fileObject.getExt()) != null && ((String)object).length() > 0) {
            if ((((String)object).equals("bat") || ((String)object).equals("cmd")) && Utilities.isWindows()) {
                stringArray = new String[]{""};
                return stringArray;
            }
            string = "/bin/" + (String)object;
            if (!new File(string).exists()) {
                string = null;
            }
        }
        if (string == null || string.length() == 0) {
            string = ShellSettings.getDefault().getDefaultShellCommand();
        }
        stringArray = Utilities.parseParameters((String)string);
        return stringArray;
    }

    public void setShellCommand(String string) {
        block2: {
            FileObject fileObject = this.getEntry().getFile();
            try {
                fileObject.setAttribute(PROP_SHELL_COMMAND, (Object)string);
            }
            catch (IOException iOException) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block2;
                iOException.printStackTrace();
            }
        }
    }

    private PropertySupport<String> createParamsProperty() {
        PropertySupport.ReadWrite<String> readWrite = new PropertySupport.ReadWrite<String>("params", String.class, this.getString("PROP_fileParams"), this.getString("HINT_fileParams")){

            public String getValue() {
                String[] stringArray = ShellExecSupport.this.getArguments();
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuilder.append(stringArray[i]).append(' ');
                }
                return stringBuilder.toString();
            }

            public void setValue(String string) throws InvocationTargetException {
                if (string != null) {
                    try {
                        ShellExecSupport.this.setArguments(new String[]{string});
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                try {
                    ShellExecSupport.this.setArguments(null);
                }
                catch (IOException iOException) {
                    throw new InvocationTargetException(iOException);
                }
            }

            public boolean canWrite() {
                Boolean bl = (Boolean)ShellExecSupport.this.getEntry().getFile().getAttribute("readOnlyAttrs");
                return bl == null ? false : bl == false;
            }
        };
        readWrite.setValue("oneline", (Object)Boolean.TRUE);
        return readWrite;
    }

    private String getString(String string) {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle(ShellExecSupport.class);
        }
        return this.bundle.getString(string);
    }
}

