/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.execution;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.dwarfdump.FileMagic;
import org.netbeans.modules.cnd.dwarfdump.reader.ElfReader;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.modules.InstalledFileLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Unbuffer {
    protected static final Logger log = Logger.getLogger("cnd.execution.logger");
    private static final boolean disabled = Boolean.getBoolean("cnd.unbuffer.disable");

    private Unbuffer() {
    }

    public static Collection<String> getUnbufferEnvironment(ExecutionEnvironment executionEnvironment, String string) {
        ArrayList<String> arrayList = new ArrayList<String>(2);
        boolean bl = Unbuffer.is64BitExecutable(string);
        String string2 = Unbuffer.getPath(executionEnvironment, bl);
        if (string2 != null) {
            int n = executionEnvironment == null ? PlatformInfo.localhost().getPlatform() : PlatformInfo.getDefault(executionEnvironment).getPlatform();
            switch (n) {
                case 4: {
                    arrayList.add("DYLD_INSERT_LIBRARIES=" + string2);
                    arrayList.add("DYLD_FORCE_FLAT_NAMESPACE=yes");
                    break;
                }
                case 3: {
                    break;
                }
                case 2: {
                    arrayList.add("LD_PRELOAD=" + string2);
                    break;
                }
                default: {
                    String string3 = bl ? "LD_PRELOAD_64=" : "LD_PRELOAD_32=";
                    arrayList.add(string3 + string2);
                }
            }
        }
        return arrayList;
    }

    private static String getPath(ExecutionEnvironment executionEnvironment, boolean bl) {
        if (disabled) {
            return null;
        }
        if (executionEnvironment == null || executionEnvironment.isLocal()) {
            return Unbuffer.getLocalPath(bl);
        }
        return Unbuffer.getRemotePath(executionEnvironment, bl);
    }

    private static boolean is64BitExecutable(String string) {
        try {
            FileMagic fileMagic = new FileMagic(string);
            ElfReader elfReader = new ElfReader(string, fileMagic.getReader(), fileMagic.getMagic(), 0L, fileMagic.getReader().length());
            return elfReader.is64Bit();
        }
        catch (IOException iOException) {
            log.warning("Executable " + string + " not found");
            return false;
        }
    }

    private static String getLocalPath(boolean bl) {
        String string = Unbuffer.getLibName(PlatformInfo.localhost().getPlatform(), bl);
        if (string == null) {
            return null;
        }
        File file = InstalledFileLocator.getDefault().locate("bin/" + string, null, false);
        if (file != null && file.exists()) {
            return Unbuffer.fixPath(file.getAbsolutePath());
        }
        log.warning("unbuffer: " + string + " not found");
        return null;
    }

    private static String getRemotePath(ExecutionEnvironment executionEnvironment, boolean bl) {
        String string = HostInfoProvider.getLibDir((ExecutionEnvironment)executionEnvironment);
        if (string == null) {
            return null;
        }
        String string2 = Unbuffer.getLibName(PlatformInfo.getDefault(executionEnvironment).getPlatform(), bl);
        if (string2 != null) {
            if (HostInfoProvider.fileExists((ExecutionEnvironment)executionEnvironment, (String)(string = string + string2))) {
                return string;
            }
            log.warning("unbuffer: " + string + " does not exist");
        }
        return null;
    }

    private static String fixPath(String string) {
        return string;
    }

    private static String getLibName(int n, boolean bl) {
        String string = bl ? "_64" : "";
        switch (n) {
            case 2: {
                return "unbuffer-Linux-x86" + string + ".so";
            }
            case 0: {
                return "unbuffer-SunOS-sparc" + string + ".so";
            }
            case 1: {
                return "unbuffer-SunOS-x86" + string + ".so";
            }
            case 3: {
                return "unbuffer-Windows_XP-x86" + string + ".dll";
            }
            case 4: {
                return "unbuffer-Mac_OS_X-x86" + string + ".dylib";
            }
        }
        log.warning("unbuffer search: unknown platform number " + n);
        return null;
    }
}

