/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.execution41.org.openide.loaders;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.netbeans.modules.cnd.execution41.org.openide.cookies.ArgumentsCookie;
import org.netbeans.modules.cnd.execution41.org.openide.cookies.ExecCookie;
import org.netbeans.modules.cnd.execution41.org.openide.execution.Executor;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionSupport
implements ExecCookie,
ArgumentsCookie {
    private static final String EA_EXECUTOR = "NetBeansAttrExecutor";
    private static final String EA_ARGUMENTS = "NetBeansAttrArguments";
    public static final String PROP_FILE_PARAMS = "params";
    public static final String PROP_EXECUTION = "execution";
    private MultiDataObject.Entry entry;
    protected static final String READONLY_ATTRIBUTES = "readOnlyAttrs";

    public ExecutionSupport(MultiDataObject.Entry entry) {
        this.entry = entry;
    }

    protected MultiDataObject.Entry getEntry() {
        return this.entry;
    }

    @Override
    public void start() {
        Executor executor = ExecutionSupport.getExecutor(this.entry);
        if (executor == null) {
            executor = this.defaultExecutor();
        }
        try {
            executor.execute((DataObject)this.entry.getDataObject());
        }
        catch (IOException iOException) {
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    if (ExecutionSupport.this.startFailed(iOException)) {
                        ExecutionSupport.this.start();
                    }
                }
            });
        }
    }

    protected boolean startFailed(IOException iOException) {
        return false;
    }

    protected Executor defaultExecutor() {
        return Executor.getDefault();
    }

    public static void setExecutor(MultiDataObject.Entry entry, Executor executor) throws IOException {
    }

    public static Executor getExecutor(MultiDataObject.Entry entry) {
        return null;
    }

    @Override
    public void setArguments(String[] stringArray) throws IOException {
        this.entry.getFile().setAttribute(EA_ARGUMENTS, (Object)stringArray);
    }

    public static void setArguments(MultiDataObject.Entry entry, String[] stringArray) throws IOException {
        entry.getFile().setAttribute(EA_ARGUMENTS, (Object)stringArray);
    }

    @Override
    public String[] getArguments() {
        return ExecutionSupport.getArguments(this.entry);
    }

    public static String[] getArguments(MultiDataObject.Entry entry) {
        Object object = entry.getFile().getAttribute(EA_ARGUMENTS);
        if (object != null && object instanceof String[]) {
            return (String[])object;
        }
        return new String[0];
    }

    public void addProperties(Sheet.Set set) {
        set.put(this.createParamsProperty());
        set.put(this.createExecutorProperty());
    }

    private PropertySupport<String> createParamsProperty() {
        PropertySupport.ReadWrite<String> readWrite = new PropertySupport.ReadWrite<String>(PROP_FILE_PARAMS, String.class, ExecutionSupport.getString("PROP_fileParams"), ExecutionSupport.getString("HINT_fileParams")){

            public String getValue() {
                String[] stringArray = ExecutionSupport.this.getArguments();
                return Utilities.escapeParameters((String[])stringArray);
            }

            public void setValue(String string) throws InvocationTargetException {
                if (string != null) {
                    try {
                        ExecutionSupport.this.setArguments(Utilities.parseParameters((String)string));
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                try {
                    ExecutionSupport.this.setArguments(null);
                }
                catch (IOException iOException) {
                    throw new InvocationTargetException(iOException);
                }
            }

            public boolean canWrite() {
                Boolean bl = (Boolean)ExecutionSupport.this.entry.getFile().getAttribute(ExecutionSupport.READONLY_ATTRIBUTES);
                return bl == null ? false : bl == false;
            }
        };
        readWrite.setValue("oneline", (Object)Boolean.TRUE);
        return readWrite;
    }

    private PropertySupport<Executor> createExecutorProperty() {
        return new PropertySupport.ReadWrite<Executor>(PROP_EXECUTION, Executor.class, ExecutionSupport.getString("PROP_execution"), ExecutionSupport.getString("HINT_execution")){

            public Executor getValue() {
                Executor executor = ExecutionSupport.getExecutor(ExecutionSupport.this.entry);
                if (executor == null) {
                    return ExecutionSupport.this.defaultExecutor();
                }
                return executor;
            }

            public void setValue(Executor executor) throws InvocationTargetException {
                try {
                    ExecutionSupport.setExecutor(ExecutionSupport.this.entry, executor);
                }
                catch (IOException iOException) {
                    throw new InvocationTargetException(iOException);
                }
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
            }

            public boolean canWrite() {
                Boolean bl = (Boolean)ExecutionSupport.this.entry.getFile().getAttribute(ExecutionSupport.READONLY_ATTRIBUTES);
                return bl == null ? false : bl == false;
            }
        };
    }

    static String getString(String string) {
        return NbBundle.getMessage(Executor.class, (String)string);
    }
}

