/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makewizard;

import java.io.File;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import org.netbeans.modules.cnd.makewizard.EnterItemsPanel;
import org.netbeans.modules.cnd.makewizard.MakefileWizard;
import org.netbeans.modules.cnd.makewizard.TargetData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakefileSourcesPanel
extends EnterItemsPanel {
    private String srcFilter;
    static final long serialVersionUID = -6961895016031819992L;
    private boolean initialized;
    private int key;

    public MakefileSourcesPanel(MakefileWizard makefileWizard) {
        super(makefileWizard);
        String string = this.getString("LBL_MakefileSourcesPanel");
        this.setSubTitle(string);
        this.getAccessibleContext().setAccessibleDescription(string);
        this.initialized = false;
    }

    private void create() {
        String string;
        int n;
        if (this.getMakefileData().getMakefileType() == 4) {
            n = 189;
            string = this.getString("LBL_SourceNamesComplex");
        } else {
            n = 45;
            string = this.getString("LBL_SourceNamesSimple");
        }
        this.create(string, this.getString("MNEM_SourceNames").charAt(0), n);
    }

    @Override
    protected String getListLabel() {
        return this.getString("LBL_SourceList");
    }

    @Override
    protected char getListMnemonic() {
        return this.getString("MNEM_SourceList").charAt(0);
    }

    @Override
    protected EnterItemsPanel.ErrorInfo getErrorInfo() {
        return new EnterItemsPanel.ErrorInfo(this.getString("DLG_NoFilesError"), this.getString("MSG_NoFilesMatched"));
    }

    @Override
    public void validateData(ArrayList<String> arrayList, int n) {
        TargetData targetData = this.getMakefileData().getTarget(n);
        String[] stringArray = targetData.getSourcesList();
        if (stringArray == null) {
            this.warn(arrayList, WARN_NO_SRC_FILES, targetData.getName());
        } else {
            int n2;
            String string = this.getMakefileData().getBaseDirectory(true);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            int n3 = 0;
            int n4 = 0;
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                File file;
                String string2 = stringArray[n2];
                if (string2.startsWith("/")) {
                    ++n3;
                }
                if (string2.endsWith(".h")) {
                    ++n4;
                }
                if ((file = string2.startsWith(File.separator) ? new File(string2) : new File(string, string2)).exists()) continue;
                arrayList2.add("\t" + file.getPath() + "\n");
            }
            if (n3 > 0) {
                this.warn(arrayList, WARN_ABSPATH_SRC_COUNT, targetData.getName(), String.valueOf(n3));
            }
            if (n4 > 0) {
                this.warn(arrayList, WARN_HDR_SRC_COUNT, targetData.getName(), String.valueOf(n4));
            }
            if (arrayList2.size() > 0) {
                if (arrayList2.size() < 5) {
                    this.warn(arrayList, WARN_DNE_FILES, targetData.getName());
                    for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                        arrayList.add((String)arrayList2.get(n2));
                    }
                    arrayList.add("\n");
                } else {
                    this.warn(arrayList, WARN_DNE_COUNT, targetData.getName(), String.valueOf(arrayList2.size()));
                }
            }
        }
    }

    @Override
    public void addNotify() {
        TargetData targetData = this.getMakefileData().getCurrentTarget();
        this.key = targetData.getKey();
        if (!this.initialized) {
            this.create();
            this.srcFilter = this.getString("DFLT_SourceFilter");
            this.initialized = true;
        }
        this.getEntryText().setText(this.srcFilter);
        DefaultListModel defaultListModel = (DefaultListModel)this.getList().getModel();
        defaultListModel.removeAllElements();
        String[] stringArray = targetData.getSourcesList();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                defaultListModel.addElement(stringArray[i]);
            }
        }
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        TargetData targetData = this.getMakefileData().getTarget(this.key);
        String[] stringArray = this.getListItems();
        targetData.setSourcesList(stringArray);
    }
}

