/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.ui.options;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.utils.FileChooser;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.openide.DialogDescriptor;
import org.openide.util.NbBundle;

final class AddCompilerSetPanel
extends JPanel
implements DocumentListener {
    private DialogDescriptor dialogDescriptor = null;
    private final CompilerSetManager csm;
    private final boolean local;
    private final String lock = new String("lockForCompilersFound");
    private final String remoteCompilerCheckExecutorLock = new String("remoteCompilerCheckExecutorLock");
    private ExecutorService remoteCompilerCheckExecutor;
    private CompilerSet lastFoundRemoteCompilerSet;
    private JButton btBaseDirectory;
    private JComboBox cbFamily;
    private JLabel infoLabel;
    private JLabel lbBaseDirectory;
    private JLabel lbError;
    private JLabel lbFamily;
    private JLabel lbName;
    private JTextField tfBaseDirectory;
    private JTextField tfName;

    public AddCompilerSetPanel(CompilerSetManager compilerSetManager) {
        this.initComponents();
        this.csm = compilerSetManager;
        this.local = compilerSetManager.getExecutionEnvironment().isLocal();
        if (!this.local) {
            this.btBaseDirectory.setText(AddCompilerSetPanel.getString("AddCompilerSetPanel.btBaseDirectoryRemoteMode.text"));
            this.btBaseDirectory.setMnemonic(0);
        }
        List<CompilerSet.CompilerFlavor> list = CompilerSet.CompilerFlavor.getFlavors(compilerSetManager.getPlatform());
        for (CompilerSet.CompilerFlavor compilerFlavor : list) {
            this.cbFamily.addItem(compilerFlavor);
        }
        this.cbFamily.addItem(CompilerSet.CompilerFlavor.getUnknown(compilerSetManager.getPlatform()));
        this.tfName.setText("");
        this.validateData();
        this.setPreferredSize(new Dimension(800, 300));
        this.tfBaseDirectory.getDocument().addDocumentListener(this);
        this.tfName.getDocument().addDocumentListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotify() {
        super.removeNotify();
        String string = this.remoteCompilerCheckExecutorLock;
        synchronized (string) {
            if (this.remoteCompilerCheckExecutor != null) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        return AddCompilerSetPanel.this.remoteCompilerCheckExecutor.shutdownNow();
                    }
                });
            }
        }
    }

    private static String getString(String string) {
        return NbBundle.getMessage(AddCompilerSetPanel.class, (String)string);
    }

    public void setDialogDescriptor(DialogDescriptor dialogDescriptor) {
        this.dialogDescriptor = dialogDescriptor;
        dialogDescriptor.setValid(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDataBaseDir() {
        if (this.local) {
            File file = new File(this.tfBaseDirectory.getText());
            List<CompilerSet.CompilerFlavor> list = CompilerSet.getCompilerSetFlavor(file.getAbsolutePath(), this.csm.getPlatform());
            if (list.size() > 0) {
                this.cbFamily.setSelectedItem(list.get(0));
            } else {
                this.cbFamily.setSelectedItem(CompilerSet.CompilerFlavor.getUnknown(this.csm.getPlatform()));
            }
            this.updateDataFamily();
            if (!this.dialogDescriptor.isValid()) {
                this.tfName.setText("");
            }
        } else {
            final String string = this.lock;
            synchronized (string) {
                this.lastFoundRemoteCompilerSet = null;
            }
            string = this.tfBaseDirectory.getText().trim();
            if (string.length() > 0) {
                String string2 = this.remoteCompilerCheckExecutorLock;
                synchronized (string2) {
                    if (this.remoteCompilerCheckExecutor != null) {
                        AccessController.doPrivileged(new PrivilegedAction<Object>(){

                            @Override
                            public Object run() {
                                return AddCompilerSetPanel.this.remoteCompilerCheckExecutor.shutdownNow();
                            }
                        });
                        this.remoteCompilerCheckExecutor = null;
                    }
                    this.remoteCompilerCheckExecutor = Executors.newSingleThreadExecutor();
                }
                this.remoteCompilerCheckExecutor.submit(new Runnable(){

                    public void run() {
                        final List<CompilerSet> list = AddCompilerSetPanel.this.csm.findRemoteCompilerSets(string);
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (Thread.interrupted()) {
                            return;
                        }
                        if (list.size() > 0) {
                            SwingUtilities.invokeLater(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void run() {
                                    AddCompilerSetPanel.this.cbFamily.setSelectedItem(((CompilerSet)list.get(0)).getCompilerFlavor());
                                    String string = AddCompilerSetPanel.this.lock;
                                    synchronized (string) {
                                        AddCompilerSetPanel.this.lastFoundRemoteCompilerSet = (CompilerSet)list.get(0);
                                    }
                                    AddCompilerSetPanel.this.updateDataFamily();
                                    if (!AddCompilerSetPanel.this.dialogDescriptor.isValid()) {
                                        AddCompilerSetPanel.this.tfName.setText("");
                                    }
                                }
                            });
                        }
                    }
                });
            }
        }
    }

    private void updateDataFamily() {
        CompilerSet.CompilerFlavor compilerFlavor = (CompilerSet.CompilerFlavor)this.cbFamily.getSelectedItem();
        int n = 0;
        String string = null;
        while (this.csm.getCompilerSet(string = compilerFlavor.toString() + (n > 0 ? "_" + n : "")) != null) {
            ++n;
        }
        this.tfName.setText(string);
        this.validateData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateData() {
        Object object;
        boolean bl = true;
        this.lbError.setText("");
        if (this.local) {
            object = new File(this.tfBaseDirectory.getText());
            if (bl && !((File)object).exists() || !((File)object).isDirectory() || !IpeUtils.isPathAbsolute(((File)object).getPath())) {
                bl = false;
                this.lbError.setText(AddCompilerSetPanel.getString("BASE_INVALID"));
            }
        } else {
            object = this.lock;
            synchronized (object) {
                if (this.lastFoundRemoteCompilerSet == null) {
                    bl = false;
                    this.lbError.setText(AddCompilerSetPanel.getString("REMOTEBASE_INVALID"));
                }
            }
        }
        this.cbFamily.setEnabled(bl);
        this.tfName.setEnabled(bl);
        object = IpeUtils.replaceOddCharacters(this.tfName.getText().trim(), '_');
        if (bl && ((String)object).length() == 0 || ((String)object).contains("|")) {
            bl = false;
            this.lbError.setText(AddCompilerSetPanel.getString("NAME_INVALID"));
        }
        if (bl && this.csm.getCompilerSet(((String)object).trim()) != null) {
            bl = false;
            this.lbError.setText(AddCompilerSetPanel.getString("TOOLNAME_ALREADY_EXISTS"));
        }
        if (this.dialogDescriptor != null) {
            this.dialogDescriptor.setValid(bl);
        }
    }

    private void handleUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.tfBaseDirectory.getDocument()) {
            if (this.local) {
                this.updateDataBaseDir();
            }
        } else {
            this.validateData();
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.handleUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.handleUpdate(documentEvent);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public String getBaseDirectory() {
        return this.tfBaseDirectory.getText();
    }

    private CompilerSet.CompilerFlavor getFamily() {
        return (CompilerSet.CompilerFlavor)this.cbFamily.getSelectedItem();
    }

    private String getCompilerSetName() {
        return IpeUtils.replaceOddCharacters(this.tfName.getText().trim(), '_');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompilerSet getCompilerSet() {
        String string = this.getCompilerSetName().trim();
        if (this.local) {
            String string2 = this.getBaseDirectory();
            CompilerSet.CompilerFlavor compilerFlavor = this.getFamily();
            CompilerSet compilerSet = CompilerSet.getCustomCompilerSet(new File(string2).getAbsolutePath(), compilerFlavor, string);
            CompilerSetManager.getDefault().initCompilerSet(compilerSet);
            return compilerSet;
        }
        String string3 = this.lock;
        synchronized (string3) {
            if (this.lastFoundRemoteCompilerSet != null) {
                this.lastFoundRemoteCompilerSet.setName(string);
                return this.lastFoundRemoteCompilerSet;
            }
            return this.lastFoundRemoteCompilerSet;
        }
    }

    private void initComponents() {
        this.infoLabel = new JLabel();
        this.lbBaseDirectory = new JLabel();
        this.tfName = new JTextField();
        this.btBaseDirectory = new JButton();
        this.lbFamily = new JLabel();
        this.cbFamily = new JComboBox();
        this.lbName = new JLabel();
        this.tfBaseDirectory = new JTextField();
        this.lbError = new JLabel();
        this.setLayout(new GridBagLayout());
        this.infoLabel.setText(NbBundle.getMessage(AddCompilerSetPanel.class, (String)"AddCompilerSetPanel.taInfo.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(16, 16, 0, 16);
        this.add((Component)this.infoLabel, gridBagConstraints);
        this.lbBaseDirectory.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("lbBaseDirectory_MN").charAt(0));
        this.lbBaseDirectory.setLabelFor(this.tfBaseDirectory);
        this.lbBaseDirectory.setText(NbBundle.getMessage(AddCompilerSetPanel.class, (String)"AddCompilerSetPanel.lbBaseDirectory.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(16, 16, 0, 0);
        this.add((Component)this.lbBaseDirectory, gridBagConstraints);
        this.tfName.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 4, 16, 0);
        this.add((Component)this.tfName, gridBagConstraints);
        this.tfName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddCompilerSetPanel.class, (String)"AddCompilerSetPanel.tfName.AccessibleContext.accessibleDescription"));
        this.btBaseDirectory.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("btBrowse").charAt(0));
        this.btBaseDirectory.setText(NbBundle.getMessage(AddCompilerSetPanel.class, (String)"AddCompilerSetPanel.btBaseDirectory.text"));
        this.btBaseDirectory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddCompilerSetPanel.this.btBaseDirectoryActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(16, 4, 0, 16);
        this.add((Component)this.btBaseDirectory, gridBagConstraints);
        this.btBaseDirectory.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddCompilerSetPanel.class, (String)"AddCompilerSetPanel.btBaseDirectory.AccessibleContext.accessibleDescription"));
        this.lbFamily.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("lbFamily_MN").charAt(0));
        this.lbFamily.setLabelFor(this.cbFamily);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle");
        this.lbFamily.setText(resourceBundle.getString("AddCompilerSetPanel.lbFamily.text"));
        this.lbFamily.setToolTipText(resourceBundle.getString("AddCompilerSetPanel.lbFamily.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 16, 0, 0);
        this.add((Component)this.lbFamily, gridBagConstraints);
        this.cbFamily.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddCompilerSetPanel.this.cbFamilyActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 4, 0, 0);
        this.add((Component)this.cbFamily, gridBagConstraints);
        this.lbName.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("lbToolSetName_MN").charAt(0));
        this.lbName.setLabelFor(this.tfName);
        this.lbName.setText(NbBundle.getMessage(AddCompilerSetPanel.class, (String)"AddCompilerSetPanel.lbName.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(9, 16, 16, 0);
        this.add((Component)this.lbName, gridBagConstraints);
        this.tfBaseDirectory.setColumns(40);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(16, 4, 0, 0);
        this.add((Component)this.tfBaseDirectory, gridBagConstraints);
        this.tfBaseDirectory.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddCompilerSetPanel.class, (String)"AddCompilerSetPanel.tfBaseDirectory.AccessibleContext.accessibleDescription"));
        this.lbError.setForeground(new Color(255, 51, 51));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 16, 16, 16);
        this.add((Component)this.lbError, gridBagConstraints);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddCompilerSetPanel.class, (String)"AddCompilerSetPanel.AccessibleContext.accessibleDescription"));
    }

    private void btBaseDirectoryActionPerformed(ActionEvent actionEvent) {
        if (this.local) {
            String string = null;
            string = this.tfBaseDirectory.getText().length() > 0 ? this.tfBaseDirectory.getText() : (FileChooser.getCurrectChooserFile() != null ? FileChooser.getCurrectChooserFile().getPath() : System.getProperty("user.home"));
            FileChooser fileChooser = new FileChooser(AddCompilerSetPanel.getString("SELECT_BASE_DIRECTORY_TITLE"), null, 1, null, string, true);
            int n = fileChooser.showOpenDialog(this);
            if (n == 1) {
                return;
            }
            String string2 = fileChooser.getSelectedFile().getPath();
            this.tfBaseDirectory.setText(string2);
        }
        this.updateDataBaseDir();
    }

    private void cbFamilyActionPerformed(ActionEvent actionEvent) {
        this.updateDataFamily();
    }
}

