/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.cnd.api.lexer;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndAbstractTokenProcessor;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CndTokenProcessor;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.TokenItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CndTokenUtilities {
    private static final Set<String> skipWSCategories = new HashSet<String>(1);

    private CndTokenUtilities() {
    }

    public static boolean isInPreprocessorDirective(Document document, int n) {
        TokenSequence<CppTokenId> tokenSequence = CndLexerUtilities.getCppTokenSequence(document, n, false, true);
        if (tokenSequence != null) {
            return tokenSequence.token().id() == CppTokenId.PREPROCESSOR_DIRECTIVE;
        }
        return false;
    }

    public static void processTokens(CndTokenProcessor<Token<CppTokenId>> cndTokenProcessor, Document document, int n, int n2) {
        TokenSequence<CppTokenId> tokenSequence = CndLexerUtilities.getCppTokenSequence(document, n, false, n2 < n);
        if (tokenSequence == null) {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
            TokenSequence tokenSequence2 = tokenHierarchy.tokenSequence();
            if (tokenSequence2 != null && CndLexerUtilities.isCppLanguage(tokenSequence2.language(), true)) {
                cndTokenProcessor.start(n, n, n2);
                cndTokenProcessor.end(n2, n2);
                return;
            }
            return;
        }
        int n3 = tokenSequence.move(n);
        cndTokenProcessor.start(n, n - n3, n2);
        if (CndTokenUtilities.processTokensImpl(cndTokenProcessor, tokenSequence, n, n2, n3 != 0)) {
            cndTokenProcessor.end(n2, tokenSequence.offset());
        } else {
            cndTokenProcessor.end(n2, n2);
        }
    }

    public static <T extends CppTokenId> TokenItem<T> createTokenItem(TokenSequence<T> tokenSequence) {
        return TokenItemImpl.create(tokenSequence);
    }

    public static <T extends CppTokenId> TokenItem<T> createTokenItem(Token<T> token, int n) {
        return TokenItemImpl.create(token, n);
    }

    public static TokenItem<CppTokenId> getFirstNonWhiteBwd(Document document, int n) {
        SkipTokenProcessor skipTokenProcessor = new SkipTokenProcessor(Collections.<CppTokenId>emptySet(), skipWSCategories, true);
        CndTokenUtilities.processTokens(skipTokenProcessor, document, n, 0);
        return skipTokenProcessor.getTokenItem();
    }

    public static int getLastCommandSeparator(Document document, int n) throws BadLocationException {
        if (n < 0 || n > document.getLength()) {
            throw new BadLocationException("position is out of range[0-" + document.getLength() + "]", n);
        }
        if (n == 0) {
            return 0;
        }
        TokenSequence<CppTokenId> tokenSequence = CndLexerUtilities.getCppTokenSequence(document, n, true, true);
        if (tokenSequence == null) {
            return 0;
        }
        do {
            switch ((CppTokenId)tokenSequence.token().id()) {
                case SEMICOLON: 
                case LBRACE: 
                case RBRACE: {
                    return tokenSequence.offset();
                }
            }
        } while (tokenSequence.movePrevious());
        tokenSequence.moveStart();
        if (tokenSequence.moveNext()) {
            return tokenSequence.offset();
        }
        return 0;
    }

    public static boolean moveToPreprocKeyword(TokenSequence<CppTokenId> tokenSequence) {
        if (tokenSequence != null && tokenSequence.language() == CppTokenId.languagePreproc()) {
            tokenSequence.moveStart();
            tokenSequence.moveNext();
            if (!tokenSequence.moveNext()) {
                return false;
            }
            if (CndTokenUtilities.shiftToNonWhite(tokenSequence, false)) {
                switch ((CppTokenId)tokenSequence.token().id()) {
                    case PREPROCESSOR_DEFINE: 
                    case PREPROCESSOR_ELIF: 
                    case PREPROCESSOR_ELSE: 
                    case PREPROCESSOR_ENDIF: 
                    case PREPROCESSOR_ERROR: 
                    case PREPROCESSOR_IDENT: 
                    case PREPROCESSOR_IF: 
                    case PREPROCESSOR_IFDEF: 
                    case PREPROCESSOR_IFNDEF: 
                    case PREPROCESSOR_INCLUDE: 
                    case PREPROCESSOR_INCLUDE_NEXT: 
                    case PREPROCESSOR_LINE: 
                    case PREPROCESSOR_PRAGMA: 
                    case PREPROCESSOR_UNDEF: 
                    case PREPROCESSOR_WARNING: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean shiftToNonWhite(TokenSequence<CppTokenId> tokenSequence, boolean bl) {
        do {
            switch ((CppTokenId)tokenSequence.token().id()) {
                case WHITESPACE: 
                case BLOCK_COMMENT: 
                case DOXYGEN_COMMENT: 
                case LINE_COMMENT: 
                case ESCAPED_LINE: 
                case ESCAPED_WHITESPACE: {
                    break;
                }
                default: {
                    return true;
                }
            }
        } while (!bl ? tokenSequence.moveNext() : tokenSequence.movePrevious());
        return false;
    }

    public static TokenItem<CppTokenId> getTokenCheckPrev(Document document, int n) {
        return CndTokenUtilities.getTokenImpl(document, n, true, true);
    }

    public static TokenItem<CppTokenId> getToken(Document document, int n, boolean bl) {
        return CndTokenUtilities.getTokenImpl(document, n, bl, false);
    }

    private static TokenItem<CppTokenId> getTokenImpl(Document document, int n, boolean bl, boolean bl2) {
        TokenSequence<CppTokenId> tokenSequence = CndLexerUtilities.getCppTokenSequence(document, n, bl, false);
        if (tokenSequence == null) {
            return null;
        }
        TokenItem<CppTokenId> tokenItem = CndTokenUtilities.getTokenImpl(tokenSequence, n, bl2);
        return tokenItem;
    }

    private static TokenItem<CppTokenId> getTokenImpl(TokenSequence<CppTokenId> tokenSequence, int n, boolean bl) {
        if (tokenSequence == null) {
            return null;
        }
        int n2 = tokenSequence.move(n);
        TokenItem tokenItem = null;
        boolean bl2 = false;
        if (tokenSequence.moveNext()) {
            String string;
            tokenItem = TokenItemImpl.create(tokenSequence);
            if (bl && n2 == 0 && ("whitespace".equals(string = ((CppTokenId)((Object)tokenItem.id())).primaryCategory()) || "comment".equals(string) || "separator".equals(string) || "operator".equals(string))) {
                bl2 = true;
            }
        }
        if (bl2 && tokenSequence.movePrevious()) {
            tokenItem = TokenItemImpl.create(tokenSequence);
        }
        return tokenItem;
    }

    private static boolean processTokensImpl(CndTokenProcessor<Token<CppTokenId>> cndTokenProcessor, TokenSequence<CppTokenId> tokenSequence, int n, int n2, boolean bl) {
        boolean bl2;
        boolean bl3 = false;
        boolean bl4 = n2 < n;
        boolean bl5 = bl;
        while (!cndTokenProcessor.isStopped() && (bl2 = bl5 || !bl4 ? tokenSequence.moveNext() : tokenSequence.movePrevious())) {
            bl5 = false;
            Token token = tokenSequence.token();
            if (!bl4 ? tokenSequence.offset() >= n2 : tokenSequence.offset() + token.length() < n2) break;
            if (cndTokenProcessor.token((Token<CppTokenId>)token, tokenSequence.offset())) {
                TokenSequence tokenSequence2 = tokenSequence.embedded();
                if (tokenSequence2 == null) continue;
                int n3 = 0;
                if (tokenSequence.offset() < n) {
                    n3 = tokenSequence2.move(n);
                }
                bl3 |= CndTokenUtilities.processTokensImpl(cndTokenProcessor, (TokenSequence<CppTokenId>)tokenSequence2, n, n2, n3 != 0);
                continue;
            }
            bl3 = true;
        }
        return bl3;
    }

    static {
        skipWSCategories.add("whitespace");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TokenItemImpl<T extends CppTokenId>
    extends TokenItem.AbstractItem<T> {
        public TokenItemImpl(T t, PartType partType, int n, CharSequence charSequence) {
            super(t, partType, n, charSequence);
        }

        private static <T extends CppTokenId> TokenItem<T> create(TokenSequence<T> tokenSequence) {
            Token token = tokenSequence.token();
            return new TokenItemImpl<CppTokenId>((CppTokenId)token.id(), token.partType(), tokenSequence.offset(), token.text());
        }

        private static <T extends CppTokenId> TokenItem<T> create(Token<T> token, int n) {
            return new TokenItemImpl<CppTokenId>((CppTokenId)token.id(), token.partType(), n, token.text());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SkipTokenProcessor
    extends CndAbstractTokenProcessor<Token<CppTokenId>> {
        private boolean stopped = false;
        private TokenItem<CppTokenId> tokenItem = null;
        private Token<CppTokenId> lastToken = null;
        private final Set<CppTokenId> skipTokenIds;
        private final Set<String> skipTokenCategories;
        private final boolean processPP;

        public SkipTokenProcessor(Set<CppTokenId> set, Set<String> set2, boolean bl) {
            this.skipTokenIds = set;
            this.skipTokenCategories = set2;
            this.processPP = bl;
        }

        @Override
        public boolean token(Token<CppTokenId> token, int n) {
            this.lastToken = token;
            if (token.id() == CppTokenId.PREPROCESSOR_DIRECTIVE) {
                return this.processPP;
            }
            if (!this.skipTokenIds.contains(token.id()) && !this.skipTokenCategories.contains(((CppTokenId)token.id()).primaryCategory())) {
                this.stopped = true;
            }
            return false;
        }

        @Override
        public boolean isStopped() {
            return this.stopped;
        }

        public TokenItem<CppTokenId> getTokenItem() {
            return this.tokenItem;
        }

        @Override
        public void end(int n, int n2) {
            super.end(n, n2);
            if (this.lastToken != null) {
                this.tokenItem = TokenItemImpl.create(this.lastToken, n2);
            }
        }
    }
}

