/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.lexer;

import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.cnd.api.lexer.MakefileTokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MakefileLexer
implements Lexer<MakefileTokenId> {
    private static Set<String> specialTarget = new HashSet<String>();
    private LexerRestartInfo<MakefileTokenId> info;

    MakefileLexer(LexerRestartInfo<MakefileTokenId> lexerRestartInfo) {
        this.info = lexerRestartInfo;
    }

    public Token<MakefileTokenId> nextToken() {
        LexerInput lexerInput = this.info.input();
        int n = lexerInput.read();
        switch (n) {
            case -1: {
                return null;
            }
            case 32: {
                do {
                    if ((n = lexerInput.read()) != 92) continue;
                    n = lexerInput.read();
                    if (n != 110) {
                        lexerInput.backup(2);
                        return this.info.tokenFactory().createToken((TokenId)MakefileTokenId.WHITESPACE);
                    }
                    n = lexerInput.read();
                } while (n == 32);
                if (n != -1) {
                    lexerInput.backup(1);
                }
                return this.info.tokenFactory().createToken((TokenId)MakefileTokenId.WHITESPACE);
            }
            case 92: {
                n = lexerInput.read();
                if (n == 110) {
                    do {
                        if ((n = lexerInput.read()) != 92) continue;
                        n = lexerInput.read();
                        if (n != 110) {
                            lexerInput.backup(2);
                            return this.info.tokenFactory().createToken((TokenId)MakefileTokenId.WHITESPACE);
                        }
                        n = lexerInput.read();
                    } while (n == 32);
                    if (n != -1) {
                        lexerInput.backup(1);
                    }
                    return this.info.tokenFactory().createToken((TokenId)MakefileTokenId.WHITESPACE);
                }
            }
            case 10: {
                return this.info.tokenFactory().createToken((TokenId)MakefileTokenId.NEW_LINE);
            }
            case 9: {
                return this.info.tokenFactory().createToken((TokenId)MakefileTokenId.TAB);
            }
            case 35: {
                while ((n = lexerInput.read()) != 10 && n != -1) {
                }
                return this.info.tokenFactory().createToken((TokenId)MakefileTokenId.LINE_COMMENT);
            }
            case 36: {
                if (MakefileLexer.readMacro(lexerInput)) {
                    return this.info.tokenFactory().createToken((TokenId)MakefileTokenId.MACRO);
                }
                return this.info.tokenFactory().createToken((TokenId)MakefileTokenId.ERROR);
            }
            case 58: {
                n = lexerInput.read();
                if (n == 115) {
                    n = lexerInput.read();
                    if (n == 104) {
                        return this.info.tokenFactory().createToken((TokenId)MakefileTokenId.MACRO_OPERATOR);
                    }
                    lexerInput.backup(2);
                    return this.info.tokenFactory().createToken((TokenId)MakefileTokenId.SEPARATOR);
                }
                if (n == 61) {
                    return this.info.tokenFactory().createToken((TokenId)MakefileTokenId.MACRO_OPERATOR);
                }
                if (n == 58) {
                    return this.info.tokenFactory().createToken((TokenId)MakefileTokenId.SEPARATOR);
                }
                if (n != -1) {
                    lexerInput.backup(1);
                }
                return this.info.tokenFactory().createToken((TokenId)MakefileTokenId.SEPARATOR);
            }
            case 61: {
                return this.info.tokenFactory().createToken((TokenId)MakefileTokenId.MACRO_OPERATOR);
            }
            case 43: {
                n = lexerInput.read();
                if (n == 61) {
                    return this.info.tokenFactory().createToken((TokenId)MakefileTokenId.MACRO_OPERATOR);
                }
                return this.info.tokenFactory().createToken((TokenId)MakefileTokenId.RULE_OPERATOR);
            }
            case 33: 
            case 45: 
            case 63: 
            case 64: {
                return this.info.tokenFactory().createToken((TokenId)MakefileTokenId.RULE_OPERATOR);
            }
            case 38: 
            case 40: 
            case 41: 
            case 44: 
            case 59: 
            case 60: 
            case 62: 
            case 91: 
            case 93: 
            case 123: 
            case 125: {
                return this.info.tokenFactory().createToken((TokenId)MakefileTokenId.SEPARATOR);
            }
            case 34: {
                do {
                    if ((n = lexerInput.read()) != 92) continue;
                    n = lexerInput.read();
                    n = lexerInput.read();
                } while (n != 34 && n != -1);
                return this.info.tokenFactory().createToken((TokenId)MakefileTokenId.STRING_LITERAL);
            }
            case 39: {
                do {
                    if ((n = lexerInput.read()) != 92) continue;
                    n = lexerInput.read();
                    n = lexerInput.read();
                } while (n != 39 && n != -1);
                return this.info.tokenFactory().createToken((TokenId)MakefileTokenId.STRING_LITERAL);
            }
            case 96: {
                do {
                    if ((n = lexerInput.read()) != 92) continue;
                    n = lexerInput.read();
                    n = lexerInput.read();
                } while (n != 96 && n != -1);
                return this.info.tokenFactory().createToken((TokenId)MakefileTokenId.STRING_LITERAL);
            }
        }
        do {
            if ((n = lexerInput.read()) != 92 || (n = lexerInput.read()) != 10) continue;
            lexerInput.backup(2);
            return this.identifier(lexerInput);
        } while (n != 9 && n != 10 && n != 13 && n != 32 && n != 92 && n != 36 && n != 39 && n != 34 && n != 96 && n != 58 && n != 40 && n != 41 && n != 91 && n != 93 && n != 123 && n != 125 && n != 59 && n != 38 && n != 61 && n != -1);
        if (n != -1) {
            lexerInput.backup(1);
        }
        return this.identifier(lexerInput);
    }

    private Token<MakefileTokenId> identifier(LexerInput lexerInput) {
        String string = ((Object)lexerInput.readText()).toString();
        if ("include".equals(string)) {
            return this.info.tokenFactory().createToken((TokenId)MakefileTokenId.KEYWORD);
        }
        if (specialTarget.contains(string)) {
            return this.info.tokenFactory().createToken((TokenId)MakefileTokenId.SPECIAL_TARGET);
        }
        return this.info.tokenFactory().createToken((TokenId)MakefileTokenId.IDENTIFIER);
    }

    private static boolean readMacro(LexerInput lexerInput) {
        switch (lexerInput.read()) {
            case 40: {
                return MakefileLexer.readTo(lexerInput, ')');
            }
            case 123: {
                return MakefileLexer.readTo(lexerInput, '}');
            }
            case -1: 
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return false;
            }
        }
        return true;
    }

    private static boolean readTo(LexerInput lexerInput, char c) {
        int n = lexerInput.read();
        while (n != -1) {
            switch (n) {
                case 36: {
                    if (MakefileLexer.readMacro(lexerInput)) break;
                    return false;
                }
                case 92: {
                    lexerInput.read();
                    break;
                }
                default: {
                    if (n != c) break;
                    return true;
                }
            }
            n = lexerInput.read();
        }
        return false;
    }

    public Object state() {
        return null;
    }

    public void release() {
    }

    static {
        specialTarget.add("%");
        specialTarget.add(".DEFAULT");
        specialTarget.add(".DONE");
        specialTarget.add(".FAILED");
        specialTarget.add(".GET_POSIX");
        specialTarget.add(".IGNORE");
        specialTarget.add(".INIT");
        specialTarget.add(".KEEP_STATE");
        specialTarget.add(".KEEP_STATE_FILE");
        specialTarget.add(".MAKE_VERSION");
        specialTarget.add(".NO_PARALLEL");
        specialTarget.add(".PARALLEL");
        specialTarget.add(".PHONY");
        specialTarget.add(".POSIX");
        specialTarget.add(".PRECIOUS");
        specialTarget.add(".SCCS_GET");
        specialTarget.add(".SCCS_GET_POSIX");
        specialTarget.add(".SILENT");
        specialTarget.add(".SUFFIXES");
        specialTarget.add(".WAIT");
    }
}

