/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.lexer;

import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.Filter;
import org.netbeans.modules.cnd.lexer.CndLexer;
import org.netbeans.spi.lexer.LexerRestartInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PreprocLexer
extends CndLexer {
    private static final int INIT = 0;
    private static final int DIRECTIVE_NAME = 1;
    private static final int EXPRESSION = 2;
    private static final int INCLUDE_DIRECTIVE = 3;
    private static final int OTHER = 4;
    private static final int SHIFT = 3;
    private static final int MASK = 7;
    private int state = 0;
    private final Filter<CppTokenId> preprocFilter = CndLexerUtilities.getPreprocFilter();
    private final Filter<CppTokenId> keywordsFilter;

    public PreprocLexer(Filter<CppTokenId> filter, LexerRestartInfo<CppTokenId> lexerRestartInfo) {
        super(lexerRestartInfo);
        Filter<CppTokenId> filter2 = (Filter<CppTokenId>)lexerRestartInfo.getAttributeValue((Object)"lexer-filter");
        this.keywordsFilter = filter2 != null ? filter2 : filter;
        this.fromState((Integer)lexerRestartInfo.state());
    }

    @Override
    public Object state() {
        Integer n = super.getState();
        int n2 = n == null ? 0 : n;
        int n3 = n2 << 3 | this.state;
        return n3;
    }

    private void fromState(Integer n) {
        if (n == null) {
            this.state = 0;
            super.setState(null);
        } else {
            this.state = n & 7;
            super.setState(n >> 3);
        }
    }

    @Override
    protected Token<CppTokenId> finishSharp() {
        if (this.state == 0) {
            return this.token(CppTokenId.PREPROCESSOR_START);
        }
        return super.finishSharp();
    }

    @Override
    protected Token<CppTokenId> finishDblQuote() {
        if (this.state == 3) {
            while (true) {
                switch (this.read(true)) {
                    case 34: {
                        return this.token(CppTokenId.PREPROCESSOR_USER_INCLUDE);
                    }
                    case 13: {
                        this.consumeNewline();
                    }
                    case -1: 
                    case 10: {
                        return this.tokenPart(CppTokenId.PREPROCESSOR_USER_INCLUDE, PartType.START);
                    }
                }
            }
        }
        return super.finishDblQuote();
    }

    @Override
    protected Token<CppTokenId> finishLT() {
        if (this.state == 3) {
            while (true) {
                switch (this.read(true)) {
                    case 62: {
                        return this.token(CppTokenId.PREPROCESSOR_SYS_INCLUDE);
                    }
                    case 13: {
                        this.consumeNewline();
                    }
                    case -1: 
                    case 10: {
                        return this.tokenPart(CppTokenId.PREPROCESSOR_SYS_INCLUDE, PartType.START);
                    }
                }
            }
        }
        return super.finishLT();
    }

    @Override
    protected CppTokenId getKeywordOrIdentifierID(CharSequence charSequence) {
        CppTokenId cppTokenId = null;
        switch (this.state) {
            case 1: {
                cppTokenId = this.preprocFilter.check(charSequence);
                break;
            }
            case 2: {
                if (TokenUtilities.textEquals((CharSequence)CppTokenId.PREPROCESSOR_DEFINED.fixedText(), (CharSequence)charSequence)) {
                    cppTokenId = CppTokenId.PREPROCESSOR_DEFINED;
                    break;
                }
            }
            case 4: {
                cppTokenId = this.keywordsFilter.check(charSequence);
            }
        }
        return cppTokenId != null ? cppTokenId : CppTokenId.PREPROCESSOR_IDENTIFIER;
    }

    @Override
    protected void postTokenCreate(CppTokenId cppTokenId) {
        assert (cppTokenId != null);
        block0 : switch (this.state) {
            case 0: {
                assert (cppTokenId == CppTokenId.PREPROCESSOR_START) : "in INIT state only CppTokenId.PREPROCESSOR_START is possible: " + (Object)((Object)cppTokenId);
                this.state = 1;
                break;
            }
            case 1: {
                if ("whitespace".equals(cppTokenId.primaryCategory()) || "comment".equals(cppTokenId.primaryCategory())) break;
                switch (cppTokenId) {
                    case PREPROCESSOR_IF: 
                    case PREPROCESSOR_ELIF: {
                        this.state = 2;
                        break block0;
                    }
                    case PREPROCESSOR_INCLUDE: 
                    case PREPROCESSOR_INCLUDE_NEXT: {
                        this.state = 3;
                        break block0;
                    }
                }
                this.state = 4;
                break;
            }
        }
    }
}

