/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.persistence;

import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceLocationProvider;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopeImplementation;
import org.netbeans.modules.j2ee.persistence.spi.support.EntityMappingsMetadataModelHelper;
import org.netbeans.modules.maven.api.classpath.ProjectSourcesClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceScopeImpl
implements PersistenceScopeImplementation {
    private PersistenceLocationProvider locationProvider = null;
    private final EntityMappingsMetadataModelHelper modelHelper;
    private ProjectSourcesClassPathProvider cpProvider;
    private ClassPath projectSourcesClassPath;

    public PersistenceScopeImpl(PersistenceLocationProvider persistenceLocationProvider, ProjectSourcesClassPathProvider projectSourcesClassPathProvider) {
        this.locationProvider = persistenceLocationProvider;
        this.cpProvider = projectSourcesClassPathProvider;
        this.modelHelper = this.createEntityMappingsHelper();
        FileObject fileObject = this.getPersistenceXml();
        if (fileObject != null) {
            this.modelHelper.changePersistenceXml(FileUtil.toFile((FileObject)fileObject));
        }
    }

    public FileObject getPersistenceXml() {
        FileObject fileObject = this.locationProvider.getLocation();
        if (fileObject == null) {
            return null;
        }
        return fileObject.getFileObject("persistence.xml");
    }

    public ClassPath getClassPath() {
        return this.getProjectSourcesClassPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassPath getProjectSourcesClassPath() {
        PersistenceScopeImpl persistenceScopeImpl = this;
        synchronized (persistenceScopeImpl) {
            if (this.projectSourcesClassPath == null) {
                this.projectSourcesClassPath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{this.cpProvider.getProjectSourcesClassPath("classpath/source"), this.cpProvider.getProjectSourcesClassPath("classpath/compile")});
            }
            return this.projectSourcesClassPath;
        }
    }

    public MetadataModel<EntityMappingsMetadata> getEntityMappingsModel(String string) {
        return this.modelHelper.getEntityMappingsModel(string);
    }

    private EntityMappingsMetadataModelHelper createEntityMappingsHelper() {
        return EntityMappingsMetadataModelHelper.create((ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/boot"), (ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/compile"), (ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/source"));
    }
}

