/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.api.db.explorer.ConnectionListener;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DatabaseConnectionConvertor;
import org.netbeans.modules.db.explorer.node.RootNode;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionList {
    private static ConnectionList DEFAULT;
    private final List<ConnectionListener> listeners = new CopyOnWriteArrayList<ConnectionListener>();
    private Lookup.Result<DatabaseConnection> result = this.getLookupResult();

    public static synchronized ConnectionList getDefault() {
        if (DEFAULT == null) {
            DatabaseConnectionConvertor.importOldConnections();
            RootNode.getOption().save();
            DEFAULT = new ConnectionList();
        }
        return DEFAULT;
    }

    private ConnectionList() {
        this.result.allInstances();
        this.result.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                ConnectionList.this.fireListeners();
            }
        });
    }

    public DatabaseConnection[] getConnections() {
        Collection collection = this.result.allInstances();
        return collection.toArray(new DatabaseConnection[collection.size()]);
    }

    public DatabaseConnection getConnection(DatabaseConnection databaseConnection) {
        if (databaseConnection == null) {
            throw new NullPointerException();
        }
        DatabaseConnection[] databaseConnectionArray = this.getConnections();
        for (int i = 0; i < databaseConnectionArray.length; ++i) {
            if (!databaseConnection.equals(databaseConnectionArray[i])) continue;
            return databaseConnectionArray[i];
        }
        return null;
    }

    public void add(DatabaseConnection databaseConnection) throws DatabaseException {
        if (databaseConnection == null) {
            throw new NullPointerException();
        }
        if (this.contains(databaseConnection)) {
            throw new DatabaseException(NbBundle.getMessage(ConnectionList.class, (String)"EXC_ConnectionAlreadyExists"));
        }
        try {
            DatabaseConnectionConvertor.create(databaseConnection);
        }
        catch (IOException iOException) {
            throw new DatabaseException(iOException);
        }
    }

    public boolean contains(DatabaseConnection databaseConnection) {
        return this.getConnection(databaseConnection) != null;
    }

    public void remove(DatabaseConnection databaseConnection) throws DatabaseException {
        if (databaseConnection == null) {
            throw new NullPointerException();
        }
        try {
            DatabaseConnectionConvertor.remove(databaseConnection);
        }
        catch (IOException iOException) {
            throw new DatabaseException(iOException);
        }
    }

    public void addConnectionListener(ConnectionListener connectionListener) {
        this.listeners.add(connectionListener);
    }

    public void removeConnectionListener(ConnectionListener connectionListener) {
        this.listeners.remove(connectionListener);
    }

    private void fireListeners() {
        for (ConnectionListener connectionListener : this.listeners) {
            connectionListener.connectionsChanged();
        }
    }

    private synchronized Lookup.Result<DatabaseConnection> getLookupResult() {
        return Lookups.forPath((String)"Databases/Connections").lookupResult(DatabaseConnection.class);
    }
}

