/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.RootNode;
import org.netbeans.modules.db.util.Base64;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.Environment;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.XMLDataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DatabaseConnectionConvertor
implements Environment.Provider,
InstanceCookie.Of {
    public static final String CONNECTIONS_PATH = "Databases/Connections";
    public static final Logger LOGGER = Logger.getLogger(DatabaseConnectionConvertor.class.getName());
    private static final int DELAY = 2000;
    private static final WeakHashMap<DatabaseConnection, DataObject> newConn2DO = new WeakHashMap();
    private static final Map<FileObject, DatabaseConnection> newFile2Conn = new ConcurrentHashMap<FileObject, DatabaseConnection>();
    private final Reference holder;
    private Lookup lookup = null;
    private Reference refConnection = new WeakReference<Object>(null);
    private PCL listener;

    private static DatabaseConnectionConvertor createProvider() {
        return new DatabaseConnectionConvertor();
    }

    private DatabaseConnectionConvertor() {
        this.holder = new WeakReference<Object>(null);
    }

    private DatabaseConnectionConvertor(XMLDataObject xMLDataObject) {
        this.holder = new WeakReference<XMLDataObject>(xMLDataObject);
        InstanceContent instanceContent = new InstanceContent();
        instanceContent.add((Object)this);
        this.lookup = new AbstractLookup((AbstractLookup.Content)instanceContent);
    }

    private DatabaseConnectionConvertor(XMLDataObject xMLDataObject, DatabaseConnection databaseConnection) {
        this(xMLDataObject);
        this.refConnection = new WeakReference<DatabaseConnection>(databaseConnection);
        this.attachListener();
    }

    public Lookup getEnvironment(DataObject dataObject) {
        DatabaseConnection databaseConnection = newFile2Conn.remove(dataObject.getPrimaryFile());
        if (databaseConnection != null) {
            return new DatabaseConnectionConvertor((XMLDataObject)dataObject, databaseConnection).getLookup();
        }
        return new DatabaseConnectionConvertor((XMLDataObject)dataObject).getLookup();
    }

    public String instanceName() {
        XMLDataObject xMLDataObject = this.getHolder();
        return xMLDataObject == null ? "" : xMLDataObject.getName();
    }

    public Class instanceClass() {
        return DatabaseConnection.class;
    }

    public boolean instanceOf(Class clazz) {
        return clazz.isAssignableFrom(DatabaseConnection.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object instanceCreate() throws IOException, ClassNotFoundException {
        DatabaseConnectionConvertor databaseConnectionConvertor = this;
        synchronized (databaseConnectionConvertor) {
            Object object;
            Object t = this.refConnection.get();
            if (t != null) {
                return t;
            }
            XMLDataObject xMLDataObject = this.getHolder();
            if (xMLDataObject == null) {
                return null;
            }
            FileObject fileObject = xMLDataObject.getPrimaryFile();
            Handler handler = new Handler(fileObject.getNameExt());
            try {
                object = XMLUtil.createXMLReader();
                InputSource inputSource = new InputSource(xMLDataObject.getPrimaryFile().getInputStream());
                inputSource.setSystemId(fileObject.getURL().toExternalForm());
                object.setContentHandler(handler);
                object.setErrorHandler(handler);
                object.setEntityResolver((EntityResolver)EntityCatalog.getDefault());
                object.parse(inputSource);
            }
            catch (SAXException sAXException) {
                Exception exception = sAXException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new IOException(sAXException.getMessage());
            }
            object = DatabaseConnectionConvertor.createDatabaseConnection(handler);
            this.refConnection = new WeakReference<Object>(object);
            this.attachListener();
            return object;
        }
    }

    private XMLDataObject getHolder() {
        return (XMLDataObject)this.holder.get();
    }

    private void attachListener() {
        this.listener = new PCL();
        DatabaseConnection databaseConnection = (DatabaseConnection)this.refConnection.get();
        databaseConnection.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)databaseConnection));
    }

    private static DatabaseConnection createDatabaseConnection(Handler handler) {
        DatabaseConnection databaseConnection = new DatabaseConnection(handler.driverClass, handler.driverName, handler.connectionUrl, handler.schema, handler.user, handler.password, handler.rememberPassword);
        return databaseConnection;
    }

    public static DataObject create(DatabaseConnection databaseConnection) throws IOException {
        FileObject fileObject = FileUtil.getConfigFile((String)CONNECTIONS_PATH);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        AtomicWriter atomicWriter = new AtomicWriter(databaseConnection, dataFolder, DatabaseConnectionConvertor.convertToFileName(databaseConnection.getName()));
        dataFolder.getPrimaryFile().getFileSystem().runAtomicAction((FileSystem.AtomicAction)atomicWriter);
        return atomicWriter.holder;
    }

    private static String convertToFileName(String string) {
        return string.substring(0, Math.min(32, string.length())).replaceAll("[^\\p{Alnum}]", "_");
    }

    public static void importOldConnections() {
        Vector vector = RootNode.getOption().getConnections();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            try {
                DatabaseConnectionConvertor.create((DatabaseConnection)iterator.next());
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            iterator.remove();
        }
    }

    public static void remove(DatabaseConnection databaseConnection) throws IOException {
        String string = databaseConnection.getName();
        FileObject fileObject = FileUtil.getConfigFile((String)CONNECTIONS_PATH);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        DataObject[] dataObjectArray = dataFolder.getChildren();
        for (int i = 0; i < dataObjectArray.length; ++i) {
            DatabaseConnection databaseConnection2;
            InstanceCookie instanceCookie = (InstanceCookie)dataObjectArray[i].getCookie(InstanceCookie.class);
            if (instanceCookie == null) continue;
            Object object = null;
            try {
                object = instanceCookie.instanceCreate();
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            if (!(object instanceof DatabaseConnection) || !(databaseConnection2 = (DatabaseConnection)object).getName().equals(string)) continue;
            dataObjectArray[i].delete();
            break;
        }
    }

    Lookup getLookup() {
        return this.lookup;
    }

    static String decodePassword(byte[] byArray) throws CharacterCodingException {
        CharsetDecoder charsetDecoder = Charset.forName("UTF-8").newDecoder();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        int n = (int)((double)byArray.length * (double)charsetDecoder.maxCharsPerByte());
        if (n == 0) {
            return null;
        }
        char[] cArray = new char[n];
        CharBuffer charBuffer = CharBuffer.wrap(cArray);
        CoderResult coderResult = charsetDecoder.decode(byteBuffer, charBuffer, true);
        if (!coderResult.isError() && !coderResult.isOverflow()) {
            coderResult = charsetDecoder.flush(charBuffer);
        }
        if (coderResult.isError() || coderResult.isOverflow()) {
            throw new CharacterCodingException();
        }
        return new String(cArray, 0, charBuffer.position());
    }

    private final class PCL
    implements PropertyChangeListener,
    Runnable {
        LinkedList keepAlive = new LinkedList();
        RequestProcessor.Task saveTask = null;

        private PCL() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PCL pCL = this;
            synchronized (pCL) {
                if (this.saveTask == null) {
                    this.saveTask = RequestProcessor.getDefault().create((Runnable)this);
                }
                this.keepAlive.add(propertyChangeEvent);
            }
            this.saveTask.schedule(2000);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            PropertyChangeEvent propertyChangeEvent;
            Object object = this;
            synchronized (object) {
                propertyChangeEvent = (PropertyChangeEvent)this.keepAlive.removeFirst();
            }
            object = (DatabaseConnection)propertyChangeEvent.getSource();
            XMLDataObject xMLDataObject = DatabaseConnectionConvertor.this.getHolder();
            if (xMLDataObject == null) {
                return;
            }
            try {
                xMLDataObject.getPrimaryFile().getFileSystem().runAtomicAction((FileSystem.AtomicAction)new AtomicWriter((DatabaseConnection)object, (MultiDataObject)xMLDataObject));
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.INFO, null, iOException);
            }
        }
    }

    private static final class Handler
    extends DefaultHandler {
        private static final String ELEMENT_DRIVER_CLASS = "driver-class";
        private static final String ELEMENT_DRIVER_NAME = "driver-name";
        private static final String ELEMENT_DATABASE_URL = "database-url";
        private static final String ELEMENT_SCHEMA = "schema";
        private static final String ELEMENT_USER = "user";
        private static final String ELEMENT_PASSWORD = "password";
        private static final String ELEMENT_REMEMBER_PASSWORD = "remember-password";
        private static final String ATTR_PROPERTY_VALUE = "value";
        private final String connectionFileName;
        String driverClass;
        String driverName;
        String connectionUrl;
        String schema;
        String user;
        String password;
        boolean rememberPassword;

        public Handler(String string) {
            this.connectionFileName = string;
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            String string4 = attributes.getValue(ATTR_PROPERTY_VALUE);
            if (ELEMENT_DRIVER_CLASS.equals(string3)) {
                this.driverClass = string4;
            } else if (ELEMENT_DRIVER_NAME.equals(string3)) {
                this.driverName = string4;
            } else if (ELEMENT_DATABASE_URL.equals(string3)) {
                this.connectionUrl = string4;
            } else if (ELEMENT_SCHEMA.equals(string3)) {
                this.schema = string4;
            } else if (ELEMENT_USER.equals(string3)) {
                this.user = string4;
            } else if (ELEMENT_PASSWORD.equals(string3)) {
                this.rememberPassword = true;
                byte[] byArray = null;
                try {
                    byArray = Base64.base64ToByteArray(string4);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Logger.getLogger("global").log(Level.WARNING, "Illegal Base 64 string in password for connection " + this.connectionFileName);
                    this.rememberPassword = false;
                }
                if (byArray != null) {
                    try {
                        this.password = DatabaseConnectionConvertor.decodePassword(byArray);
                    }
                    catch (CharacterCodingException characterCodingException) {
                        Logger.getLogger("global").log(Level.WARNING, "Illegal UTF-8 bytes in password for connection " + this.connectionFileName);
                        this.rememberPassword = false;
                    }
                }
            }
        }
    }

    private static final class AtomicWriter
    implements FileSystem.AtomicAction {
        DatabaseConnection instance;
        MultiDataObject holder;
        String fileName;
        DataFolder parent;

        AtomicWriter(DatabaseConnection databaseConnection, MultiDataObject multiDataObject) {
            this.instance = databaseConnection;
            this.holder = multiDataObject;
        }

        AtomicWriter(DatabaseConnection databaseConnection, DataFolder dataFolder, String string) {
            this.instance = databaseConnection;
            this.fileName = string;
            this.parent = dataFolder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws IOException {
            Object object;
            Object object2;
            FileLock fileLock;
            FileObject fileObject;
            if (this.holder != null) {
                fileObject = this.holder.getPrimaryEntry().getFile();
                fileLock = this.holder.getPrimaryEntry().takeLock();
            } else {
                object2 = this.parent.getPrimaryFile();
                object = FileUtil.findFreeFileName((FileObject)object2, (String)this.fileName, (String)"xml");
                fileObject = object2.createData((String)object, "xml");
                fileLock = fileObject.lock();
            }
            try {
                object2 = fileObject.getOutputStream(fileLock);
                object = new PrintWriter(new OutputStreamWriter((OutputStream)object2, "UTF8"));
                this.write((PrintWriter)object);
                ((PrintWriter)object).flush();
                ((PrintWriter)object).close();
                ((OutputStream)object2).close();
            }
            finally {
                fileLock.releaseLock();
            }
            if (this.holder == null) {
                newFile2Conn.put(fileObject, this.instance);
                this.holder = (MultiDataObject)DataObject.find((FileObject)fileObject);
                this.holder.getCookie(InstanceCookie.class);
                newConn2DO.put(this.instance, this.holder);
            }
        }

        void write(PrintWriter printWriter) throws IOException {
            printWriter.println("<?xml version='1.0'?>");
            printWriter.println("<!DOCTYPE connection PUBLIC '-//NetBeans//DTD Database Connection 1.1//EN' 'http://www.netbeans.org/dtds/connection-1_1.dtd'>");
            printWriter.println("<connection>");
            printWriter.println("  <driver-class value='" + XMLUtil.toAttributeValue((String)this.instance.getDriver()) + "'/>");
            printWriter.println("  <driver-name value='" + XMLUtil.toAttributeValue((String)this.instance.getDriverName()) + "'/>");
            printWriter.println("  <database-url value='" + XMLUtil.toAttributeValue((String)this.instance.getDatabase()) + "'/>");
            if (this.instance.getSchema() != null) {
                printWriter.println("  <schema value='" + XMLUtil.toAttributeValue((String)this.instance.getSchema()) + "'/>");
            }
            if (this.instance.getUser() != null) {
                printWriter.println("  <user value='" + XMLUtil.toAttributeValue((String)this.instance.getUser()) + "'/>");
            }
            if (this.instance.rememberPassword()) {
                String string = this.instance.getPassword();
                if (string == null) {
                    LOGGER.log(Level.INFO, "Password is null, saving it as an empty string");
                    string = "";
                }
                printWriter.println("  <password value='" + Base64.byteArrayToBase64(string.getBytes("UTF-8")) + "'/>");
            }
            printWriter.println("</connection>");
        }
    }
}

