/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.action;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DbUtilities;
import org.netbeans.modules.db.explorer.action.BaseAction;
import org.netbeans.modules.db.explorer.action.RefreshAction;
import org.netbeans.modules.db.explorer.dlg.AddTableColumnDialog;
import org.netbeans.modules.db.explorer.node.TableNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class AddColumnAction
extends BaseAction {
    private static final Logger LOGGER = Logger.getLogger(AddColumnAction.class.getName());

    public String getName() {
        return NbBundle.getMessage(AddColumnAction.class, (String)"AddColumn");
    }

    protected boolean enable(Node[] nodeArray) {
        boolean bl = nodeArray.length == 1 && nodeArray[0].getLookup().lookup(TableNode.class) != null;
        return bl;
    }

    protected void performAction(final Node[] nodeArray) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                TableNode tableNode = (TableNode)nodeArray[0].getLookup().lookup(TableNode.class);
                DatabaseConnection databaseConnection = (DatabaseConnection)tableNode.getLookup().lookup(DatabaseConnection.class);
                try {
                    AddTableColumnDialog addTableColumnDialog = new AddTableColumnDialog(databaseConnection.getConnector().getDatabaseSpecification(), tableNode);
                    if (addTableColumnDialog.run()) {
                        ((RefreshAction)SystemAction.get(RefreshAction.class)).performAction(new Node[]{tableNode});
                    }
                }
                catch (Exception exception) {
                    LOGGER.log(Level.WARNING, null, exception);
                    DbUtilities.reportError(NbBundle.getMessage(AddColumnAction.class, (String)"ERR_UnableToAddColumn"), exception.getMessage());
                }
            }
        });
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(AddColumnAction.class);
    }
}

