/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.DatabaseMetaDataTransfer;
import org.netbeans.api.db.explorer.node.BaseNode;
import org.netbeans.api.db.explorer.node.ChildNodeFactory;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.ConnectionList;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DatabaseMetaDataTransferAccessor;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModels;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.datatransfer.ExTransferable;

public class ConnectionNode
extends BaseNode {
    private static final String CONNECTEDICONBASE = "org/netbeans/modules/db/resources/connection.gif";
    private static final String DISCONNECTEDICONBASE = "org/netbeans/modules/db/resources/connectionDisconnected.gif";
    private static final String FOLDER = "Connection";
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);

    public static ConnectionNode create(NodeDataLookup nodeDataLookup, NodeProvider nodeProvider) {
        ConnectionNode connectionNode = new ConnectionNode(nodeDataLookup, nodeProvider);
        connectionNode.setup();
        return connectionNode;
    }

    private ConnectionNode(NodeDataLookup nodeDataLookup, NodeProvider nodeProvider) {
        super(new ChildNodeFactory((Lookup)nodeDataLookup), nodeDataLookup, FOLDER, nodeProvider);
    }

    protected void initialize() {
        this.connection.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("connectionComplete") || propertyChangeEvent.getPropertyName().equals("disconnected")) {
                    ConnectionNode.this.updateModel();
                }
            }
        });
        this.updateModel();
    }

    public void setPropertyValue(Node.Property property, Object object) {
        super.setPropertyValue(property, object);
        boolean bl = true;
        if (property.getName().equals("User")) {
            this.connection.setUser(object.toString());
        } else if (property.getName().equals("RememberPassword")) {
            this.connection.setRememberPassword((Boolean)object);
            bl = false;
        } else if (property.getName().equals("DatabaseURL")) {
            this.connection.setDatabase(object.toString());
        } else if (property.getName().equals("DriverURL")) {
            this.connection.setDriver(object.toString());
        } else if (property.getName().equals("Schema")) {
            this.connection.setSchema(object.toString());
        } else if (property.getName().equals("DefaultSchema")) {
            this.connection.setSchema(object.toString());
        } else if (property.getName().equals("Schema")) {
            this.connection.setSchema(object.toString());
        }
        if (bl) {
            this.refresh();
        }
    }

    private void updateLocalProperties() {
        try {
            this.clearProperties();
            boolean bl = !this.connection.getConnector().isDisconnected();
            this.addProperty("DatabaseURL", "DatabaseURLDescription", String.class, !bl, this.connection.getDatabase());
            this.addProperty("DriverURL", "DriverURLDescription", String.class, !bl, this.connection.getDriver());
            this.addProperty("Schema", "SchemaDescription", String.class, false, this.connection.getSchema());
            this.addProperty("User", "UserDescription", String.class, !bl, this.connection.getUser());
            this.addProperty("RememberPassword", "RememberPasswordDescription", Boolean.class, !bl, this.connection.rememberPassword());
            if (bl) {
                Specification specification = this.connection.getConnector().getDatabaseSpecification();
                DatabaseMetaData databaseMetaData = specification.getMetaData();
                this.addProperty("databaseProductName", null, String.class, false, databaseMetaData.getDatabaseProductName());
                this.addProperty("databaseProductVersion", null, String.class, false, databaseMetaData.getDatabaseProductVersion());
                this.addProperty("readOnly", null, Boolean.class, false, databaseMetaData.isReadOnly());
                this.addProperty("mixedCaseIdentifiers", null, Boolean.class, false, databaseMetaData.supportsMixedCaseIdentifiers());
                this.addProperty("mixedCaseQuotedIdentifiers", null, Boolean.class, false, databaseMetaData.supportsMixedCaseQuotedIdentifiers());
                this.addProperty("alterTableWithAddColumn", null, Boolean.class, false, databaseMetaData.supportsAlterTableWithAddColumn());
                this.addProperty("alterTableWithDropColumn", null, Boolean.class, false, databaseMetaData.supportsAlterTableWithDropColumn());
                this.addProperty("convert", null, Boolean.class, false, databaseMetaData.supportsConvert());
                this.addProperty("tableCorrelationNames", null, Boolean.class, false, databaseMetaData.supportsTableCorrelationNames());
                this.addProperty("tableCorrelationNames", null, Boolean.class, false, databaseMetaData.supportsDifferentTableCorrelationNames());
                this.addProperty("expressionsInOrderBy", null, Boolean.class, false, databaseMetaData.supportsExpressionsInOrderBy());
                this.addProperty("orderByUnrelated", null, Boolean.class, false, databaseMetaData.supportsOrderByUnrelated());
                this.addProperty("groupBy", null, Boolean.class, false, databaseMetaData.supportsGroupBy());
                this.addProperty("groupByUnrelated", null, Boolean.class, false, databaseMetaData.supportsGroupByUnrelated());
                this.addProperty("groupByBeyondSelect", null, Boolean.class, false, databaseMetaData.supportsGroupByBeyondSelect());
                this.addProperty("likeEscapeClause", null, Boolean.class, false, databaseMetaData.supportsLikeEscapeClause());
                this.addProperty("multipleResultSets", null, Boolean.class, false, databaseMetaData.supportsMultipleResultSets());
                this.addProperty("multipleTransactions", null, Boolean.class, false, databaseMetaData.supportsMultipleTransactions());
                this.addProperty("nonNullableColumns", null, Boolean.class, false, databaseMetaData.supportsNonNullableColumns());
                this.addProperty("minimumSQLGrammar", null, Boolean.class, false, databaseMetaData.supportsMinimumSQLGrammar());
                this.addProperty("coreSQLGrammar", null, Boolean.class, false, databaseMetaData.supportsCoreSQLGrammar());
                this.addProperty("extendedSQLGrammar", null, Boolean.class, false, databaseMetaData.supportsExtendedSQLGrammar());
                this.addProperty("ANSI92EntryLevelSQL", null, Boolean.class, false, databaseMetaData.supportsANSI92EntryLevelSQL());
                this.addProperty("ANSI92IntermediateSQL", null, Boolean.class, false, databaseMetaData.supportsANSI92IntermediateSQL());
                this.addProperty("ANSI92FullSQL", null, Boolean.class, false, databaseMetaData.supportsANSI92FullSQL());
                this.addProperty("IntegrityEnhancementFacility", null, Boolean.class, false, databaseMetaData.supportsIntegrityEnhancementFacility());
                this.addProperty("outerJoins", null, Boolean.class, false, databaseMetaData.supportsOuterJoins());
                this.addProperty("fullOuterJoins", null, Boolean.class, false, databaseMetaData.supportsFullOuterJoins());
                this.addProperty("limitedOuterJoins", null, Boolean.class, false, databaseMetaData.supportsLimitedOuterJoins());
                this.addProperty("schemasInDataManipulation", null, Boolean.class, false, databaseMetaData.supportsSchemasInDataManipulation());
                this.addProperty("schemasInProcedureCalls", null, Boolean.class, false, databaseMetaData.supportsSchemasInProcedureCalls());
                this.addProperty("schemasInTableDefinitions", null, Boolean.class, false, databaseMetaData.supportsSchemasInTableDefinitions());
                this.addProperty("schemasInIndexDefinitions", null, Boolean.class, false, databaseMetaData.supportsSchemasInIndexDefinitions());
                this.addProperty("schemasInPrivilegeDefinitions", null, Boolean.class, false, databaseMetaData.supportsSchemasInPrivilegeDefinitions());
                this.addProperty("catalogsInDataManipulation", null, Boolean.class, false, databaseMetaData.supportsCatalogsInDataManipulation());
                this.addProperty("catalogsInProcedureCalls", null, Boolean.class, false, databaseMetaData.supportsCatalogsInProcedureCalls());
                this.addProperty("catalogsInTableDefinitions", null, Boolean.class, false, databaseMetaData.supportsCatalogsInTableDefinitions());
                this.addProperty("catalogsInIndexDefinitions", null, Boolean.class, false, databaseMetaData.supportsCatalogsInIndexDefinitions());
                this.addProperty("catalogsInPrivilegeDefinitions", null, Boolean.class, false, databaseMetaData.supportsCatalogsInPrivilegeDefinitions());
                this.addProperty("positionedDelete", null, Boolean.class, false, databaseMetaData.supportsPositionedDelete());
                this.addProperty("positionedUpdate", null, Boolean.class, false, databaseMetaData.supportsPositionedUpdate());
                this.addProperty("selectForUpdate", null, Boolean.class, false, databaseMetaData.supportsSelectForUpdate());
                this.addProperty("storedProcedures", null, Boolean.class, false, databaseMetaData.supportsStoredProcedures());
                this.addProperty("subqueriesInComparisons", null, Boolean.class, false, databaseMetaData.supportsSubqueriesInComparisons());
                this.addProperty("subqueriesInExists", null, Boolean.class, false, databaseMetaData.supportsSubqueriesInExists());
                this.addProperty("subqueriesInIns", null, Boolean.class, false, databaseMetaData.supportsSubqueriesInIns());
                this.addProperty("subqueriesInQuantifieds", null, Boolean.class, false, databaseMetaData.supportsSubqueriesInQuantifieds());
                this.addProperty("correlatedSubqueries", null, Boolean.class, false, databaseMetaData.supportsCorrelatedSubqueries());
                this.addProperty("union", null, Boolean.class, false, databaseMetaData.supportsUnion());
                this.addProperty("unionAll", null, Boolean.class, false, databaseMetaData.supportsUnionAll());
                this.addProperty("openCursorsAcrossCommit", null, Boolean.class, false, databaseMetaData.supportsOpenCursorsAcrossCommit());
                this.addProperty("openCursorsAcrossRollback", null, Boolean.class, false, databaseMetaData.supportsOpenCursorsAcrossRollback());
                this.addProperty("openStatementsAcrossCommit", null, Boolean.class, false, databaseMetaData.supportsOpenStatementsAcrossCommit());
                this.addProperty("openStatementsAcrossRollback", null, Boolean.class, false, databaseMetaData.supportsOpenStatementsAcrossRollback());
                this.addProperty("transactions", null, Boolean.class, false, databaseMetaData.supportsTransactions());
                this.addProperty("dataDefinitionAndDataManipulationTransactions", null, Boolean.class, false, databaseMetaData.supportsDataDefinitionAndDataManipulationTransactions());
                this.addProperty("dataManipulationTransactionsOnly", null, Boolean.class, false, databaseMetaData.supportsDataManipulationTransactionsOnly());
                this.addProperty("batchUpdates", null, Boolean.class, false, databaseMetaData.supportsBatchUpdates());
                this.addProperty("catalogAtStart", null, Boolean.class, false, databaseMetaData.isCatalogAtStart());
                this.addProperty("columnAliasing", null, Boolean.class, false, databaseMetaData.supportsColumnAliasing());
                this.addProperty("dataDefinitionCausesTransactionCommit", null, Boolean.class, false, databaseMetaData.dataDefinitionCausesTransactionCommit());
                this.addProperty("dataDefinitionIgnoredInTransactions", null, Boolean.class, false, databaseMetaData.dataDefinitionIgnoredInTransactions());
                this.addProperty("differentTableCorrelationNames", null, Boolean.class, false, databaseMetaData.supportsDifferentTableCorrelationNames());
                this.addProperty("localFiles", null, Boolean.class, false, databaseMetaData.usesLocalFiles());
                this.addProperty("localFilePerTable", null, Boolean.class, false, databaseMetaData.usesLocalFilePerTable());
                this.addProperty("maxRowSizeIncludeBlobs", null, Boolean.class, false, databaseMetaData.doesMaxRowSizeIncludeBlobs());
                this.addProperty("nullPlusNonNullIsNull", null, Boolean.class, false, databaseMetaData.nullPlusNonNullIsNull());
                this.addProperty("proceduresAreCallable", null, Boolean.class, false, databaseMetaData.allProceduresAreCallable());
                this.addProperty("tablesAreSelectable", null, Boolean.class, false, databaseMetaData.allTablesAreSelectable());
                this.addProperty("maxBinaryLiteralLength", null, Integer.class, false, databaseMetaData.getMaxBinaryLiteralLength());
                this.addProperty("maxCharLiteralLength", null, Integer.class, false, databaseMetaData.getMaxCharLiteralLength());
                this.addProperty("maxColumnNameLength", null, Integer.class, false, databaseMetaData.getMaxColumnNameLength());
                this.addProperty("maxColumnsInGroupBy", null, Integer.class, false, databaseMetaData.getMaxColumnsInGroupBy());
                this.addProperty("maxColumnsInIndex", null, Integer.class, false, databaseMetaData.getMaxColumnsInIndex());
                this.addProperty("maxColumnsInOrderBy", null, Integer.class, false, databaseMetaData.getMaxColumnsInOrderBy());
                this.addProperty("maxColumnsInSelect", null, Integer.class, false, databaseMetaData.getMaxColumnsInSelect());
                this.addProperty("maxColumnsInTable", null, Integer.class, false, databaseMetaData.getMaxColumnsInTable());
                this.addProperty("maxConnections", null, Integer.class, false, databaseMetaData.getMaxConnections());
                this.addProperty("maxCursorNameLength", null, Integer.class, false, databaseMetaData.getMaxCursorNameLength());
                this.addProperty("maxIndexLength", null, Integer.class, false, databaseMetaData.getMaxIndexLength());
                this.addProperty("maxSchemaNameLength", null, Integer.class, false, databaseMetaData.getMaxSchemaNameLength());
                this.addProperty("maxProcedureNameLength", null, Integer.class, false, databaseMetaData.getMaxProcedureNameLength());
                this.addProperty("maxCatalogNameLength", null, Integer.class, false, databaseMetaData.getMaxCatalogNameLength());
                this.addProperty("maxRowSize", null, Integer.class, false, databaseMetaData.getMaxRowSize());
                this.addProperty("maxStatementLength", null, Integer.class, false, databaseMetaData.getMaxStatementLength());
                this.addProperty("maxStatements", null, Integer.class, false, databaseMetaData.getMaxStatements());
                this.addProperty("maxTableNameLength", null, Integer.class, false, databaseMetaData.getMaxTableNameLength());
                this.addProperty("maxTablesInSelect", null, Integer.class, false, databaseMetaData.getMaxTablesInSelect());
                this.addProperty("maxUserNameLength", null, Integer.class, false, databaseMetaData.getMaxUserNameLength());
                this.addProperty("defaultTransactionIsolation", null, Integer.class, false, databaseMetaData.getDefaultTransactionIsolation());
                this.addProperty("driverName", null, String.class, false, databaseMetaData.getDriverName());
                this.addProperty("driverVersion", null, String.class, false, databaseMetaData.getDriverVersion());
                this.addProperty("driverMajorVersion", null, Integer.class, false, databaseMetaData.getDriverMajorVersion());
                this.addProperty("driverMinorVersion", null, Integer.class, false, databaseMetaData.getDriverMinorVersion());
                this.addProperty("identifierQuoteString", null, String.class, false, databaseMetaData.getIdentifierQuoteString());
                this.addProperty("SQLKeywords", null, String.class, false, databaseMetaData.getSQLKeywords());
                this.addProperty("numericFunctions", null, String.class, false, databaseMetaData.getNumericFunctions());
                this.addProperty("stringFunctions", null, String.class, false, databaseMetaData.getStringFunctions());
                this.addProperty("systemFunctions", null, String.class, false, databaseMetaData.getSystemFunctions());
                this.addProperty("timeDateFunctions", null, String.class, false, databaseMetaData.getTimeDateFunctions());
                this.addProperty("searchStringEscape", null, String.class, false, databaseMetaData.getSearchStringEscape());
                this.addProperty("extraNameCharacters", null, String.class, false, databaseMetaData.getExtraNameCharacters());
                this.addProperty("schemaTerm", null, String.class, false, databaseMetaData.getSchemaTerm());
                this.addProperty("procedureTerm", null, String.class, false, databaseMetaData.getProcedureTerm());
                this.addProperty("catalogTerm", null, String.class, false, databaseMetaData.getCatalogTerm());
                this.addProperty("catalogSeparator", null, String.class, false, databaseMetaData.getCatalogSeparator());
            }
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    public DatabaseConnection getDatabaseConnection() {
        return this.connection;
    }

    private synchronized void updateModel() {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                boolean bl;
                boolean bl2 = bl = !ConnectionNode.this.connection.getConnector().isDisconnected();
                if (bl) {
                    MetadataModel metadataModel = MetadataModels.createModel((Connection)ConnectionNode.this.connection.getConnection(), (String)ConnectionNode.this.connection.getSchema());
                    ConnectionNode.this.connection.setMetadataModel(metadataModel);
                    ConnectionNode.this.refresh();
                } else {
                    ConnectionNode.this.connection.setMetadataModel(null);
                    ConnectionNode.this.refresh();
                }
                ConnectionNode.this.updateLocalProperties();
            }
        });
    }

    public boolean canDestroy() {
        boolean bl = true;
        Connection connection = this.connection.getJDBCConnection();
        if (connection != null) {
            try {
                bl = connection.isClosed();
            }
            catch (SQLException sQLException) {
                Exceptions.printStackTrace((Throwable)sQLException);
            }
        }
        return bl;
    }

    public void destroy() {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                try {
                    ConnectionList.getDefault().remove(ConnectionNode.this.connection);
                }
                catch (DatabaseException databaseException) {
                    Exceptions.printStackTrace((Throwable)databaseException);
                }
            }
        });
    }

    public String getName() {
        return this.connection.getName();
    }

    public String getDisplayName() {
        return this.connection.getName();
    }

    public String getIconBase() {
        boolean bl = true;
        Connection connection = this.connection.getConnection();
        if (connection != null) {
            try {
                bl = connection.isClosed();
            }
            catch (SQLException sQLException) {
                Exceptions.printStackTrace((Throwable)sQLException);
            }
        }
        if (bl) {
            return DISCONNECTEDICONBASE;
        }
        return CONNECTEDICONBASE;
    }

    public boolean canCopy() {
        return true;
    }

    public Transferable clipboardCopy() throws IOException {
        ExTransferable exTransferable = ExTransferable.create((Transferable)super.clipboardCopy());
        exTransferable.put(new ExTransferable.Single(DatabaseMetaDataTransfer.CONNECTION_FLAVOR){

            protected Object getData() {
                return DatabaseMetaDataTransferAccessor.DEFAULT.createConnectionData(ConnectionNode.this.connection.getDatabaseConnection(), ConnectionNode.this.connection.findJDBCDriver());
            }
        });
        return exTransferable;
    }

    public String getShortDescription() {
        return NbBundle.getMessage(ConnectionNode.class, (String)"ND_Connection");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ConnectionNode.class);
    }
}

