/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverListener;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.api.db.explorer.node.NodeProviderFactory;
import org.netbeans.modules.db.explorer.node.DriverNode;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class DriverNodeProvider
extends NodeProvider {
    public static NodeProviderFactory getFactory() {
        return FactoryHolder.FACTORY;
    }

    private DriverNodeProvider(Lookup lookup) {
        super(lookup, new DriverComparator());
        JDBCDriverManager jDBCDriverManager = JDBCDriverManager.getDefault();
        jDBCDriverManager.addDriverListener(new JDBCDriverListener(){

            public void driversChanged() {
                DriverNodeProvider.this.initialize();
            }
        });
    }

    protected synchronized void initialize() {
        JDBCDriver[] jDBCDriverArray;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (JDBCDriver jDBCDriver : jDBCDriverArray = JDBCDriverManager.getDefault().getDrivers()) {
            Collection<Node> collection = this.getNodes(jDBCDriver);
            if (collection.size() > 0) {
                arrayList.addAll(collection);
                continue;
            }
            NodeDataLookup nodeDataLookup = new NodeDataLookup();
            nodeDataLookup.add(jDBCDriver);
            arrayList.add((Node)DriverNode.create(nodeDataLookup, this));
        }
        this.setNodes(arrayList);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DriverComparator
    implements Comparator<Node> {
        DriverComparator() {
        }

        @Override
        public int compare(Node node, Node node2) {
            return node.getDisplayName().compareToIgnoreCase(node2.getDisplayName());
        }
    }

    private static class FactoryHolder {
        static final NodeProviderFactory FACTORY = new NodeProviderFactory(){

            public DriverNodeProvider createInstance(Lookup lookup) {
                return new DriverNodeProvider(lookup);
            }
        };

        private FactoryHolder() {
        }
    }
}

