/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import org.netbeans.api.db.explorer.node.BaseNode;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.ForeignKeyListNode;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.IndexColumn;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.api.Ordering;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class IndexColumnNode
extends BaseNode {
    private static final String ICONDOWN = "org/netbeans/modules/db/resources/indexDown.gif";
    private static final String ICONUP = "org/netbeans/modules/db/resources/indexUp.gif";
    private static final String FOLDER = "IndexColumn";
    private String name = "";
    private String icon = "";
    private int position = 0;
    private MetadataElementHandle<IndexColumn> indexColumnHandle;
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);

    public static IndexColumnNode create(NodeDataLookup nodeDataLookup, NodeProvider nodeProvider) {
        IndexColumnNode indexColumnNode = new IndexColumnNode(nodeDataLookup, nodeProvider);
        indexColumnNode.setup();
        return indexColumnNode;
    }

    private IndexColumnNode(NodeDataLookup nodeDataLookup, NodeProvider nodeProvider) {
        super(nodeDataLookup, FOLDER, nodeProvider);
        this.indexColumnHandle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);
    }

    protected void initialize() {
        boolean bl = !this.connection.getConnector().isDisconnected();
        MetadataModel metadataModel = this.connection.getMetadataModel();
        if (bl && metadataModel != null) {
            try {
                metadataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metadata) {
                        IndexColumn indexColumn = (IndexColumn)IndexColumnNode.this.indexColumnHandle.resolve(metadata);
                        IndexColumnNode.this.name = indexColumn.getName();
                        if (indexColumn.getOrdering() == Ordering.DESCENDING) {
                            IndexColumnNode.this.icon = IndexColumnNode.ICONUP;
                        } else {
                            IndexColumnNode.this.icon = IndexColumnNode.ICONDOWN;
                        }
                        IndexColumnNode.this.position = indexColumn.getPosition();
                        IndexColumnNode.this.updateProperties(indexColumn);
                    }
                });
            }
            catch (MetadataModelException metadataModelException) {
                Exceptions.printStackTrace((Throwable)metadataModelException);
            }
        }
    }

    private void updateProperties(IndexColumn indexColumn) {
        PropertySupport.Name name = new PropertySupport.Name((Node)this);
        this.addProperty((Node.Property)name);
        this.addProperty("Position", "PositionDescription", Integer.class, false, indexColumn.getPosition());
    }

    public int getPosition() {
        return this.position;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getIconBase() {
        return this.icon;
    }

    public String getShortDescription() {
        return NbBundle.getMessage(ForeignKeyListNode.class, (String)"ND_Column");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(IndexColumnNode.class);
    }
}

