/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.api.db.explorer.node.NodeProviderFactory;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.ProcedureParamNode;
import org.netbeans.modules.db.explorer.node.ReturnValueNode;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElement;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.api.Parameter;
import org.netbeans.modules.db.metadata.model.api.Procedure;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class ProcedureParamNodeProvider
extends NodeProvider {
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);
    private final MetadataElementHandle<Procedure> handle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);

    public static NodeProviderFactory getFactory() {
        return FactoryHolder.FACTORY;
    }

    private ProcedureParamNodeProvider(Lookup lookup) {
        super(lookup, new ParameterComparator());
    }

    protected synchronized void initialize() {
        final ArrayList<Node> arrayList = new ArrayList<Node>();
        boolean bl = !this.connection.getConnector().isDisconnected();
        MetadataModel metadataModel = this.connection.getMetadataModel();
        if (bl && metadataModel != null) {
            try {
                metadataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metadata) {
                        Procedure procedure = (Procedure)ProcedureParamNodeProvider.this.handle.resolve(metadata);
                        Collection collection = procedure.getParameters();
                        for (Parameter parameter : collection) {
                            MetadataElementHandle metadataElementHandle = MetadataElementHandle.create((MetadataElement)parameter);
                            Collection collection2 = ProcedureParamNodeProvider.this.getNodes(metadataElementHandle);
                            if (collection2.size() > 0) {
                                arrayList.addAll(collection2);
                                continue;
                            }
                            NodeDataLookup nodeDataLookup = new NodeDataLookup();
                            nodeDataLookup.add(ProcedureParamNodeProvider.this.connection);
                            nodeDataLookup.add(metadataElementHandle);
                            arrayList.add(ProcedureParamNode.create(nodeDataLookup, ProcedureParamNodeProvider.this));
                        }
                    }
                });
            }
            catch (MetadataModelException metadataModelException) {
                Exceptions.printStackTrace((Throwable)metadataModelException);
            }
        }
        this.setNodes(arrayList);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ParameterComparator
    implements Comparator<Node> {
        ParameterComparator() {
        }

        @Override
        public int compare(Node node, Node node2) {
            int n;
            int n2;
            if (node instanceof ReturnValueNode) {
                n2 = 0;
            } else {
                ProcedureParamNode procedureParamNode = (ProcedureParamNode)node;
                n2 = procedureParamNode.getPosition();
            }
            if (node2 instanceof ReturnValueNode) {
                n = 0;
            } else {
                ProcedureParamNode procedureParamNode = (ProcedureParamNode)node;
                n = procedureParamNode.getPosition();
            }
            int n3 = 1;
            if (n2 < n) {
                n3 = -1;
            }
            return n3;
        }
    }

    private static class FactoryHolder {
        static final NodeProviderFactory FACTORY = new NodeProviderFactory(){

            public ProcedureParamNodeProvider createInstance(Lookup lookup) {
                ProcedureParamNodeProvider procedureParamNodeProvider = new ProcedureParamNodeProvider(lookup);
                return procedureParamNodeProvider;
            }
        };

        private FactoryHolder() {
        }
    }
}

