/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import org.netbeans.api.db.explorer.DatabaseMetaDataTransfer;
import org.netbeans.api.db.explorer.node.BaseNode;
import org.netbeans.api.db.explorer.node.ChildNodeFactory;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.lib.ddl.impl.AbstractCommand;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DatabaseConnector;
import org.netbeans.modules.db.explorer.DatabaseMetaDataTransferAccessor;
import org.netbeans.modules.db.explorer.action.RefreshAction;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.SchemaNameProvider;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.api.Table;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableNode
extends BaseNode
implements SchemaNameProvider {
    private static final String ICONBASE = "org/netbeans/modules/db/resources/table.gif";
    private static final String FOLDER = "Table";
    private String name = "";
    private final MetadataElementHandle<Table> tableHandle;
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);

    public static TableNode create(NodeDataLookup nodeDataLookup, NodeProvider nodeProvider) {
        TableNode tableNode = new TableNode(nodeDataLookup, nodeProvider);
        tableNode.setup();
        return tableNode;
    }

    private TableNode(NodeDataLookup nodeDataLookup, NodeProvider nodeProvider) {
        super(new ChildNodeFactory((Lookup)nodeDataLookup), nodeDataLookup, FOLDER, nodeProvider);
        this.tableHandle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);
    }

    @Override
    protected void initialize() {
        boolean bl = !this.connection.getConnector().isDisconnected();
        MetadataModel metadataModel = this.connection.getMetadataModel();
        if (bl && metadataModel != null) {
            try {
                metadataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metadata) {
                        Table table = (Table)TableNode.this.tableHandle.resolve(metadata);
                        TableNode.this.name = table.getName();
                        TableNode.this.updateProperties(table);
                    }
                });
            }
            catch (MetadataModelException metadataModelException) {
                Exceptions.printStackTrace((Throwable)metadataModelException);
            }
        }
    }

    private void updateProperties(Table table) {
        PropertySupport.Name name = new PropertySupport.Name((Node)this);
        this.addProperty((Node.Property)name);
        this.addProperty("Catalog", "CatalogDescription", String.class, false, this.getCatalogName());
        this.addProperty("Schema", "SchemaDescription", String.class, false, this.getSchemaName());
    }

    public MetadataElementHandle<Table> getTableHandle() {
        return this.tableHandle;
    }

    @Override
    public String getCatalogName() {
        return TableNode.getCatalogName(this.connection, this.tableHandle);
    }

    @Override
    public String getSchemaName() {
        return TableNode.getSchemaName(this.connection, this.tableHandle);
    }

    @Override
    public void destroy() {
        DatabaseConnector databaseConnector = this.connection.getConnector();
        Specification specification = databaseConnector.getDatabaseSpecification();
        try {
            AbstractCommand abstractCommand = specification.createCommandDropTable(this.getName());
            String string = this.getSchemaName();
            String string2 = this.getCatalogName();
            if (string == null) {
                string = string2;
            }
            abstractCommand.setObjectOwner(string);
            abstractCommand.execute();
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
        ((RefreshAction)SystemAction.get(RefreshAction.class)).performAction(new Node[]{this.getParentNode()});
    }

    @Override
    public boolean canDestroy() {
        DatabaseConnector databaseConnector = this.connection.getConnector();
        return databaseConnector.supportsCommand("DropTableCommand");
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public String getIconBase() {
        return ICONBASE;
    }

    public String getShortDescription() {
        return NbBundle.getMessage(TableNode.class, (String)"ND_Table");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(TableNode.class);
    }

    @Override
    public boolean canCopy() {
        return true;
    }

    public Transferable clipboardCopy() throws IOException {
        ExTransferable exTransferable = ExTransferable.create((Transferable)super.clipboardCopy());
        exTransferable.put(new ExTransferable.Single(DatabaseMetaDataTransfer.TABLE_FLAVOR){

            protected Object getData() {
                return DatabaseMetaDataTransferAccessor.DEFAULT.createTableData(TableNode.this.connection.getDatabaseConnection(), TableNode.this.connection.findJDBCDriver(), TableNode.this.getName());
            }
        });
        return exTransferable;
    }

    public static String getSchemaName(DatabaseConnection databaseConnection, final MetadataElementHandle<Table> metadataElementHandle) {
        MetadataModel metadataModel = databaseConnection.getMetadataModel();
        final String[] stringArray = new String[1];
        try {
            metadataModel.runReadAction((Action)new Action<Metadata>(){

                public void run(Metadata metadata) {
                    Table table = (Table)metadataElementHandle.resolve(metadata);
                    if (table != null) {
                        stringArray[0] = table.getParent().getName();
                    }
                }
            });
        }
        catch (MetadataModelException metadataModelException) {
            Exceptions.printStackTrace((Throwable)metadataModelException);
        }
        return stringArray[0];
    }

    public static String getCatalogName(DatabaseConnection databaseConnection, final MetadataElementHandle<Table> metadataElementHandle) {
        MetadataModel metadataModel = databaseConnection.getMetadataModel();
        final String[] stringArray = new String[1];
        try {
            metadataModel.runReadAction((Action)new Action<Metadata>(){

                public void run(Metadata metadata) {
                    Table table = (Table)metadataElementHandle.resolve(metadata);
                    if (table != null) {
                        stringArray[0] = table.getParent().getParent().getName();
                    }
                }
            });
        }
        catch (MetadataModelException metadataModelException) {
            Exceptions.printStackTrace((Throwable)metadataModelException);
        }
        return stringArray[0];
    }
}

