/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.multiview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.j2ee.ddloaders.multiview.InnerTableModel;
import org.netbeans.modules.j2ee.ddloaders.multiview.Utils;
import org.netbeans.modules.xml.multiview.ui.DefaultTablePanel;
import org.netbeans.modules.xml.multiview.ui.SectionNodeInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionNodeView;
import org.openide.util.NbBundle;

public class InnerTablePanel
extends SectionNodeInnerPanel {
    private final TablePanel tablePanel;
    private JTable table;

    protected void setButtonListeners(final InnerTableModel innerTableModel) {
        final JTable jTable = this.getTable();
        this.getAddButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InnerTablePanel.this.stopCellEditing(jTable);
                InnerTablePanel.this.selectCell(innerTableModel.addRow(), 0);
                innerTableModel.modelUpdatedFromUI();
                org.netbeans.modules.xml.multiview.Utils.scrollToVisible((JComponent)((Object)InnerTablePanel.this.tablePanel));
            }
        });
        this.getEditButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InnerTablePanel.this.editCell(jTable.getSelectedRow(), jTable.getSelectedColumn());
            }
        });
        this.getRemoveButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                int n2 = jTable.getSelectedRow();
                TableCellEditor tableCellEditor = jTable.getCellEditor(n2, n = jTable.getSelectedColumn());
                if (tableCellEditor != null) {
                    tableCellEditor.cancelCellEditing();
                }
                int n3 = innerTableModel.getRowCount() - 1;
                innerTableModel.removeRow(n2);
                innerTableModel.modelUpdatedFromUI();
                if (n2 >= n3) {
                    n2 = n3 - 1;
                }
                if (n2 >= 0) {
                    final int n4 = n2;
                    Utils.runInAwtDispatchThread(new Runnable(){

                        public void run() {
                            InnerTablePanel.this.selectCell(n4, n);
                        }
                    });
                }
            }
        });
    }

    private void stopCellEditing(JTable jTable) {
        jTable.editCellAt(-1, -1);
    }

    public InnerTablePanel(SectionNodeView sectionNodeView, InnerTableModel innerTableModel) {
        super(sectionNodeView);
        this.tablePanel = new TablePanel(innerTableModel);
        innerTableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                int n = tableModelEvent.getType();
                if (n == 1 || n == -1) {
                    InnerTablePanel.this.scheduleRefreshView();
                }
            }
        });
        this.table = this.tablePanel.getTable();
        this.table.setSelectionMode(0);
        this.table.setRowSelectionAllowed(true);
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    InnerTablePanel.this.editCell(InnerTablePanel.this.table.getSelectedRow(), InnerTablePanel.this.table.getSelectedColumn());
                }
            }
        });
        InputMap inputMap = this.table.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "selectNextColumnCell");
        inputMap.put(KeyStroke.getKeyStroke("shift ENTER"), "selectPreviousColumnCell");
        this.table.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InnerTablePanel.class, (String)"ACSN_Table"));
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InnerTablePanel.class, (String)"ACSD_Table"));
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.tablePanel), "West");
        this.setColumnWidths();
        this.setButtonListeners(innerTableModel);
        this.setColumnEditors(innerTableModel);
        this.scheduleRefreshView();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableCellEditor tableCellEditor = innerTableModel.getTableCellEditor(i);
            if (tableCellEditor == null) continue;
            tableColumnModel.getColumn(i).setCellEditor(tableCellEditor);
        }
    }

    private void setColumnEditors(InnerTableModel innerTableModel) {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            TableCellEditor tableCellEditor = innerTableModel.getCellEditor(i);
            if (tableCellEditor == null) continue;
            tableColumnModel.getColumn(i).setCellEditor(tableCellEditor);
        }
    }

    public JTable getTable() {
        return this.table;
    }

    public JButton getAddButton() {
        return this.tablePanel.getAddButton();
    }

    public JButton getEditButton() {
        return this.tablePanel.getEditButton();
    }

    public JButton getRemoveButton() {
        return this.tablePanel.getRemoveButton();
    }

    public void setColumnWidths() {
        JTable jTable = this.tablePanel.getTable();
        InnerTableModel innerTableModel = (InnerTableModel)jTable.getModel();
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            int n2 = innerTableModel.getDefaultColumnWidth(i);
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            tableColumn.setPreferredWidth(n2);
            tableColumn.setWidth(n2);
        }
    }

    protected void editCell(final int n, final int n2) {
        if (this.table.isCellEditable(n, n2)) {
            this.selectCell(n, n2);
            Utils.runInAwtDispatchThread(new Runnable(){

                public void run() {
                    JTable jTable = InnerTablePanel.this.getTable();
                    jTable.editCellAt(n, n2);
                    Component component = jTable.getEditorComponent();
                    component.requestFocus();
                }
            });
        }
    }

    private void selectCell(final int n, final int n2) {
        Utils.runInAwtDispatchThread(new Runnable(){

            public void run() {
                JTable jTable = InnerTablePanel.this.getTable();
                jTable.getSelectionModel().setLeadSelectionIndex(n);
                jTable.getColumnModel().getSelectionModel().setLeadSelectionIndex(n2);
                jTable.requestFocus();
            }
        });
    }

    public JComponent getErrorComponent(String string) {
        return null;
    }

    public void setValue(JComponent jComponent, Object object) {
    }

    public void dataModelPropertyChange(Object object, String string, Object object2, Object object3) {
        ((InnerTableModel)this.getTable().getModel()).tableChanged();
        this.scheduleRefreshView();
    }

    public void linkButtonPressed(Object object, String string) {
    }

    private class TablePanel
    extends DefaultTablePanel {
        public TablePanel(AbstractTableModel abstractTableModel) {
            super(abstractTableModel);
            final JTable jTable = this.getTable();
            jTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    int n = jTable.getSelectedRowCount();
                    TablePanel.this.removeButton.setEnabled(n > 0);
                    TablePanel.this.editButton.setEnabled(n == 1);
                }
            });
        }

        public JButton getAddButton() {
            return this.addButton;
        }

        public JButton getEditButton() {
            return this.editButton;
        }

        public JButton getRemoveButton() {
            return this.removeButton;
        }
    }
}

