/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.web.ErrorPage;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.BrowseFolders;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.DDUtils;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.ErrorPagesTableModel;
import org.netbeans.modules.xml.multiview.ui.DefaultTablePanel;
import org.netbeans.modules.xml.multiview.ui.EditDialog;
import org.netbeans.modules.xml.multiview.ui.SimpleDialogPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class ErrorPagesTablePanel
extends DefaultTablePanel {
    private static final Logger LOG = Logger.getLogger(ErrorPagesTablePanel.class.getName());
    private ErrorPagesTableModel model;
    private WebApp webApp;
    private DDDataObject dObj;

    public ErrorPagesTablePanel(final DDDataObject dDDataObject, final ErrorPagesTableModel errorPagesTableModel) {
        super((AbstractTableModel)errorPagesTableModel);
        this.model = errorPagesTableModel;
        this.dObj = dDDataObject;
        this.webApp = dDDataObject.getWebApp();
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                dDDataObject.modelUpdatedFromUI();
                dDDataObject.setChangedFromUI(true);
                int n = ErrorPagesTablePanel.this.getTable().getSelectedRow();
                errorPagesTableModel.removeRow(n);
                dDDataObject.setChangedFromUI(false);
            }
        });
        this.addButton.addActionListener(new TableActionListener(true));
        this.editButton.addActionListener(new TableActionListener(false));
    }

    void setModel(WebApp webApp, ErrorPage[] errorPageArray) {
        this.model.setData((CommonDDBean)webApp, (CommonDDBean[])errorPageArray);
        this.webApp = webApp;
    }

    private class TableActionListener
    implements ActionListener {
        private boolean add;

        TableActionListener(boolean bl) {
            this.add = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            Integer n;
            int n2 = this.add ? -1 : ErrorPagesTablePanel.this.getTable().getSelectedRow();
            String[] stringArray = new String[]{NbBundle.getMessage(ErrorPagesTablePanel.class, (String)"LBL_errorPage"), NbBundle.getMessage(ErrorPagesTablePanel.class, (String)"LBL_errorCode"), NbBundle.getMessage(ErrorPagesTablePanel.class, (String)"LBL_exceptionType")};
            String[] stringArray2 = new String[]{NbBundle.getMessage(ErrorPagesTablePanel.class, (String)"ACSD_errorPage"), NbBundle.getMessage(ErrorPagesTablePanel.class, (String)"ACSD_errorCode"), NbBundle.getMessage(ErrorPagesTablePanel.class, (String)"ACSD_exceptionType")};
            SimpleDialogPanel.DialogDescriptor dialogDescriptor = new SimpleDialogPanel.DialogDescriptor(stringArray, true);
            if (!this.add) {
                n = (Integer)ErrorPagesTablePanel.this.model.getValueAt(n2, 1);
                object = new String[]{(String)ErrorPagesTablePanel.this.model.getValueAt(n2, 0), n == null ? "" : n.toString(), (String)ErrorPagesTablePanel.this.model.getValueAt(n2, 2)};
                dialogDescriptor.setInitValues(object);
            }
            dialogDescriptor.setButtons(new boolean[]{true, false, false});
            dialogDescriptor.setA11yDesc(stringArray2);
            n = new SimpleDialogPanel(dialogDescriptor);
            if (this.add) {
                n.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ErrorPagesTablePanel.class, (String)"ACSD_add_err_page"));
                n.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ErrorPagesTablePanel.class, (String)"ACSD_add_err_page"));
            } else {
                n.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ErrorPagesTablePanel.class, (String)"ACSD_edit_err_page"));
                n.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ErrorPagesTablePanel.class, (String)"ACSD_edit_err_page"));
            }
            n.getTextComponents()[0].setEditable(false);
            n.getCustomizerButtons()[0].addActionListener(new ActionListener((SimpleDialogPanel)n){
                final /* synthetic */ SimpleDialogPanel val$dialogPanel;
                {
                    this.val$dialogPanel = simpleDialogPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        SourceGroup[] sourceGroupArray = DDUtils.getDocBaseGroups(ErrorPagesTablePanel.this.dObj);
                        FileObject fileObject = BrowseFolders.showDialog(sourceGroupArray);
                        if (fileObject != null) {
                            String string = DDUtils.getResourcePath(sourceGroupArray, fileObject, '/', true);
                            this.val$dialogPanel.getTextComponents()[0].setText("/" + string);
                        }
                    }
                    catch (IOException iOException) {
                        LOG.log(Level.FINE, "ignored exception", iOException);
                    }
                }
            });
            object = new EditDialog((JPanel)((Object)n), NbBundle.getMessage(ErrorPagesTablePanel.class, (String)"TTL_ErrorPage"), this.add, (SimpleDialogPanel)n, n2){
                final /* synthetic */ SimpleDialogPanel val$dialogPanel;
                final /* synthetic */ int val$row;
                {
                    this.val$dialogPanel = simpleDialogPanel;
                    this.val$row = n;
                    super(jPanel, string, bl);
                }

                protected String validate() {
                    String[] stringArray = this.val$dialogPanel.getValues();
                    String string = stringArray[0].trim();
                    String string2 = stringArray[1].trim();
                    String string3 = stringArray[2].trim();
                    if (string.length() == 0) {
                        return NbBundle.getMessage(ErrorPagesTablePanel.class, (String)"TXT_EmptyErrorPageLocation");
                    }
                    if (string2.length() == 0 && string3.length() == 0) {
                        return NbBundle.getMessage(ErrorPagesTablePanel.class, (String)"TXT_EP_BothMissing");
                    }
                    if (string2.length() > 0 && string3.length() > 0) {
                        return NbBundle.getMessage(ErrorPagesTablePanel.class, (String)"TXT_EP_BothSpecified");
                    }
                    if (string2.length() > 0) {
                        Integer n = null;
                        try {
                            n = new Integer(string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            LOG.log(Level.FINE, "ignored exception", numberFormatException);
                        }
                        if (n == null) {
                            return NbBundle.getMessage(ErrorPagesTablePanel.class, (String)"TXT_EP_wrongNumber", (Object)string2);
                        }
                        ErrorPage[] errorPageArray = ErrorPagesTablePanel.this.webApp.getErrorPage();
                        boolean bl = false;
                        for (int i = 0; i < errorPageArray.length; ++i) {
                            if (this.val$row == i || !n.equals(errorPageArray[i].getErrorCode())) continue;
                            bl = true;
                            break;
                        }
                        if (bl) {
                            return NbBundle.getMessage(ErrorPagesTablePanel.class, (String)"TXT_ErrorCodeExists", (Object)n);
                        }
                    } else {
                        ErrorPage[] errorPageArray = ErrorPagesTablePanel.this.webApp.getErrorPage();
                        boolean bl = false;
                        for (int i = 0; i < errorPageArray.length; ++i) {
                            if (this.val$row == i || !string3.equals(errorPageArray[i].getExceptionType())) continue;
                            bl = true;
                            break;
                        }
                        if (bl) {
                            return NbBundle.getMessage(ErrorPagesTablePanel.class, (String)"TXT_ExcTypeExists", (Object)string3);
                        }
                    }
                    return null;
                }
            };
            if (this.add) {
                object.setValid(false);
            }
            EditDialog.DocListener docListener = new EditDialog.DocListener((EditDialog)object);
            n.getTextComponents()[0].getDocument().addDocumentListener((DocumentListener)docListener);
            n.getTextComponents()[1].getDocument().addDocumentListener((DocumentListener)docListener);
            n.getTextComponents()[2].getDocument().addDocumentListener((DocumentListener)docListener);
            Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)object);
            dialog.setVisible(true);
            n.getTextComponents()[0].getDocument().removeDocumentListener((DocumentListener)docListener);
            n.getTextComponents()[1].getDocument().removeDocumentListener((DocumentListener)docListener);
            n.getTextComponents()[2].getDocument().removeDocumentListener((DocumentListener)docListener);
            if (object.getValue().equals(EditDialog.OK_OPTION)) {
                ErrorPagesTablePanel.this.dObj.modelUpdatedFromUI();
                ErrorPagesTablePanel.this.dObj.setChangedFromUI(true);
                String[] stringArray3 = n.getValues();
                String string = stringArray3[0].trim();
                String string2 = stringArray3[1].trim();
                String string3 = stringArray3[2].trim();
                if (this.add) {
                    ErrorPagesTablePanel.this.model.addRow(new Object[]{string, string2.length() == 0 ? null : new Integer(string2), string3.length() == 0 ? null : string3});
                } else {
                    ErrorPagesTablePanel.this.model.editRow(n2, new Object[]{string, string2.length() == 0 ? null : new Integer(string2), string3.length() == 0 ? null : string3});
                }
                ErrorPagesTablePanel.this.dObj.setChangedFromUI(false);
            }
        }
    }
}

