/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.dd.api.web.Filter;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.BrowseFolders;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.DDUtils;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.FilterMappingsPanel;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.FilterPanelFactory;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.PagesMultiViewElement;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.SectionValidator;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ToolBarMultiViewElement;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.ui.ConfirmDialog;
import org.netbeans.modules.xml.multiview.ui.EditDialog;
import org.netbeans.modules.xml.multiview.ui.InnerPanelFactory;
import org.netbeans.modules.xml.multiview.ui.NodeSectionPanel;
import org.netbeans.modules.xml.multiview.ui.PanelView;
import org.netbeans.modules.xml.multiview.ui.SectionContainer;
import org.netbeans.modules.xml.multiview.ui.SectionContainerNode;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SimpleDialogPanel;
import org.netbeans.modules.xml.multiview.ui.ToolBarDesignEditor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class FiltersMultiViewElement
extends ToolBarMultiViewElement
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(FiltersMultiViewElement.class.getName());
    private SectionView view;
    private ToolBarDesignEditor comp;
    private DDDataObject dObj;
    private WebApp webApp;
    private FilterPanelFactory factory;
    private Action addAction;
    private Action removeAction;
    private boolean needInit = true;
    private int index;
    private RequestProcessor.Task repaintingTask;
    private static final String FILTER_MV_ID = "dd_multiviewFilters";
    private static final String HELP_ID_PREFIX = "dd_multiview_filters_";

    public FiltersMultiViewElement(DDDataObject dDDataObject, int n) {
        super((XmlMultiViewDataObject)dDDataObject);
        this.dObj = dDDataObject;
        this.index = n;
        this.comp = new ToolBarDesignEditor();
        this.factory = new FilterPanelFactory(this.comp, dDDataObject);
        this.addAction = new AddAction(dDDataObject, NbBundle.getMessage(FiltersMultiViewElement.class, (String)"LBL_addFilter"));
        this.removeAction = new RemoveAction(NbBundle.getMessage(FiltersMultiViewElement.class, (String)"LBL_remove"));
        this.setVisualEditor(this.comp);
        this.repaintingTask = RequestProcessor.getDefault().create(new Runnable(){

            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        FiltersMultiViewElement.this.repaintView();
                    }
                });
            }
        });
    }

    public SectionView getSectionView() {
        return this.view;
    }

    public void componentShowing() {
        super.componentShowing();
        this.dObj.setLastOpenView(this.index);
        if (this.needInit || !this.dObj.isDocumentParseable()) {
            this.repaintView();
            this.needInit = false;
        }
    }

    private void repaintView() {
        this.webApp = this.dObj.getWebApp();
        this.view = new FiltersView(this.webApp);
        this.comp.setContentView((PanelView)this.view);
        Object object = this.comp.getLastActive();
        if (object != null) {
            this.view.openPanel(object);
        } else {
            FiltersView filtersView = (FiltersView)this.view;
            Node node = filtersView.getFiltersNode();
            Children children = node.getChildren();
            if (children.getNodesCount() > 0) {
                node = children.getNodes()[0];
            }
            filtersView.selectNode(node);
        }
        this.view.checkValidity();
        this.dObj.checkParseable();
    }

    public void componentOpened() {
        super.componentOpened();
        this.dObj.getWebApp().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void componentClosed() {
        super.componentClosed();
        this.dObj.getWebApp().removePropertyChangeListener((PropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        if (!this.dObj.isChangedFromUI() && (string = propertyChangeEvent.getPropertyName()).indexOf("Filter") > 0) {
            if (FILTER_MV_ID.equals(this.dObj.getSelectedPerspective().preferredID())) {
                this.repaintingTask.schedule(100);
            } else {
                this.needInit = true;
            }
        }
    }

    private class RemoveAction
    extends AbstractAction {
        RemoveAction(String string) {
            super(string);
            char c = NbBundle.getMessage(FiltersMultiViewElement.class, (String)"LBL_remove_mnem").charAt(0);
            this.putValue("MnemonicKey", new Integer(c));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            ConfirmDialog confirmDialog = new ConfirmDialog(NbBundle.getMessage(FiltersMultiViewElement.class, (String)"TXT_removeFilterConfirm"));
            Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)confirmDialog);
            dialog.setVisible(true);
            if (DialogDescriptor.OK_OPTION.equals(confirmDialog.getValue())) {
                SectionPanel sectionPanel = ((SectionPanel.HeaderButton)actionEvent.getSource()).getSectionPanel();
                Filter filter = (Filter)sectionPanel.getKey();
                FiltersMultiViewElement.this.dObj.modelUpdatedFromUI();
                FiltersMultiViewElement.this.dObj.setChangedFromUI(true);
                try {
                    Stack stack = DDUtils.removeFilterMappings(FiltersMultiViewElement.this.webApp, filter.getFilterName());
                    FiltersMultiViewElement.this.webApp.removeFilter(filter);
                    sectionPanel.getSectionView().removeSection(sectionPanel.getNode());
                    SectionInnerPanel sectionInnerPanel = ((FiltersView)sectionPanel.getSectionView()).getFilterMappingSectionPanel().getInnerPanel();
                    if (sectionInnerPanel != null) {
                        while (!stack.empty()) {
                            ((FilterMappingsPanel)sectionInnerPanel).removeRow((Integer)stack.pop());
                        }
                    }
                }
                finally {
                    FiltersMultiViewElement.this.dObj.setChangedFromUI(false);
                }
            }
        }
    }

    private class AddAction
    extends AbstractAction {
        AddAction(DDDataObject dDDataObject, String string) {
            super(string);
            char c = NbBundle.getMessage(FiltersMultiViewElement.class, (String)"LBL_addFilter_mnem").charAt(0);
            this.putValue("MnemonicKey", new Integer(c));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            String[] stringArray = new String[]{NbBundle.getMessage(FiltersMultiViewElement.class, (String)"LBL_filterName"), NbBundle.getMessage(FiltersMultiViewElement.class, (String)"LBL_filterClass"), NbBundle.getMessage(FiltersMultiViewElement.class, (String)"LBL_description")};
            String[] stringArray2 = new String[]{NbBundle.getMessage(FiltersMultiViewElement.class, (String)"ACSD_filterName"), NbBundle.getMessage(FiltersMultiViewElement.class, (String)"ACSD_filterClass"), NbBundle.getMessage(FiltersMultiViewElement.class, (String)"ACSD_filterDescription")};
            boolean[] blArray = new boolean[]{false, true, false};
            SimpleDialogPanel.DialogDescriptor dialogDescriptor = new SimpleDialogPanel.DialogDescriptor(stringArray, true);
            dialogDescriptor.setButtons(blArray);
            dialogDescriptor.setA11yDesc(stringArray2);
            dialogDescriptor.setTextField(new boolean[]{true, true, false});
            final SimpleDialogPanel simpleDialogPanel = new SimpleDialogPanel(dialogDescriptor);
            simpleDialogPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FiltersMultiViewElement.class, (String)"ACSD_add_filter"));
            simpleDialogPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FiltersMultiViewElement.class, (String)"ACSD_add_err_page"));
            simpleDialogPanel.getCustomizerButtons()[0].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        SourceGroup[] sourceGroupArray = DDUtils.getJavaSourceGroups(FiltersMultiViewElement.this.dObj);
                        FileObject fileObject = BrowseFolders.showDialog(sourceGroupArray);
                        if (fileObject != null) {
                            String string = DDUtils.getResourcePath(sourceGroupArray, fileObject);
                            simpleDialogPanel.getTextComponents()[1].setText(string);
                        }
                    }
                    catch (IOException iOException) {
                        LOG.log(Level.FINE, "ignored exception", iOException);
                    }
                }
            });
            EditDialog editDialog = new EditDialog((JPanel)simpleDialogPanel, NbBundle.getMessage(FiltersMultiViewElement.class, (String)"TTL_Filter"), true){

                protected String validate() {
                    String[] stringArray = simpleDialogPanel.getValues();
                    String string = stringArray[0].trim();
                    String string2 = stringArray[1].trim();
                    return SectionValidator.validateNewFilter(FiltersMultiViewElement.this.dObj.getWebApp(), string, string2);
                }
            };
            editDialog.setValid(false);
            EditDialog.DocListener docListener = new EditDialog.DocListener(editDialog);
            simpleDialogPanel.getTextComponents()[0].getDocument().addDocumentListener((DocumentListener)docListener);
            simpleDialogPanel.getTextComponents()[1].getDocument().addDocumentListener((DocumentListener)docListener);
            Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)editDialog);
            dialog.setVisible(true);
            simpleDialogPanel.getTextComponents()[0].getDocument().removeDocumentListener((DocumentListener)docListener);
            simpleDialogPanel.getTextComponents()[1].getDocument().removeDocumentListener((DocumentListener)docListener);
            if (editDialog.getValue().equals(EditDialog.OK_OPTION)) {
                FiltersMultiViewElement.this.dObj.modelUpdatedFromUI();
                FiltersMultiViewElement.this.dObj.setChangedFromUI(true);
                String[] stringArray3 = simpleDialogPanel.getValues();
                try {
                    Filter filter = (Filter)FiltersMultiViewElement.this.webApp.createBean("Filter");
                    filter.setFilterName(stringArray3[0]);
                    filter.setFilterClass(stringArray3[1]);
                    String string = stringArray3[2];
                    if (string.length() > 0) {
                        filter.setDescription(string);
                    }
                    FiltersMultiViewElement.this.webApp.addFilter(filter);
                    FiltersView filtersView = (FiltersView)FiltersMultiViewElement.this.comp.getContentView();
                    FilterNode filterNode = new FilterNode(filtersView, FiltersMultiViewElement.this.webApp, filter);
                    filtersView.getFiltersNode().getChildren().add(new Node[]{filterNode});
                    SectionPanel sectionPanel = new SectionPanel((SectionView)filtersView, (Node)filterNode, filtersView.getFilterTitle(filter), (Object)filter);
                    sectionPanel.setHeaderActions(new Action[]{FiltersMultiViewElement.this.removeAction});
                    filtersView.getFiltersContainer().addSection((NodeSectionPanel)sectionPanel, true);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    LOG.log(Level.FINE, "ignored exception", classNotFoundException);
                }
                finally {
                    FiltersMultiViewElement.this.dObj.setChangedFromUI(false);
                }
            }
        }
    }

    private class FilterNode
    extends AbstractNode {
        FilterNode(SectionView sectionView, WebApp webApp, Filter filter) {
            super(Children.LEAF);
            this.setDisplayName(filter.getFilterName());
            this.setIconBaseWithExtension("org/netbeans/modules/j2ee/ddloaders/web/multiview/resources/class.gif");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("dd_multiview_filters_filterNode");
        }
    }

    private class FilterMappingsNode
    extends AbstractNode {
        FilterMappingsNode() {
            super(Children.LEAF);
            this.setDisplayName(NbBundle.getMessage(PagesMultiViewElement.class, (String)"TTL_FilterMappings"));
            this.setIconBaseWithExtension("org/netbeans/modules/j2ee/ddloaders/web/multiview/resources/mappingsNode.gif");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("dd_multiview_filters_filterMappingsNode");
        }
    }

    class FiltersView
    extends SectionView {
        private SectionContainer filtersCont;
        private Node filtersNode;
        private Node filterMappingsNode;
        private SectionPanel filterMappingSectionPanel;

        FiltersView(WebApp webApp) {
            super((InnerPanelFactory)FiltersMultiViewElement.this.factory);
            Filter[] filterArray = webApp.getFilter();
            Node[] nodeArray = new Node[filterArray.length];
            Children.Array array = new Children.Array();
            for (int i = 0; i < nodeArray.length; ++i) {
                nodeArray[i] = new FilterNode(this, webApp, filterArray[i]);
            }
            array.add(nodeArray);
            this.filtersNode = new SectionContainerNode((Children)array);
            this.filtersNode.setDisplayName(NbBundle.getMessage(FiltersMultiViewElement.class, (String)"TTL_filters"));
            this.filtersNode.setName("dd_multiview_filters_filtersNode");
            this.filtersCont = new SectionContainer((SectionView)this, this.filtersNode, NbBundle.getMessage(FiltersMultiViewElement.class, (String)"TTL_filters"));
            this.filtersCont.setHeaderActions(new Action[]{FiltersMultiViewElement.this.addAction});
            Children.Array array2 = new Children.Array();
            SectionPanel[] sectionPanelArray = new SectionPanel[filterArray.length];
            for (int i = 0; i < nodeArray.length; ++i) {
                sectionPanelArray[i] = new SectionPanel((SectionView)this, nodeArray[i], this.getFilterTitle(filterArray[i]), (Object)filterArray[i]);
                sectionPanelArray[i].setHeaderActions(new Action[]{FiltersMultiViewElement.this.removeAction});
                this.filtersCont.addSection((NodeSectionPanel)sectionPanelArray[i]);
            }
            this.addSection((NodeSectionPanel)this.filtersCont);
            this.filterMappingsNode = new FilterMappingsNode();
            this.filterMappingSectionPanel = new SectionPanel((SectionView)this, this.filterMappingsNode, (Object)"filter_mappings");
            this.addSection((NodeSectionPanel)this.filterMappingSectionPanel);
            array2.add(new Node[]{this.filtersNode, this.filterMappingsNode});
            AbstractNode abstractNode = new AbstractNode((Children)array2);
            this.setRoot((Node)abstractNode);
        }

        Node getFiltersNode() {
            return this.filtersNode;
        }

        SectionContainer getFiltersContainer() {
            return this.filtersCont;
        }

        SectionPanel getFilterMappingSectionPanel() {
            return this.filterMappingSectionPanel;
        }

        String getFilterTitle(Filter filter) {
            String string = filter.getFilterName();
            if (string == null) {
                string = "";
            }
            String string2 = DDUtils.urlPatternList(DDUtils.getUrlPatterns(FiltersMultiViewElement.this.webApp, filter));
            return NbBundle.getMessage(FiltersMultiViewElement.class, (String)"TTL_filterPanel", (Object)string, (Object)string2);
        }

        public Error validateView() {
            return SectionValidator.validateFilters(FiltersMultiViewElement.this.webApp);
        }
    }
}

