/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.classfile;

import java.io.IOException;
import java.lang.reflect.Modifier;
import org.netbeans.lib.profiler.classfile.BaseClassInfo;
import org.netbeans.lib.profiler.classfile.ClassFileParser;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.instrumentation.JavaClassConstants;

public abstract class ClassInfo
extends BaseClassInfo
implements JavaClassConstants,
CommonConstants {
    String packageName;
    String superName;
    char[] cpoolRefsToClassIdx;
    String[] cpoolRefsToClassName;
    String[][] cpoolRefsToMethodClassNameAndSig;
    char[] cpoolRefsToMethodIdx;
    int[] exceptionTableStartOffsets;
    String[] interfaces;
    char[] lineNumberTablesLengths;
    int[] lineNumberTablesOffsets;
    char[] methodAccessFlags;
    char[] methodBytecodesLengths;
    int[] methodBytecodesOffsets;
    int[] methodInfoLengths;
    int[] methodInfoOffsets;
    String[] methodNames;
    String[] methodSignatures;
    String[] nestedClassNames;
    char accessFlags;
    int attrsStartOfs;
    int cpoolStartOfs;
    int fieldsStartOfs;
    int intermediateDataStartOfs;
    int methodsStartOfs;
    int origCPoolCount;
    short lineNumberTablesInitStatus;
    private LineNumberTables lineNumberTables;

    protected ClassInfo(String string, int n) {
        super(string, n);
        this.packageName = ClassInfo.getPackageName(this.name);
    }

    ClassInfo(byte[] byArray) throws ClassFormatError {
        super("", 0);
        try {
            new ClassFileParser().parseClassFile(byArray, this);
        }
        catch (ClassFileParser.ClassFileReadException classFileReadException) {
            throw new ClassFormatError(classFileReadException.getMessage());
        }
        this.packageName = ClassInfo.getPackageName(this.name);
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.accessFlags);
    }

    public int getExceptionTableStartOffsetInMethodInfo(int n) {
        return this.exceptionTableStartOffsets[n];
    }

    public boolean isInterface() {
        return Modifier.isInterface(this.accessFlags);
    }

    public String[] getInterfaceNames() {
        return this.interfaces;
    }

    public LineNumberTables getLineNumberTables() {
        if (this.lineNumberTables == null) {
            this.initLineNumberTables();
        }
        return this.lineNumberTables;
    }

    public boolean isMethodAbstract(int n) {
        return Modifier.isAbstract(this.methodAccessFlags[n]);
    }

    public byte[] getMethodBytecode(int n) {
        try {
            byte[] byArray = this.getClassFileBytes();
            byte[] byArray2 = new byte[this.methodBytecodesLengths[n]];
            System.arraycopy(byArray, this.methodInfoOffsets[n] + this.methodBytecodesOffsets[n], byArray2, 0, this.methodBytecodesLengths[n]);
            return byArray2;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public int getMethodBytecodeOffsetInMethodInfo(int n) {
        return this.methodBytecodesOffsets[n];
    }

    public int getMethodBytecodesLength(int n) {
        return this.methodBytecodesLengths[n];
    }

    public boolean isMethodFinal(int n) {
        return Modifier.isFinal(this.methodAccessFlags[n]);
    }

    public int getMethodIndex(String string, String string2) {
        for (int i = 0; i < this.methodNames.length; ++i) {
            if (this.methodNames[i] != string || this.methodSignatures[i] != string2) continue;
            return i;
        }
        return -1;
    }

    public byte[] getMethodInfo(int n) {
        try {
            byte[] byArray = this.getClassFileBytes();
            byte[] byArray2 = new byte[this.methodInfoLengths[n]];
            System.arraycopy(byArray, this.methodInfoOffsets[n], byArray2, 0, this.methodInfoLengths[n]);
            return byArray2;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public int getMethodInfoLength(int n) {
        return this.methodInfoLengths[n];
    }

    public String getMethodName(int n) {
        return this.methodNames[n];
    }

    public String[] getMethodNames() {
        return this.methodNames;
    }

    public boolean isMethodNative(int n) {
        return Modifier.isNative(this.methodAccessFlags[n]);
    }

    public boolean isMethodPrivate(int n) {
        return Modifier.isPrivate(this.methodAccessFlags[n]);
    }

    public boolean isMethodProtected(int n) {
        return Modifier.isProtected(this.methodAccessFlags[n]);
    }

    public boolean isMethodPublic(int n) {
        return Modifier.isPublic(this.methodAccessFlags[n]);
    }

    public String getMethodSignature(int n) {
        return this.methodSignatures[n];
    }

    public String[] getMethodSignatures() {
        return this.methodSignatures;
    }

    public boolean isMethodStatic(int n) {
        return Modifier.isStatic(this.methodAccessFlags[n]);
    }

    public int[] getMinAndMaxLinesForMethod(int n) {
        if (this.lineNumberTables == null) {
            this.initLineNumberTables();
        }
        return this.lineNumberTables.getMinAndMaxLinesForMethod(n);
    }

    public String[] getNestedClassNames() {
        return this.nestedClassNames;
    }

    public int getOrigAttrsStartOfs() {
        return this.attrsStartOfs;
    }

    public int getOrigCPoolCount() {
        return this.origCPoolCount;
    }

    public int getOrigCPoolStartOfs() {
        return this.cpoolStartOfs;
    }

    public int getOrigFieldsStartOfs() {
        return this.fieldsStartOfs;
    }

    public int getOrigIntermediateDataStartOfs() {
        return this.intermediateDataStartOfs;
    }

    public int getOrigMethodsStartOfs() {
        return this.methodsStartOfs;
    }

    public String getRefClassName(int n) {
        for (int i = 0; i < this.cpoolRefsToClassIdx.length; ++i) {
            if (this.cpoolRefsToClassIdx[i] != n) continue;
            return this.cpoolRefsToClassName[i];
        }
        return null;
    }

    public String[] getRefMethodsClassNameAndSig(int n) {
        for (int i = 0; i < this.cpoolRefsToMethodIdx.length; ++i) {
            if (this.cpoolRefsToMethodIdx[i] != n) continue;
            return this.cpoolRefsToMethodClassNameAndSig[i];
        }
        return null;
    }

    public String getSuperclassName() {
        return this.superName;
    }

    public int bciForMethodAndLineNo(int n, int n2) {
        if (this.lineNumberTables == null) {
            this.initLineNumberTables();
        }
        return this.lineNumberTables.bciForLineNo(n, n2);
    }

    public int checkIfAtGoTo(int n, int n2) {
        byte[] byArray = this.getMethodBytecode(n);
        int n3 = byArray[n2] & 0xFF;
        if (n3 != 167 && n3 != 200) {
            return n2;
        }
        return ClassInfo.findPreviousBCI(byArray, n2);
    }

    public boolean containsMethod(String string, String string2) {
        return this.getMethodIndex(string, string2) != -1;
    }

    public static int findPreviousBCI(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = 0;
        block4: while (n3 < n) {
            n2 = n3;
            int n4 = byArray[n3] & 0xFF;
            if (n4 == 196) {
                n4 = byArray[n3 + 1] & 0xFF;
                if (n4 >= 21 && n4 <= 25 || n4 >= 54 && n4 <= 58 || n4 == 169) {
                    n3 += 4;
                    continue;
                }
                if (n4 == 132) {
                    n3 += 6;
                    continue;
                }
                ++n3;
                continue;
            }
            switch (n4) {
                case 170: {
                    int n5 = n3 + 1 + 3 & 0xFFFFFFFC;
                    long l = ClassInfo.intAt(byArray, n5, 0);
                    long l2 = ClassInfo.intAt(byArray, n5, 1);
                    long l3 = ClassInfo.intAt(byArray, n5, 2);
                    n3 = (n5 += 12) + (int)(l3 - l2 + 1L << 2);
                    continue block4;
                }
                case 171: {
                    int n5 = n3 + 1 + 3 & 0xFFFFFFFC;
                    long l = ClassInfo.intAt(byArray, n5, 0);
                    int n6 = (int)ClassInfo.intAt(byArray, n5, 1);
                    int n7 = n6 * 2;
                    n3 = (n5 += 8) + (n7 << 2);
                    continue block4;
                }
            }
            n3 += opc_length[n4];
        }
        return n2;
    }

    public int lineNoForMethodAndBci(int n, int n2) {
        if (this.lineNumberTables == null) {
            this.initLineNumberTables();
        }
        return this.lineNumberTables.lineNoForBci(n, n2);
    }

    public int[] methodIdxAndBestBCIForLineNo(int n) {
        int n2;
        int n3;
        if (this.lineNumberTablesInitStatus == 0) {
            this.initLineNumberTables();
        }
        if (this.lineNumberTablesInitStatus == -1) {
            return new int[]{-2, -2};
        }
        int n4 = this.methodNames.length;
        for (n3 = 0; n3 < n4; ++n3) {
            if (this.methodNames[n3] == "<init>" || this.methodNames[n3] == "<clinit>" || (n2 = this.lineNumberTables.bciForLineNo(n3, n)) == -1) continue;
            return new int[]{n3, n2};
        }
        for (n3 = 0; n3 < n4; ++n3) {
            if (this.methodNames[n3] != "<init>" && this.methodNames[n3] != "<clinit>" || (n2 = this.lineNumberTables.bciForLineNo(n3, n)) == -1) continue;
            return new int[]{n3, n2};
        }
        return new int[]{-1, -1};
    }

    public int overridesVirtualMethod(ClassInfo classInfo, int n) {
        int n2 = this.getMethodIndex(classInfo.methodNames[n], classInfo.methodSignatures[n]);
        if (n2 == -1) {
            return -1;
        }
        if (classInfo.isMethodPublic(n) || classInfo.isMethodProtected(n)) {
            return n2;
        }
        if (classInfo.packageName == this.packageName) {
            return n2;
        }
        return -1;
    }

    protected abstract byte[] getClassFileBytes() throws IOException, ClassNotFoundException;

    protected static String getPackageName(String string) {
        int n = string.lastIndexOf(47);
        if (n == -1) {
            return "";
        }
        return string.substring(0, n).intern();
    }

    private static final long intAt(byte[] byArray, int n, int n2) {
        int n3 = n + (n2 << 2);
        return byArray[n3] << 24 | (byArray[n3 + 1] & 0xFF) << 16 | (byArray[n3 + 2] & 0xFF) << 8 | byArray[n3 + 3] & 0xFF;
    }

    private void initLineNumberTables() {
        byte[] byArray = null;
        try {
            byArray = this.getClassFileBytes();
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        int n = this.methodNames.length;
        char[][] cArrayArray = new char[n][];
        char[][] cArrayArray2 = new char[n][];
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            int n2 = this.methodInfoOffsets[i] + this.lineNumberTablesOffsets[i];
            if (n2 == -1) continue;
            bl = true;
            int n3 = this.lineNumberTablesLengths[i];
            cArrayArray[i] = new char[n3];
            char[] cArray = cArrayArray[i];
            cArrayArray2[i] = new char[n3];
            char[] cArray2 = cArrayArray2[i];
            for (int j = 0; j < n3; ++j) {
                cArray[j] = (char)(((byArray[n2++] & 0xFF) << 8) + (byArray[n2++] & 0xFF));
                cArray2[j] = (char)(((byArray[n2++] & 0xFF) << 8) + (byArray[n2++] & 0xFF));
            }
        }
        this.lineNumberTables = new LineNumberTables();
        this.lineNumberTables.startPCs = cArrayArray;
        this.lineNumberTables.lineNumbers = cArrayArray2;
        this.lineNumberTablesInitStatus = bl ? (short)1 : (short)-1;
    }

    public static class LineNumberTables {
        char[][] lineNumbers;
        char[][] startPCs;

        public char[][] getStartPCs() {
            return this.startPCs;
        }

        int[] getMinAndMaxLinesForMethod(int n) {
            int[] nArray = new int[2];
            if (this.startPCs[n] == null) {
                nArray[1] = -1;
                nArray[0] = -1;
                return nArray;
            }
            nArray[0] = 10000000;
            nArray[1] = -10000000;
            char[] cArray = this.lineNumbers[n];
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] < nArray[0]) {
                    nArray[0] = cArray[i];
                }
                if (cArray[i] <= nArray[1]) continue;
                nArray[1] = cArray[i];
            }
            return nArray;
        }

        int bciForLineNo(int n, int n2) {
            char c;
            char[] cArray = this.startPCs[n];
            if (cArray == null) {
                return -1;
            }
            int n3 = cArray.length;
            char[] cArray2 = this.lineNumbers[n];
            int n4 = 100000000;
            int n5 = 100000000;
            int n6 = 0;
            int n7 = -1;
            int c2 = 100000000;
            for (int i = 0; i < n3; ++i) {
                char c3;
                n7 = cArray2[i];
                if (n7 > n6) {
                    n6 = n7;
                }
                if (n7 < n4) {
                    n4 = n7;
                }
                if (n7 == n2) {
                    c = cArray[i];
                    break;
                }
                if (n7 <= n2 || n7 > n5 || cArray[i] >= c3) continue;
                c3 = cArray[i];
                n5 = n7;
            }
            if (n7 == n2 || n2 >= n4 && n2 <= n6) {
                return c;
            }
            return -1;
        }

        int lineNoForBci(int n, int n2) {
            char[] cArray = this.startPCs[n];
            if (cArray == null) {
                return -1;
            }
            int n3 = cArray.length;
            char[] cArray2 = this.lineNumbers[n];
            int n4 = -1;
            for (int i = 0; i < n3 && cArray[i] <= n2; ++i) {
                n4 = cArray2[i];
            }
            return n4;
        }
    }
}

