/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.netbeans.lib.profiler.heap.HprofByteBuffer;

class HprofMappedByteBuffer
extends HprofByteBuffer {
    private MappedByteBuffer dumpBuffer;

    HprofMappedByteBuffer(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        FileChannel fileChannel = fileInputStream.getChannel();
        this.length = fileChannel.size();
        this.dumpBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, this.length);
        fileChannel.close();
        this.readHeader();
    }

    char getChar(long l) {
        return this.dumpBuffer.getChar((int)l);
    }

    double getDouble(long l) {
        return this.dumpBuffer.getDouble((int)l);
    }

    float getFloat(long l) {
        return this.dumpBuffer.getFloat((int)l);
    }

    int getInt(long l) {
        return this.dumpBuffer.getInt((int)l);
    }

    long getLong(long l) {
        return this.dumpBuffer.getLong((int)l);
    }

    short getShort(long l) {
        return this.dumpBuffer.getShort((int)l);
    }

    byte get(long l) {
        return this.dumpBuffer.get((int)l);
    }

    synchronized void get(long l, byte[] byArray) {
        this.dumpBuffer.position((int)l);
        this.dumpBuffer.get(byArray);
    }
}

