/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu.marking;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.marker.Mark;
import org.netbeans.lib.profiler.marker.Marker;
import org.netbeans.lib.profiler.results.cpu.marking.MarkMapper;
import org.netbeans.lib.profiler.results.cpu.marking.MarkMapping;

public class MarkingEngine {
    private static MarkingEngine instance;
    private final Object markGuard = new Object();
    private final MarkMapper mapper;
    private String[] labels;
    private MarkMapping[] marks;
    private Set observers = new HashSet();

    private MarkingEngine() {
        this.mapper = new MarkMapper();
    }

    public static synchronized MarkingEngine getDefault() {
        if (instance == null) {
            instance = new MarkingEngine();
        }
        return instance;
    }

    public synchronized void configure(MarkMapping[] markMappingArray, Collection collection) {
        this.setMarks(markMappingArray != null ? markMappingArray : Marker.DEFAULT.getMappings());
        this.observers.clear();
        this.observers.addAll(collection);
    }

    public synchronized void deconfigure() {
        this.setMarks(Marker.DEFAULT.getMappings());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientUtils.SourceCodeSelection[] getMarkerMethods() {
        Object object = this.markGuard;
        synchronized (object) {
            if (this.marks == null) {
                return new ClientUtils.SourceCodeSelection[0];
            }
            ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray = new ClientUtils.SourceCodeSelection[this.marks.length];
            for (int i = 0; i < this.marks.length; ++i) {
                sourceCodeSelectionArray[i] = this.marks[i].markMask;
            }
            return sourceCodeSelectionArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNMarks() {
        Object object = this.markGuard;
        synchronized (object) {
            return this.labels != null ? this.labels.length : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mark markMethod(int n, ProfilingSessionStatus profilingSessionStatus) {
        MarkMapper markMapper = this.mapper;
        synchronized (markMapper) {
            return this.mapper.getMark(n, profilingSessionStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Mark mark(int n, ProfilingSessionStatus profilingSessionStatus) {
        ClientUtils.SourceCodeSelection sourceCodeSelection = null;
        Object object = this.markGuard;
        synchronized (object) {
            if (this.marks == null || profilingSessionStatus == null) {
                return Mark.DEFAULT;
            }
            profilingSessionStatus.beginTrans(false);
            try {
                sourceCodeSelection = new ClientUtils.SourceCodeSelection(profilingSessionStatus.getInstrMethodClasses()[n], profilingSessionStatus.getInstrMethodNames()[n], profilingSessionStatus.getInstrMethodSignatures()[n]);
            }
            finally {
                profilingSessionStatus.endTrans();
            }
            String string = sourceCodeSelection.toFlattened();
            for (int i = 0; i < this.marks.length; ++i) {
                if (!string.startsWith(this.marks[i].markSig)) continue;
                return this.marks[i].mark;
            }
            return Mark.DEFAULT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMarks(MarkMapping[] markMappingArray) {
        boolean bl = false;
        Object object = this.markGuard;
        synchronized (object) {
            bl = !Arrays.equals(this.marks, markMappingArray);
            this.marks = markMappingArray;
        }
        if (bl) {
            this.fireStateChanged();
        }
    }

    private void fireStateChanged() {
        Iterator iterator = this.observers.iterator();
        while (iterator.hasNext()) {
            ((StateObserver)iterator.next()).stateChanged(this);
        }
    }

    public static interface StateObserver {
        public void stateChanged(MarkingEngine var1);
    }
}

