/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery.provider;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cnd.discovery.api.Configuration;
import org.netbeans.modules.cnd.discovery.api.Progress;
import org.netbeans.modules.cnd.discovery.api.ProjectImpl;
import org.netbeans.modules.cnd.discovery.api.ProjectProperties;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.api.ProviderProperty;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.BaseDwarfProvider;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.DwarfSource;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DwarfProvider
extends BaseDwarfProvider {
    private Map<String, ProviderProperty> myProperties = new HashMap<String, ProviderProperty>();
    public static final String EXECUTABLES_KEY = "binaries";

    public DwarfProvider() {
        this.clean();
    }

    public void clean() {
        this.myProperties.clear();
        this.myProperties.put(EXECUTABLES_KEY, new ProviderProperty(){
            private String[] myPath;

            public String getName() {
                return DwarfProvider.i18n("Binaries_Files_Name");
            }

            public String getDescription() {
                return DwarfProvider.i18n("Binaries_Files_Description");
            }

            public Object getValue() {
                return this.myPath;
            }

            public void setValue(Object object) {
                if (object instanceof String[]) {
                    this.myPath = (String[])object;
                }
            }

            public ProviderProperty.PropertyKind getKind() {
                return ProviderProperty.PropertyKind.BinaryFiles;
            }
        });
    }

    public String getID() {
        return "dwarf-binaries";
    }

    public String getName() {
        return DwarfProvider.i18n("Binaries_Provider_Name");
    }

    public String getDescription() {
        return DwarfProvider.i18n("Binaries_Provider_Description");
    }

    public List<String> getPropertyKeys() {
        return new ArrayList<String>(this.myProperties.keySet());
    }

    public ProviderProperty getProperty(String string) {
        return this.myProperties.get(string);
    }

    public List<Configuration> analyze(ProjectProxy projectProxy, Progress progress) {
        this.isStoped = false;
        ArrayList<Configuration> arrayList = new ArrayList<Configuration>();
        this.setCommpilerSettings(projectProxy);
        if (!this.isStoped) {
            Configuration configuration = new Configuration(){
                private List<SourceFileProperties> myFileProperties;
                private List<String> myIncludedFiles;

                public List<ProjectProperties> getProjectConfiguration() {
                    return ProjectImpl.divideByLanguage(this.getSourcesConfiguration());
                }

                public List<Configuration> getDependencies() {
                    return null;
                }

                public List<SourceFileProperties> getSourcesConfiguration() {
                    String[] stringArray;
                    if (this.myFileProperties == null && (stringArray = (String[])DwarfProvider.this.getProperty(DwarfProvider.EXECUTABLES_KEY).getValue()) != null) {
                        this.myFileProperties = DwarfProvider.this.getSourceFileProperties(stringArray, null);
                    }
                    return this.myFileProperties;
                }

                public List<String> getIncludedFiles() {
                    if (this.myIncludedFiles == null) {
                        HashSet<String> hashSet = new HashSet<String>();
                        for (SourceFileProperties object : this.getSourcesConfiguration()) {
                            if (DwarfProvider.this.isStoped) break;
                            hashSet.addAll(((DwarfSource)object).getIncludedFiles());
                            hashSet.add(object.getItemPath());
                        }
                        HashSet hashSet2 = new HashSet();
                        for (String string : hashSet) {
                            if (DwarfProvider.this.isStoped) break;
                            File file = new File(string);
                            if (!CndFileUtils.exists((File)file)) continue;
                            hashSet2.add(CndFileUtils.normalizeFile((File)file).getAbsolutePath());
                        }
                        this.myIncludedFiles = new ArrayList<String>(hashSet2);
                    }
                    return this.myIncludedFiles;
                }
            };
            arrayList.add(configuration);
        }
        return arrayList;
    }

    private static String i18n(String string) {
        return NbBundle.getMessage(DwarfProvider.class, (String)string);
    }
}

