/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.api.execution;

import java.net.ConnectException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.netbeans.modules.dlight.api.execution.DLightTargetChangeEvent;
import org.netbeans.modules.dlight.api.execution.DLightTargetListener;
import org.netbeans.modules.dlight.api.impl.DLightTargetAccessor;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DLightTarget {
    private final List<DLightTargetListener> listeners;
    private final Info info;
    private final DLightTargetExecutionService<DLightTarget> executionService;

    protected DLightTarget(DLightTargetExecutionService dLightTargetExecutionService) {
        this.executionService = dLightTargetExecutionService;
        this.listeners = new ArrayList<DLightTargetListener>();
        this.info = new Info();
    }

    private final DLightTargetExecutionService<DLightTarget> getExecutionService() {
        return this.executionService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addTargetListener(DLightTargetListener dLightTargetListener) {
        if (dLightTargetListener == null) {
            return;
        }
        DLightTarget dLightTarget = this;
        synchronized (dLightTarget) {
            if (!this.listeners.contains(dLightTargetListener)) {
                this.listeners.add(dLightTargetListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeTargetListener(DLightTargetListener dLightTargetListener) {
        DLightTarget dLightTarget = this;
        synchronized (dLightTarget) {
            this.listeners.remove(dLightTargetListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void notifyListeners(final DLightTargetChangeEvent dLightTargetChangeEvent) {
        DLightTargetListener[] dLightTargetListenerArray;
        Object object = this;
        synchronized (object) {
            dLightTargetListenerArray = this.listeners.toArray(new DLightTargetListener[0]);
        }
        object = new CountDownLatch(dLightTargetListenerArray.length);
        for (final DLightTargetListener dLightTargetListener : dLightTargetListenerArray) {
            DLightExecutorService.submit((Runnable)new Runnable((CountDownLatch)object){
                final /* synthetic */ CountDownLatch val$doneFlag;
                {
                    this.val$doneFlag = countDownLatch;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        dLightTargetListener.targetStateChanged(dLightTargetChangeEvent);
                    }
                    finally {
                        this.val$doneFlag.countDown();
                    }
                }
            }, (String)("Notifying " + dLightTargetListener));
        }
        try {
            ((CountDownLatch)object).await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected final String putToInfo(String string, String string2) {
        return this.info.put(string, string2);
    }

    public abstract ExecutionEnvironment getExecEnv();

    public abstract State getState();

    public abstract int getExitCode() throws InterruptedException;

    static {
        DLightTargetAccessor.setDefault(new DLightTargetAccessorImpl());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class Info {
        private Map<String, String> map = new ConcurrentHashMap<String, String>();

        Info() {
        }

        public Map<String, String> getInfo() {
            return this.map;
        }

        String put(String string, String string2) {
            return this.map.put(string, string2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DLightTargetAccessorImpl
    extends DLightTargetAccessor {
        private DLightTargetAccessorImpl() {
        }

        @Override
        public DLightTargetExecutionService<DLightTarget> getDLightTargetExecution(DLightTarget dLightTarget) {
            return dLightTarget.getExecutionService();
        }

        @Override
        public Info getDLightTargetInfo(DLightTarget dLightTarget) {
            return dLightTarget.info;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ExecutionEnvVariablesProvider {
        public Map<String, String> getExecutionEnv(DLightTarget var1) throws ConnectException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface DLightTargetExecutionService<T extends DLightTarget> {
        public void start(T var1, ExecutionEnvVariablesProvider var2);

        public void terminate(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        INIT,
        STARTING,
        RUNNING,
        DONE,
        FAILED,
        STOPPED,
        TERMINATED;

    }
}

