/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.api.jaxws.wsdlmodel;

import com.sun.tools.ws.processor.model.Model;
import com.sun.tools.ws.processor.modeler.wsdl.WSDLModeler;
import com.sun.tools.ws.wscompile.AbortException;
import com.sun.tools.ws.wscompile.BadCommandLineException;
import com.sun.tools.ws.wscompile.ErrorReceiver;
import com.sun.tools.ws.wscompile.WsimportOptions;
import com.sun.xml.stream.ZephyrParserFactory;
import com.sun.xml.ws.util.JAXWSUtils;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xml.resolver.NbCatalogManager;
import org.apache.xml.resolver.tools.NbCatalogResolver;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlChangeListener;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlErrorHandler;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class WsdlModeler {
    private WsdlModel wsdlModel;
    private WSDLModeler ideWSDLModeler;
    private URL wsdlUrl;
    private URL[] bindings;
    private URL catalog;
    private EntityResolver entityResolver;
    private Set<String> bindingFiles;
    private String packageName;
    private List<WsdlModelListener> modelListeners;
    private List<WsdlChangeListener> wsdlChangeListeners;
    RequestProcessor.Task task;
    RequestProcessor.Task task1;
    int listenersSize;
    protected Properties properties;
    private Throwable creationException;

    WsdlModeler(URL uRL) {
        this.wsdlUrl = uRL;
        this.modelListeners = Collections.synchronizedList(new ArrayList());
        this.wsdlChangeListeners = new ArrayList<WsdlChangeListener>();
        this.task = RequestProcessor.getDefault().create(new Runnable(){

            public void run() {
                WsdlModeler.this.generateWsdlModel();
                WsdlModeler.this.fireModelCreated(WsdlModeler.this.wsdlModel);
            }
        }, true);
    }

    public void setPackageName(String string) {
        this.packageName = string;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setJAXBBindings(URL[] uRLArray) {
        this.bindings = uRLArray;
    }

    public URL[] getJAXBBindings() {
        return this.bindings;
    }

    public void setCatalog(URL uRL) {
        this.catalog = uRL;
    }

    public URL getCatalog() {
        return this.catalog;
    }

    void setWsdlUrl(URL uRL) {
        this.wsdlUrl = uRL;
    }

    public URL getWsdlUrl() {
        return this.wsdlUrl;
    }

    public Throwable getCreationException() {
        return this.creationException;
    }

    public WsdlModel getWsdlModel() {
        return this.wsdlModel;
    }

    public WsdlModel getAndWaitForWsdlModel() {
        if (this.getWsdlModel() == null) {
            this.generateWsdlModel();
        }
        return this.wsdlModel;
    }

    public void generateWsdlModel(WsdlModelListener wsdlModelListener, final WsdlErrorHandler wsdlErrorHandler) {
        this.task = RequestProcessor.getDefault().create(new Runnable(){

            public void run() {
                WsdlModeler.this.generateWsdlModel(wsdlErrorHandler);
                WsdlModeler.this.fireModelCreated(WsdlModeler.this.wsdlModel);
            }
        }, true);
        this.addWsdlModelListener(wsdlModelListener);
        this.task.run();
    }

    public void generateWsdlModel(WsdlModelListener wsdlModelListener) {
        this.generateWsdlModel(wsdlModelListener, false);
    }

    public void generateWsdlModel(WsdlModelListener wsdlModelListener, boolean bl) {
        if (bl) {
            try {
                this.task.waitFinished(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.addWsdlModelListener(wsdlModelListener);
            this.task.schedule(0);
        } else {
            this.addWsdlModelListener(wsdlModelListener);
            if (this.task.isFinished()) {
                this.task.schedule(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateWsdlModel() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ZephyrParserFactory.class.getClassLoader());
        try {
            this.generateWsdlModel(new CatchFirstErrorHandler());
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    private void generateWsdlModel(WsdlErrorHandler wsdlErrorHandler) {
        WsimportOptions wsimportOptions = new WsimportOptions();
        this.properties = new Properties();
        this.bindingFiles = new HashSet<String>();
        if (this.bindings != null) {
            for (int i = 0; i < this.bindings.length; ++i) {
                try {
                    wsimportOptions.addBindings(JAXWSUtils.absolutize((String)this.bindings[i].toExternalForm()));
                    continue;
                }
                catch (BadCommandLineException badCommandLineException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.FINE, "WsdlModeler.generateWsdlModel", badCommandLineException);
                }
            }
        }
        try {
            if (this.wsdlUrl.toExternalForm().startsWith("http://") || this.wsdlUrl.toExternalForm().startsWith("https://")) {
                InputSource inputSource = new InputSource(this.wsdlUrl.toExternalForm());
                wsimportOptions.addWSDL(inputSource);
            } else {
                wsimportOptions.addWSDL(new File(this.wsdlUrl.getFile()));
            }
            wsimportOptions.compatibilityMode = 2;
            if (this.packageName != null) {
                wsimportOptions.defaultPackage = this.packageName;
            }
            if (this.catalog != null) {
                NbCatalogManager nbCatalogManager = new NbCatalogManager(null);
                nbCatalogManager.setCatalogFiles(this.catalog.toExternalForm());
                nbCatalogManager.setUseStaticCatalog(false);
                nbCatalogManager.setVerbosity(4);
                wsimportOptions.entityResolver = this.entityResolver = new NbCatalogResolver(nbCatalogManager);
            }
            wsimportOptions.parseBindings((ErrorReceiver)new IdeErrorReceiver(wsdlErrorHandler));
            this.ideWSDLModeler = new WSDLModeler(wsimportOptions, (ErrorReceiver)new IdeErrorReceiver(wsdlErrorHandler));
            Model model = this.ideWSDLModeler.buildModel();
            if (model != null) {
                WsdlModel wsdlModel = this.wsdlModel;
                this.wsdlModel = new WsdlModel(model);
                this.fireWsdlModelChanged(wsdlModel, this.wsdlModel);
                this.creationException = null;
            } else {
                WsdlModel wsdlModel = this.wsdlModel;
                this.wsdlModel = null;
                if (wsdlModel != null) {
                    this.fireWsdlModelChanged(wsdlModel, null);
                }
                SAXParseException sAXParseException = null;
                if (wsdlErrorHandler instanceof CatchFirstErrorHandler) {
                    sAXParseException = ((CatchFirstErrorHandler)wsdlErrorHandler).getFirstError();
                    this.creationException = sAXParseException;
                }
                if (sAXParseException == null) {
                    this.creationException = new Exception(NbBundle.getMessage(WsdlModeler.class, (String)"ERR_CannotGenerateModel", (Object)this.wsdlUrl.toExternalForm()));
                }
                Logger.getLogger(this.getClass().getName()).log(Level.FINE, "WsdlModeler.generateWsdlModel", this.creationException);
            }
        }
        catch (Throwable throwable) {
            this.wsdlModel = null;
            SAXParseException sAXParseException = null;
            if (wsdlErrorHandler instanceof CatchFirstErrorHandler) {
                sAXParseException = ((CatchFirstErrorHandler)wsdlErrorHandler).getFirstError();
                this.creationException = sAXParseException;
            }
            if (sAXParseException == null) {
                this.creationException = throwable;
            }
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "WsdlModeler.generateWsdlModel", throwable);
        }
    }

    private synchronized void addWsdlModelListener(WsdlModelListener wsdlModelListener) {
        if (wsdlModelListener != null) {
            this.modelListeners.add(wsdlModelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireModelCreated(WsdlModel wsdlModel) {
        Object object = this.modelListeners;
        synchronized (object) {
            for (WsdlModelListener wsdlModelListener : this.modelListeners) {
                wsdlModelListener.modelCreated(wsdlModel);
            }
        }
        object = this;
        synchronized (object) {
            this.modelListeners.clear();
        }
    }

    public synchronized void addWsdlChangeListener(WsdlChangeListener wsdlChangeListener) {
        this.wsdlChangeListeners.add(wsdlChangeListener);
    }

    public synchronized void removeWsdlChangeListener(WsdlChangeListener wsdlChangeListener) {
        this.wsdlChangeListeners.remove(wsdlChangeListener);
    }

    private void fireWsdlModelChanged(WsdlModel wsdlModel, WsdlModel wsdlModel2) {
        for (WsdlChangeListener wsdlChangeListener : this.wsdlChangeListeners) {
            wsdlChangeListener.wsdlModelChanged(wsdlModel, wsdlModel2);
        }
    }

    private class CatchFirstErrorHandler
    implements WsdlErrorHandler {
        private SAXParseException firstError;

        private CatchFirstErrorHandler() {
        }

        public void warning(SAXParseException sAXParseException) throws WsdlErrorHandler.AbortException {
        }

        public void info(SAXParseException sAXParseException) {
        }

        public void fatalError(SAXParseException sAXParseException) throws WsdlErrorHandler.AbortException {
            if (this.firstError == null) {
                this.firstError = sAXParseException;
            }
        }

        public void error(SAXParseException sAXParseException) throws WsdlErrorHandler.AbortException {
            if (this.firstError == null) {
                this.firstError = sAXParseException;
            }
        }

        public SAXParseException getFirstError() {
            return this.firstError;
        }
    }

    private class IdeErrorReceiver
    extends ErrorReceiver {
        private WsdlErrorHandler errorHandler;

        IdeErrorReceiver(WsdlErrorHandler wsdlErrorHandler) {
            this.errorHandler = wsdlErrorHandler;
        }

        public void warning(SAXParseException sAXParseException) throws AbortException {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.FINE, "WsdlModeler.generateWsdlModel", sAXParseException);
            if (this.errorHandler != null) {
                try {
                    this.errorHandler.warning(sAXParseException);
                }
                catch (WsdlErrorHandler.AbortException abortException) {
                    AbortException abortException2 = new AbortException();
                    abortException2.initCause((Throwable)abortException);
                    throw abortException2;
                }
            }
        }

        public void info(SAXParseException sAXParseException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.FINE, "WsdlModeler.generateWsdlModel", sAXParseException);
            if (this.errorHandler != null) {
                this.errorHandler.info(sAXParseException);
            }
        }

        public void fatalError(SAXParseException sAXParseException) throws AbortException {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.FINE, "WsdlModeler.generateWsdlModel", sAXParseException);
            if (this.errorHandler != null) {
                try {
                    this.errorHandler.fatalError(sAXParseException);
                }
                catch (WsdlErrorHandler.AbortException abortException) {
                    AbortException abortException2 = new AbortException();
                    abortException2.initCause((Throwable)abortException);
                    throw abortException2;
                }
            }
        }

        public void error(SAXParseException sAXParseException) throws AbortException {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.FINE, "WsdlModeler.generateWsdlModel", sAXParseException);
            if (this.errorHandler != null) {
                try {
                    this.errorHandler.error(sAXParseException);
                }
                catch (WsdlErrorHandler.AbortException abortException) {
                    AbortException abortException2 = new AbortException();
                    abortException2.initCause((Throwable)abortException);
                    throw abortException2;
                }
            }
        }

        public void debug(SAXParseException sAXParseException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.FINE, "WsdlModeler.generateWsdlModel", sAXParseException);
            if (this.errorHandler != null) {
                this.errorHandler.info(sAXParseException);
            }
        }
    }
}

