/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import org.netbeans.lib.profiler.ui.components.AnimatedContainer;

public class Animator
implements ActionListener {
    private static final int STEPS = 5;
    private static final int DURATION = 100;
    AnimatedContainer cont1;
    AnimatedContainer cont2;
    Timer timer;
    private int stepsCounter;

    public Animator(AnimatedContainer animatedContainer, AnimatedContainer animatedContainer2) {
        this.cont1 = animatedContainer;
        this.cont2 = animatedContainer2;
        this.timer = new Timer(20, null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.performAnimationStep();
    }

    public void startAnimation() {
        this.stepsCounter = 0;
        this.timer.addActionListener(this);
        this.timer.start();
    }

    private void performAnimationStep() {
        int n = 20;
        ++this.stepsCounter;
        if (this.stepsCounter == 5) {
            this.cont1.setFinishState();
            if (this.cont2 != null) {
                this.cont2.setFinishState();
            }
            this.cont1.revalidate();
            if (this.cont2 != null) {
                this.cont2.revalidate();
            }
            this.timer.stop();
            this.timer.removeActionListener(this);
        } else {
            this.cont1.setState(this.stepsCounter * n);
            if (this.cont2 != null) {
                this.cont2.setState(this.stepsCounter * n);
            }
            this.cont1.revalidate();
            if (this.cont2 != null) {
                this.cont2.revalidate();
            }
        }
    }
}

