/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.netbeans.lib.profiler.ui.components.JExtendedSplitPane;

public class JCompoundSplitPane
extends JExtendedSplitPane {
    public JCompoundSplitPane() {
        this.tweakUI();
    }

    public JCompoundSplitPane(int n) {
        super(n);
        this.tweakUI();
    }

    public JCompoundSplitPane(int n, boolean bl) {
        super(n, bl);
        this.tweakUI();
    }

    public JCompoundSplitPane(int n, boolean bl, Component component, Component component2) {
        super(n, bl, component, component2);
        this.tweakUI();
    }

    public JCompoundSplitPane(int n, Component component, Component component2) {
        super(n, component, component2);
        this.tweakUI();
    }

    private Component getFirstComponent() {
        return this.getFirstComponent(this);
    }

    private Component getFirstComponent(JSplitPane jSplitPane) {
        if (jSplitPane.getOrientation() == 1) {
            return jSplitPane.getLeftComponent();
        }
        return jSplitPane.getTopComponent();
    }

    private Component getSecondComponent() {
        return this.getSecondComponent(this);
    }

    private Component getSecondComponent(JSplitPane jSplitPane) {
        if (jSplitPane.getOrientation() == 1) {
            return jSplitPane.getRightComponent();
        }
        return jSplitPane.getBottomComponent();
    }

    private void tweakUI() {
        if (!(this.getUI() instanceof BasicSplitPaneUI)) {
            return;
        }
        BasicSplitPaneDivider basicSplitPaneDivider = ((BasicSplitPaneUI)this.getUI()).getDivider();
        if (basicSplitPaneDivider != null) {
            basicSplitPaneDivider.addMouseListener(new DividerMouseListener());
        }
    }

    private class DividerMouseListener
    extends MouseAdapter {
        private double firstResizeWeight = 0.0;
        private double secondResizeWeight = 1.0;

        private DividerMouseListener() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.configureComponents();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JSplitPane jSplitPane = (JSplitPane)JCompoundSplitPane.this.getFirstComponent();
                    JSplitPane jSplitPane2 = (JSplitPane)JCompoundSplitPane.this.getSecondComponent();
                    DividerMouseListener.this.firstResizeWeight = jSplitPane.getResizeWeight();
                    DividerMouseListener.this.secondResizeWeight = jSplitPane2.getResizeWeight();
                    jSplitPane.setResizeWeight(0.0);
                    jSplitPane2.setResizeWeight(1.0);
                }
            });
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ((JSplitPane)JCompoundSplitPane.this.getFirstComponent()).setResizeWeight(DividerMouseListener.this.firstResizeWeight);
                    ((JSplitPane)JCompoundSplitPane.this.getSecondComponent()).setResizeWeight(DividerMouseListener.this.secondResizeWeight);
                }
            });
        }

        private void configureComponents() {
            this.configureFirstComponent();
            this.configureSecondComponent();
        }

        private void configureFirstComponent() {
            JSplitPane jSplitPane = (JSplitPane)JCompoundSplitPane.this.getFirstComponent();
            int n = jSplitPane.getMinimumSize().width;
            int n2 = 0;
            n2 = JCompoundSplitPane.this.getFirstComponent(jSplitPane).isVisible() && JCompoundSplitPane.this.getSecondComponent(jSplitPane).isVisible() ? ((JCompoundSplitPane)JCompoundSplitPane.this).getFirstComponent((JSplitPane)jSplitPane).getSize().height + ((JCompoundSplitPane)JCompoundSplitPane.this).getSecondComponent((JSplitPane)jSplitPane).getMinimumSize().height + jSplitPane.getDividerSize() : (JCompoundSplitPane.this.getFirstComponent(jSplitPane).isVisible() ? ((JCompoundSplitPane)JCompoundSplitPane.this).getFirstComponent((JSplitPane)jSplitPane).getMinimumSize().height : ((JCompoundSplitPane)JCompoundSplitPane.this).getSecondComponent((JSplitPane)jSplitPane).getMinimumSize().height);
            jSplitPane.setMinimumSize(new Dimension(n, n2));
        }

        private void configureSecondComponent() {
            JSplitPane jSplitPane = (JSplitPane)JCompoundSplitPane.this.getSecondComponent();
            int n = jSplitPane.getMinimumSize().width;
            int n2 = 0;
            n2 = JCompoundSplitPane.this.getFirstComponent(jSplitPane).isVisible() && JCompoundSplitPane.this.getSecondComponent(jSplitPane).isVisible() ? ((JCompoundSplitPane)JCompoundSplitPane.this).getSecondComponent((JSplitPane)jSplitPane).getSize().height + (JCompoundSplitPane.this.getFirstComponent(jSplitPane).isVisible() ? ((JCompoundSplitPane)JCompoundSplitPane.this).getFirstComponent((JSplitPane)jSplitPane).getMinimumSize().height + jSplitPane.getDividerSize() : 0) : (JCompoundSplitPane.this.getFirstComponent(jSplitPane).isVisible() ? ((JCompoundSplitPane)JCompoundSplitPane.this).getFirstComponent((JSplitPane)jSplitPane).getMinimumSize().height : ((JCompoundSplitPane)JCompoundSplitPane.this).getSecondComponent((JSplitPane)jSplitPane).getMinimumSize().height);
            jSplitPane.setMinimumSize(new Dimension(n, n2));
        }
    }
}

