/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.ruby.platform;

import java.awt.Dialog;
import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.JButton;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.ruby.platform.RubyPlatformManager;
import org.netbeans.api.ruby.platform.RubyPlatformProvider;
import org.netbeans.api.ruby.platform.RubyPlatformValidator;
import org.netbeans.modules.ruby.platform.Util;
import org.netbeans.modules.ruby.platform.gems.GemInfo;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RubyPlatform
implements Comparable<RubyPlatform> {
    private static final Logger LOGGER = Logger.getLogger(RubyPlatform.class.getName());
    public static final String DEFAULT_RUBY_RELEASE = "1.8";
    public static final String RUBYSTUBS_VERSION = "1.8.7-p72";
    public static final String RUBYSTUBS = "rubystubs";
    static final String RUBY_DEBUG_IDE_NAME = "ruby-debug-ide";
    private final Info info;
    private final RubyPlatformValidator validator;
    private final String id;
    private final String interpreter;
    private File home;
    private String homeUrl;
    private FileObject libDirFO;
    private GemManager gemManager;
    private static FileObject stubsFO;
    private boolean indexInitialized;
    private String gemTool;
    private String rdoc;
    private String irb;
    private PropertyChangeSupport pcs;
    private String rake;
    private String rails;
    private String autotest;
    private String autospec;

    RubyPlatform(String string, String string2, Info info) {
        this.id = string;
        this.interpreter = string2;
        this.info = info;
        this.validator = new RubyPlatformValidator(this);
    }

    @CheckForNull
    public static RubyPlatform platformFor(Project project) {
        RubyPlatform rubyPlatform;
        RubyPlatformProvider rubyPlatformProvider = (RubyPlatformProvider)project.getLookup().lookup(RubyPlatformProvider.class);
        RubyPlatform rubyPlatform2 = rubyPlatform = rubyPlatformProvider == null ? null : rubyPlatformProvider.getPlatform();
        if (rubyPlatform == null && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Could not resolve a platform for " + project + ". " + "Platform provider: " + rubyPlatformProvider);
        }
        return rubyPlatform;
    }

    @CheckForNull
    public static GemManager gemManagerFor(Project project) {
        RubyPlatform rubyPlatform = RubyPlatform.platformFor(project);
        return rubyPlatform == null ? null : rubyPlatform.getGemManager();
    }

    @CheckForNull
    public static String platformDescriptionFor(Project project) {
        RubyPlatform rubyPlatform = RubyPlatform.platformFor(project);
        return rubyPlatform == null ? null : rubyPlatform.getInfo().getLongDescription();
    }

    public Info getInfo() {
        return this.info;
    }

    public boolean hasValidRake(boolean bl) {
        boolean bl2 = this.isValid(bl) && this.hasRubyGemsInstalled(bl);
        String string = this.getRake();
        bl2 = string != null && new File(string).exists();
        this.possiblyNotifyUser(bl, bl2, "rake");
        return bl2;
    }

    public boolean hasValidRails(boolean bl) {
        String string = this.getRails();
        boolean bl2 = string != null && new File(string).exists();
        this.possiblyNotifyUser(bl, bl2, "rails");
        return bl2;
    }

    public boolean hasValidAutoTest(boolean bl) {
        boolean bl2 = this.isValidFile(this.getAutoTest());
        this.possiblyNotifyUser(bl, bl2, "autotest");
        return bl2;
    }

    public boolean hasValidAutoSpec(boolean bl) {
        boolean bl2 = this.isValidFile(this.getAutoSpec());
        this.possiblyNotifyUser(bl, bl2, "autospec");
        return bl2;
    }

    private boolean isValidFile(String string) {
        return string != null && new File(string).exists();
    }

    public static boolean hasValidRake(Project project, boolean bl) {
        RubyPlatform rubyPlatform = RubyPlatform.platformFor(project);
        if (rubyPlatform == null) {
            if (bl) {
                RubyPlatform.showWarning(project);
            }
            return false;
        }
        return rubyPlatform.hasValidRake(bl);
    }

    public String getRake() {
        if (this.rake == null) {
            this.rake = this.findExecutable("rake");
            if (this.rake != null && !new File(this.rake).exists() && this.getGemManager().getLatestVersion("rake") != null) {
                InstalledFileLocator installedFileLocator = InstalledFileLocator.getDefault();
                File file = installedFileLocator.locate("modules/org-netbeans-modules-ruby-project.jar", null, false);
                if (file == null) {
                    throw new RuntimeException("Can't find cluster");
                }
                file = new File(file.getParentFile().getParentFile().getAbsolutePath() + File.separator + "rake");
                try {
                    this.rake = file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
        return this.rake;
    }

    public String getRails() {
        if (this.rails == null) {
            this.rails = this.findExecutable("rails");
        }
        return this.rails;
    }

    public String getAutoTest() {
        if (this.autotest == null) {
            this.autotest = this.findExecutable("autotest");
        }
        return this.autotest;
    }

    public String getAutoSpec() {
        if (this.autospec == null) {
            this.autospec = this.findExecutable("autospec");
        }
        return this.autospec;
    }

    public String getID() {
        return this.id;
    }

    public String getInterpreter(boolean bl) {
        String string = this.interpreter;
        if (bl) {
            try {
                string = new File(this.interpreter).getCanonicalFile().getAbsolutePath();
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, "Cannot get canonical path", iOException);
            }
        }
        this.updateIndexRoots();
        return string;
    }

    public String getInterpreter() {
        this.updateIndexRoots();
        return this.interpreter;
    }

    public File getInterpreterFile() {
        this.updateIndexRoots();
        return new File(this.interpreter);
    }

    public File getHome() {
        return this.getHome(true);
    }

    public File getHome(boolean bl) {
        if (this.home == null) {
            try {
                String string = this.getInterpreter(bl);
                if (string == null) {
                    return null;
                }
                File file = new File(string);
                File file2 = file.getParentFile();
                if (file2 == null) {
                    return null;
                }
                if ((file2 = file2.getParentFile()) == null) {
                    return null;
                }
                this.home = file2.getCanonicalFile();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                return null;
            }
        }
        return this.home;
    }

    public String getHomeUrl() {
        if (this.homeUrl == null) {
            try {
                File file = this.getHome();
                if (file != null) {
                    this.homeUrl = file.toURI().toURL().toExternalForm();
                }
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
        }
        return this.homeUrl;
    }

    public String getLibDir() {
        if (this.isRubinius()) {
            return this.getRubiniusLibDir();
        }
        String string = this.info.getLibDir();
        if (string == null) {
            LOGGER.warning("rubylibdir not found for " + this.interpreter + ", was: " + string);
            return null;
        }
        File file = new File(string);
        if (!file.isDirectory()) {
            LOGGER.warning("rubylibdir not found for " + this.interpreter + ", was: " + string);
            return null;
        }
        if ((file = file.getParentFile()) == null) {
            return null;
        }
        if ((file = file.getParentFile()) == null) {
            return null;
        }
        return file.getAbsolutePath();
    }

    private String getRubiniusLibDir() {
        File file = new File(this.getHome(), "lib");
        return file.isDirectory() ? file.getAbsolutePath() : null;
    }

    public FileObject getLibDirFO() {
        String string;
        if (this.libDirFO == null && (string = this.getLibDir()) != null) {
            this.libDirFO = FileUtil.toFileObject((File)new File(string));
        }
        return this.libDirFO;
    }

    public String getVersionLibDir() {
        return this.info.getLibDir();
    }

    public String getRubyLibSiteDir() {
        String string = null;
        File file = this.getHome();
        assert (file != null) : "home not null";
        File file2 = new File(file, "lib" + File.separator + "ruby" + File.separator + "site_ruby");
        if (!file2.exists()) {
            return null;
        }
        File file3 = new File(file2, DEFAULT_RUBY_RELEASE);
        if (file3.exists()) {
            string = file3.getAbsolutePath();
        } else {
            File[] fileArray;
            for (File file4 : fileArray = file2.listFiles()) {
                String string2;
                if (!file4.isDirectory() || !(string2 = file4.getName()).matches("\\d+\\.\\d+")) continue;
                string = file4.getAbsolutePath();
                break;
            }
            if (string == null && fileArray.length > 0) {
                string = fileArray[0].getAbsolutePath();
            }
        }
        return string;
    }

    public boolean isValid() {
        return this.isValid(false);
    }

    public boolean isValid(boolean bl) {
        String string;
        boolean bl2;
        boolean bl3 = bl2 = new File(this.interpreter).isFile() && this.getLibDir() != null;
        if (bl2 && (string = this.getBinDir()) != null) {
            bl2 = new File(string).isDirectory();
        }
        if (bl && !bl2) {
            RubyPlatform.showWarning(this);
        }
        return bl2;
    }

    private static void showWarning(RubyPlatform rubyPlatform) {
        String string = NbBundle.getMessage(RubyPlatform.class, (String)"InvalidRubyPlatform", (Object)rubyPlatform.getLabel());
        JButton jButton = RubyPlatform.getCloseButton();
        Object[] objectArray = new Object[]{jButton};
        RubyPlatform.showDialog(string, objectArray);
    }

    private static void showWarning(Project project) {
        String string = NbBundle.getMessage(RubyPlatform.class, (String)"InvalidRubyPlatformForProject", (Object)ProjectUtils.getInformation((Project)project).getDisplayName());
        JButton jButton = RubyPlatform.getCloseButton();
        CustomizerProvider customizerProvider = (CustomizerProvider)project.getLookup().lookup(CustomizerProvider.class);
        JButton jButton2 = new JButton(NbBundle.getMessage(RubyPlatform.class, (String)"Properties"));
        Object[] objectArray = customizerProvider != null ? new Object[]{jButton2, jButton} : new Object[]{jButton};
        if (RubyPlatform.showDialog(string, objectArray) == jButton2) {
            customizerProvider.showCustomizer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object showDialog(String string, Object[] objectArray) {
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)string, NbBundle.getMessage(RubyPlatform.class, (String)"MissingRuby"), true, objectArray, objectArray[0], 0, new HelpCtx(RubyPlatform.class), null);
        dialogDescriptor.setMessageType(0);
        dialogDescriptor.setModal(true);
        Dialog dialog = null;
        try {
            dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.setVisible(true);
        }
        finally {
            if (dialog != null) {
                dialog.dispose();
            }
        }
        return dialogDescriptor.getValue();
    }

    private static JButton getCloseButton() {
        JButton jButton = new JButton(NbBundle.getMessage(RubyPlatform.class, (String)"CTL_Close"));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RubyPlatform.class, (String)"AD_Close"));
        return jButton;
    }

    public String getVersion() {
        return this.info.getVersion();
    }

    public String getLabel() {
        return this.info.getLabel(this.isDefault());
    }

    public boolean isDefault() {
        RubyPlatform rubyPlatform = RubyPlatformManager.getDefaultPlatform();
        return rubyPlatform != null && this.interpreter.equals(rubyPlatform.getInterpreter());
    }

    public boolean isJRuby() {
        return this.info.isJRuby();
    }

    public boolean isRubinius() {
        return this.info.isRubinius();
    }

    public boolean showWarningIfInvalid() {
        boolean bl = this.isValid();
        if (!bl) {
            Util.notifyLocalized(RubyPlatform.class, "RubyPlatform.InvalidInterpreter", 2, new Object[]{this.getInterpreter()});
        }
        return bl;
    }

    @CheckForNull
    public GemManager getGemManager() {
        if (this.gemManager == null && this.hasRubyGemsInstalled()) {
            this.gemManager = new GemManager(this);
        }
        return this.gemManager;
    }

    public String getBinDir() {
        return this.getBinDir(true);
    }

    public String getBinDir(boolean bl) {
        String string = null;
        String string2 = this.getInterpreter(bl);
        if (string2 != null) {
            string = new File(string2).getParent();
        }
        return string;
    }

    public String findExecutable(String string) {
        return this.findExecutable(string, true);
    }

    private String findExecutable(String string, boolean bl) {
        String string2 = null;
        boolean bl2 = true;
        do {
            File file;
            String string3;
            String string4;
            if ((string4 = this.getBinDir()) != null) {
                LOGGER.finer("Looking for '" + string + "' executable; used intepreter: '" + this.getInterpreter() + "'");
                string2 = RubyPlatform.findExecutable(string4, string);
            } else {
                LOGGER.warning("Could not find Ruby interpreter executable when searching for '" + string + "'");
            }
            if (string2 != null || !bl || !this.hasRubyGemsInstalled()) continue;
            Iterator<? extends File> iterator = this.getGemManager().getRepositories().iterator();
            while (iterator.hasNext() && (string2 = RubyPlatform.findExecutable(string3 = (file = iterator.next()).getAbsolutePath() + File.separator + "bin", string)) == null) {
            }
        } while (!(bl2 ^= true) && string2 == null);
        if (string2 == null) {
            string2 = Util.findOnPath(string);
        }
        if (string2 == null && !string.endsWith(".bat") && Utilities.isWindows()) {
            string2 = this.findExecutable(string + ".bat", bl);
        }
        if (string2 != null) {
            LOGGER.finer("Found '" + string + "': '" + string2 + "'");
        }
        return string2;
    }

    private String findExecutable(String string, boolean bl, boolean bl2) {
        String string2;
        String string3 = this.findExecutable(string, bl);
        if (string3 == null && bl2 && !this.isJRuby() && (string2 = new File(this.getInterpreter(true)).getName()).startsWith("ruby")) {
            String string4 = string2.substring(4);
            string3 = this.findExecutable(string + string4, bl);
        }
        return string3;
    }

    private static String findExecutable(String string, String string2) {
        String string3 = string + File.separator + string2;
        if (!new File(string3).isFile()) {
            LOGGER.finer("'" + string3 + "' is not a file.");
            string3 = null;
        }
        return string3;
    }

    public String getGemTool() {
        if (this.gemTool == null) {
            this.gemTool = this.findExecutable("gem", false, true);
        }
        return this.gemTool;
    }

    public String getRDoc() {
        if (this.rdoc == null) {
            this.rdoc = this.findExecutable("rdoc", false, true);
        }
        return this.rdoc;
    }

    public String getIRB() {
        if (this.irb == null) {
            this.irb = this.findExecutable(this.isJRuby() ? "jirb" : "irb", false, true);
        }
        return this.irb;
    }

    public static FileObject getRubyStubs() {
        if (stubsFO == null) {
            File file = InstalledFileLocator.getDefault().locate("modules/org-netbeans-modules-ruby-project.jar", null, false);
            if (file != null) {
                File file2 = new File(file.getParentFile().getParentFile().getAbsoluteFile(), RUBYSTUBS + File.separator + RUBYSTUBS_VERSION);
                assert (file2.exists() && file2.isDirectory());
                stubsFO = FileUtil.toFileObject((File)file2);
            } else {
                FileObject fileObject;
                String string;
                RubyPlatform rubyPlatform = RubyPlatformManager.getDefaultPlatform();
                if (rubyPlatform != null && (string = rubyPlatform.getInterpreter()) != null && (fileObject = FileUtil.toFileObject((File)new File(string))) != null) {
                    stubsFO = fileObject.getParent().getParent().getParent().getFileObject("rubystubs/1.8.7-p72");
                }
            }
        }
        return stubsFO;
    }

    public boolean hasFastDebuggerInstalled() {
        return this.getGemManager() != null && !this.isRubinius() && this.getFastDebuggerProblemsInHTML() == null;
    }

    public String getFastDebuggerProblemsInHTML() {
        assert (this.getGemManager() != null) : "has gemManager when asking whether Fast Debugger is installed";
        StringBuilder stringBuilder = new StringBuilder();
        this.checkAndReport(RUBY_DEBUG_IDE_NAME, this.getRequiredRDebugIDEVersionPattern(), stringBuilder);
        return stringBuilder.length() == 0 ? null : stringBuilder.toString();
    }

    private Pattern getRequiredRDebugIDEVersionPattern() {
        return Pattern.compile("0\\.4\\..*");
    }

    private void checkAndReport(String string, final Pattern pattern, StringBuilder stringBuilder) {
        GemManager.VersionPredicate versionPredicate = new GemManager.VersionPredicate(){

            public boolean isRight(String string) {
                return pattern.matcher(string).matches();
            }
        };
        if (!this.getGemManager().isGemInstalledForPlatform(string, versionPredicate)) {
            stringBuilder.append(NbBundle.getMessage(RubyPlatform.class, (String)"RubyPlatform.GemInVersionMissing", (Object)string, (Object)pattern.toString()));
            stringBuilder.append("<br>");
        }
    }

    public void reportRubyGemsProblem() {
        this.validator.reportRubyGemsProblem();
    }

    public boolean checkAndReportRubyGemsProblems() {
        return this.validator.checkAndReportRubyGemsProblems();
    }

    public String getRubyGemsProblems() {
        return this.validator.getRubyGemsProblems();
    }

    public String getLatestAvailableValidRDebugIDEVersions() {
        List<GemInfo> list = this.getGemManager().getVersions(RUBY_DEBUG_IDE_NAME);
        for (GemInfo gemInfo : list) {
            String string = gemInfo.getVersion();
            if (!this.getRequiredRDebugIDEVersionPattern().matcher(string).matches()) continue;
            return string;
        }
        return null;
    }

    public boolean installFastDebugger() {
        assert (this.getGemManager() != null) : "has gemManager when trying to install fast debugger";
        Runnable runnable = new Runnable(){

            public void run() {
                RubyPlatform.this.getGemManager().installGem(RubyPlatform.RUBY_DEBUG_IDE_NAME, false, false, "0.4.4");
            }
        };
        if (!EventQueue.isDispatchThread()) {
            try {
                EventQueue.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Exceptions.printStackTrace((Throwable)invocationTargetException);
            }
        } else {
            runnable.run();
        }
        return this.hasFastDebuggerInstalled();
    }

    public FileObject getSystemRoot(FileObject fileObject) {
        FileObject fileObject2;
        FileObject fileObject3 = this.isRubinius() ? null : this.getLibDirFO();
        FileObject fileObject4 = RubyPlatform.getRubyStubs();
        FileObject fileObject5 = fileObject2 = this.getGemManager() != null ? this.getGemManager().getGemHomeFO() : null;
        while (fileObject != null) {
            if (fileObject.equals(fileObject3) || fileObject.equals(fileObject4) || fileObject.equals(fileObject2)) {
                return fileObject;
            }
            fileObject = fileObject.getParent();
        }
        return null;
    }

    private void updateIndexRoots() {
    }

    public void recomputeRoots() {
        this.updateIndexRoots();
        if (this.pcs != null) {
            this.pcs.firePropertyChange("roots", null, null);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void setGemHome(File file) {
        assert (this.hasRubyGemsInstalled()) : "has RubyGems installed";
        this.info.setGemHome(file.getAbsolutePath());
        try {
            RubyPlatformManager.storePlatform(this);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, iOException.getLocalizedMessage(), iOException);
        }
        this.getGemManager().reset();
    }

    public boolean hasRubyGemsInstalled() {
        return this.hasRubyGemsInstalled(false);
    }

    public boolean hasRubyGemsInstalled(boolean bl) {
        return this.validator.hasRubyGemsInstalled(bl);
    }

    public void fireGemsChanged() {
        if (this.pcs != null) {
            this.pcs.firePropertyChange("gems", null, null);
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RubyPlatform rubyPlatform = (RubyPlatform)object;
        return !(this.interpreter == null ? rubyPlatform.interpreter != null : !this.interpreter.equals(rubyPlatform.interpreter));
    }

    public int hashCode() {
        int n = 3;
        n = 97 * n + (this.interpreter != null ? this.interpreter.hashCode() : 0);
        return n;
    }

    @Override
    public int compareTo(RubyPlatform rubyPlatform) {
        return this.getInterpreter().compareTo(rubyPlatform.getInterpreter());
    }

    public String toString() {
        return "RubyPlatform[id:" + this.getID() + ", label:" + this.getLabel() + ", " + this.getInterpreter() + ", info: " + this.info + "]";
    }

    private void possiblyNotifyUser(boolean bl, boolean bl2, String string) {
        if (bl && !bl2) {
            String string2 = NbBundle.getMessage(RubyPlatform.class, (String)"RubyPlatform.NotInstalledCmd", (Object)string, (Object)this.getLabel());
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
    }

    public static class Info {
        static final String RUBY_KIND = "ruby_kind";
        static final String RUBY_VERSION = "ruby_version";
        static final String JRUBY_VERSION = "jruby_version";
        static final String RUBY_PATCHLEVEL = "ruby_patchlevel";
        static final String RUBY_RELEASE_DATE = "ruby_release_date";
        static final String RUBY_EXECUTABLE = "ruby_executable";
        static final String RUBY_PLATFORM = "ruby_platform";
        static final String RUBY_LIB_DIR = "ruby_lib_dir";
        static final String GEM_HOME = "gem_home";
        static final String GEM_PATH = "gem_path";
        static final String GEM_VERSION = "gem_version";
        private final String kind;
        private final String version;
        private String jversion;
        private String patchlevel;
        private String releaseDate;
        private String platform;
        private String gemHome;
        private String gemPath;
        private String gemVersion;
        private String libDir;

        Info(Properties properties) {
            this.kind = properties.getProperty(RUBY_KIND);
            this.version = properties.getProperty(RUBY_VERSION);
            this.jversion = properties.getProperty(JRUBY_VERSION);
            this.patchlevel = properties.getProperty(RUBY_PATCHLEVEL);
            this.releaseDate = properties.getProperty(RUBY_RELEASE_DATE);
            this.platform = properties.getProperty(RUBY_PLATFORM);
            this.libDir = properties.getProperty(RUBY_LIB_DIR);
            this.setGemHome(properties.getProperty(GEM_HOME));
            this.gemPath = properties.getProperty(GEM_PATH);
            this.gemVersion = properties.getProperty(GEM_VERSION);
        }

        Info(String string, String string2) {
            this.kind = string;
            this.version = string2;
        }

        static Info forDefaultPlatform() {
            Info info = new Info("JRuby", "1.8.6");
            info.jversion = "1.2.0";
            info.patchlevel = "287";
            info.releaseDate = "2009-03-16";
            info.platform = "java";
            File file = InstalledFileLocator.getDefault().locate("jruby-1.2.0", "org.netbeans.modules.ruby.platform", false);
            assert (file != null && file.isDirectory()) : "Default platform available";
            FileObject fileObject = FileUtil.toFileObject((File)file).getFileObject("/lib/ruby");
            info.libDir = FileUtil.toFile((FileObject)fileObject.getFileObject("/1.8")).getAbsolutePath();
            info.gemPath = info.gemHome = FileUtil.toFile((FileObject)fileObject.getFileObject("/gems/1.8")).getAbsolutePath();
            info.gemVersion = "1.3.1";
            return info;
        }

        public String getLabel(boolean bl) {
            String string = this.isJRuby() ? this.jversion : this.version + (this.patchlevel != null ? "-p" + this.patchlevel : "");
            return (bl ? NbBundle.getMessage(RubyPlatform.class, (String)"RubyPlatformManager.CTL_BundledJRubyLabel") : this.kind) + ' ' + string;
        }

        public String getLongDescription() {
            StringBuilder stringBuilder = new StringBuilder(this.kind + ' ' + this.version + ' ' + '(' + this.releaseDate);
            if (this.patchlevel != null) {
                stringBuilder.append(" patchlevel ").append(this.patchlevel);
            }
            stringBuilder.append(") [").append(this.platform).append(']');
            return stringBuilder.toString();
        }

        public boolean isJRuby() {
            return "JRuby".equals(this.kind);
        }

        public boolean isRubinius() {
            return "Rubinius".equals(this.kind);
        }

        public final void setGemHome(String string) {
            this.gemHome = string == null ? null : new File(string).getAbsolutePath();
        }

        public String getGemHome() {
            return this.gemHome;
        }

        public void setGemPath(String string) {
            this.gemPath = string;
        }

        public String getGemPath() {
            return this.gemPath;
        }

        public String getGemVersion() {
            return this.gemVersion;
        }

        public String getKind() {
            return this.kind;
        }

        public String getPatchlevel() {
            return this.patchlevel;
        }

        public String getPlatform() {
            return this.platform;
        }

        public String getReleaseDate() {
            return this.releaseDate;
        }

        public String getJVersion() {
            return this.jversion;
        }

        public String getVersion() {
            return this.version;
        }

        public String getPlatformVersion() {
            return this.isJRuby() ? this.getJVersion() : this.getVersion();
        }

        public String getLibDir() {
            return this.libDir;
        }

        public String toString() {
            return "RubyPlatform$Info[GEM_HOME:" + this.getGemHome() + ", GEM_PATH: " + this.getGemPath() + ", gemVersion: " + this.getGemVersion() + ", lib: " + this.getLibDir() + "]";
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Info info = (Info)object;
            if (!(this.kind == info.kind || this.kind != null && this.kind.equals(info.kind))) {
                return false;
            }
            if (!(this.version == info.version || this.version != null && this.version.equals(info.version))) {
                return false;
            }
            if (!(this.patchlevel == info.patchlevel || this.patchlevel != null && this.patchlevel.equals(info.patchlevel))) {
                return false;
            }
            return this.platform == info.platform || this.platform != null && this.platform.equals(info.platform);
        }

        public int hashCode() {
            int n = 7;
            n = 83 * n + (this.kind != null ? this.kind.hashCode() : 0);
            n = 83 * n + (this.version != null ? this.version.hashCode() : 0);
            n = 83 * n + (this.patchlevel != null ? this.patchlevel.hashCode() : 0);
            n = 83 * n + (this.platform != null ? this.platform.hashCode() : 0);
            return n;
        }
    }
}

