/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.gems;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.ruby.platform.gems.Gem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GemListParser {
    private static final Logger LOGGER = Logger.getLogger(GemListParser.class.getName());

    private GemListParser() {
    }

    static List<Gem> parseLocal(List<? extends String> list) {
        return GemListParser.parse(list, true);
    }

    static List<Gem> parseRemote(List<? extends String> list) {
        return GemListParser.parse(list, false);
    }

    private static List<Gem> parse(List<? extends String> list, boolean bl) {
        LOGGER.finer("Going to parse Gem list");
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Using the following output:");
            LOGGER.finest("=== Output Start ===");
            for (String object2 : list) {
                LOGGER.finest(object2);
            }
            LOGGER.finest("=== Output End ===");
        }
        Object object3 = null;
        ArrayList<Gem> arrayList = new ArrayList<Gem>();
        for (String string : list) {
            if (string.length() == 0 || Character.isWhitespace(string.charAt(0))) {
                if (object3 == null) continue;
                String n = string.trim();
                if (((Gem)object3).getDescription() == null) {
                    ((Gem)object3).setDescription(n);
                    continue;
                }
                ((Gem)object3).setDescription(((Gem)object3).getDescription() + "\n" + n);
                continue;
            }
            if (string.charAt(0) == '.') continue;
            int n = string.indexOf(40);
            if (n != -1) {
                String string2 = string.substring(0, n).trim();
                int n2 = string.indexOf(41);
                String string3 = n2 != -1 ? string.substring(n + 1, n2) : string.substring(n);
                object3 = new Gem(string2, bl ? string3 : null, bl ? null : string3);
                arrayList.add((Gem)object3);
                continue;
            }
            object3 = null;
        }
        LOGGER.finer("Parsed " + arrayList.size() + " gems");
        return arrayList;
    }
}

