/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.j2seproject.J2SEActionProvider;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.java.j2seproject.J2SEProjectUtil;
import org.netbeans.spi.project.CopyOperationImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.MoveOperationImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J2SEProjectOperations
implements DeleteOperationImplementation,
CopyOperationImplementation,
MoveOperationImplementation {
    private final J2SEProject project;
    private final J2SEActionProvider actionProvider;
    private String appArgs;
    private String workDir;
    private String libraryPath;
    private File libraryFile;
    private boolean libraryWithinProject;
    private String absolutesRelPath;
    private FileSystem configs;

    public J2SEProjectOperations(J2SEProject j2SEProject, J2SEActionProvider j2SEActionProvider) {
        assert (j2SEProject != null);
        assert (j2SEActionProvider != null);
        this.project = j2SEProject;
        this.actionProvider = j2SEActionProvider;
    }

    private static void addFile(FileObject fileObject, String string, List<FileObject> list) {
        FileObject fileObject2 = fileObject.getFileObject(string);
        if (fileObject2 != null) {
            list.add(fileObject2);
        }
    }

    public List<FileObject> getMetadataFiles() {
        FileObject fileObject = this.project.getProjectDirectory();
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        J2SEProjectOperations.addFile(fileObject, "nbproject", arrayList);
        J2SEProjectOperations.addFile(fileObject, J2SEProjectUtil.getBuildXmlName(this.project), arrayList);
        J2SEProjectOperations.addFile(fileObject, "xml-resources", arrayList);
        J2SEProjectOperations.addFile(fileObject, "catalog.xml", arrayList);
        return arrayList;
    }

    public List<FileObject> getDataFiles() {
        File file;
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        arrayList.addAll(Arrays.asList(this.project.getSourceRoots().getRoots()));
        arrayList.addAll(Arrays.asList(this.project.getTestSourceRoots().getRoots()));
        J2SEProjectOperations.addFile(this.project.getProjectDirectory(), "manifest.mf", arrayList);
        J2SEProjectOperations.addFile(this.project.getProjectDirectory(), "master.jnlp", arrayList);
        AntProjectHelper antProjectHelper = this.project.getAntProjectHelper();
        if (antProjectHelper.getLibrariesLocation() != null && (file = antProjectHelper.resolveFile(antProjectHelper.getLibrariesLocation())) != null && file.exists()) {
            FileObject fileObject = FileUtil.toFileObject((File)file).getParent();
            if (FileUtil.isParentOf((FileObject)this.project.getProjectDirectory(), (FileObject)fileObject)) {
                arrayList.add(fileObject);
            }
        }
        return arrayList;
    }

    public void notifyDeleting() throws IOException {
        Properties properties = new Properties();
        String[] stringArray = this.actionProvider.getTargetNames("clean", Lookup.EMPTY, properties);
        FileObject fileObject = J2SEProjectUtil.getBuildXml(this.project);
        assert (stringArray != null);
        assert (stringArray.length > 0);
        ActionUtils.runTarget((FileObject)fileObject, (String[])stringArray, (Properties)properties).waitFinished();
    }

    public void notifyDeleted() throws IOException {
        this.project.getAntProjectHelper().notifyDeleted();
    }

    public void notifyCopying() {
        this.rememberLibraryLocation();
        this.readPrivateProperties();
        this.rememberConfigurations();
    }

    public void notifyCopied(Project project, File file, String string) {
        if (project == null) {
            return;
        }
        J2SEProjectOperations j2SEProjectOperations = (J2SEProjectOperations)project.getLookup().lookup(J2SEProjectOperations.class);
        this.fixLibraryLocation(j2SEProjectOperations);
        this.fixPrivateProperties(j2SEProjectOperations);
        this.fixDistJarProperty(string);
        this.project.getReferenceHelper().fixReferences(file);
        this.project.setName(string);
        this.restoreConfigurations(j2SEProjectOperations);
    }

    public void notifyMoving() throws IOException {
        if (!this.project.getUpdateHelper().requestUpdate()) {
            throw new IOException(NbBundle.getMessage(J2SEProjectOperations.class, (String)"MSG_OldProjectMetadata"));
        }
        this.rememberLibraryLocation();
        this.readPrivateProperties();
        this.rememberConfigurations();
        this.notifyDeleting();
    }

    public void notifyMoved(Project project, File file, String string) {
        if (project == null) {
            this.project.getAntProjectHelper().notifyDeleted();
            return;
        }
        J2SEProjectOperations j2SEProjectOperations = (J2SEProjectOperations)project.getLookup().lookup(J2SEProjectOperations.class);
        this.fixLibraryLocation(j2SEProjectOperations);
        this.fixPrivateProperties(j2SEProjectOperations);
        this.fixDistJarProperty(string);
        this.project.setName(string);
        this.project.getReferenceHelper().fixReferences(file);
        this.restoreConfigurations(j2SEProjectOperations);
    }

    private void fixLibraryLocation(J2SEProjectOperations j2SEProjectOperations) throws IllegalArgumentException {
        String string = j2SEProjectOperations.libraryPath;
        if (string != null) {
            if (!new File(string).isAbsolute()) {
                if (!j2SEProjectOperations.libraryWithinProject) {
                    File file = j2SEProjectOperations.libraryFile;
                    if (file == null) {
                        return;
                    }
                    String string2 = PropertyUtils.relativizeFile((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory()), (File)file);
                    if (string2 != null) {
                        this.project.getAntProjectHelper().setLibrariesLocation(string2);
                    } else {
                        this.project.getAntProjectHelper().setLibrariesLocation(file.getAbsolutePath());
                    }
                }
            } else if (j2SEProjectOperations.libraryWithinProject && j2SEProjectOperations.absolutesRelPath != null) {
                this.project.getAntProjectHelper().setLibrariesLocation(PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory()), (String)j2SEProjectOperations.absolutesRelPath).getAbsolutePath());
            }
        }
    }

    private void readPrivateProperties() {
        ProjectManager.mutex().readAccess(new Runnable(){

            public void run() {
                J2SEProjectOperations.this.appArgs = J2SEProjectOperations.this.project.getUpdateHelper().getProperties("nbproject/private/private.properties").getProperty("application.args");
                J2SEProjectOperations.this.workDir = J2SEProjectOperations.this.project.getUpdateHelper().getProperties("nbproject/private/private.properties").getProperty("work.dir");
            }
        });
    }

    private void fixPrivateProperties(final J2SEProjectOperations j2SEProjectOperations) {
        if (j2SEProjectOperations != null && (j2SEProjectOperations.appArgs != null || j2SEProjectOperations.workDir != null)) {
            ProjectManager.mutex().writeAccess(new Runnable(){

                public void run() {
                    EditableProperties editableProperties = J2SEProjectOperations.this.project.getUpdateHelper().getProperties("nbproject/private/private.properties");
                    if (j2SEProjectOperations.appArgs != null) {
                        editableProperties.put("application.args", j2SEProjectOperations.appArgs);
                    }
                    if (j2SEProjectOperations.workDir != null) {
                        editableProperties.put("work.dir", j2SEProjectOperations.workDir);
                    }
                    J2SEProjectOperations.this.project.getUpdateHelper().putProperties("nbproject/private/private.properties", editableProperties);
                }
            });
        }
    }

    private void fixDistJarProperty(final String string) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                ProjectInformation projectInformation = (ProjectInformation)J2SEProjectOperations.this.project.getLookup().lookup(ProjectInformation.class);
                String string3 = projectInformation == null ? null : "${dist.dir}/" + PropertyUtils.getUsablePropertyName((String)projectInformation.getDisplayName()) + ".jar";
                EditableProperties editableProperties = J2SEProjectOperations.this.project.getUpdateHelper().getProperties("nbproject/project.properties");
                String string2 = editableProperties.getProperty("dist.jar");
                if (string3 != null && string3.equals(string2)) {
                    editableProperties.put("dist.jar", "${dist.dir}/" + PropertyUtils.getUsablePropertyName((String)string) + ".jar");
                    J2SEProjectOperations.this.project.getUpdateHelper().putProperties("nbproject/project.properties", editableProperties);
                }
            }
        });
    }

    private void rememberLibraryLocation() {
        this.libraryWithinProject = false;
        this.absolutesRelPath = null;
        this.libraryPath = this.project.getAntProjectHelper().getLibrariesLocation();
        if (this.libraryPath != null) {
            File file = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
            this.libraryFile = PropertyUtils.resolveFile((File)file, (String)this.libraryPath);
            if (FileOwnerQuery.getOwner((URI)this.libraryFile.toURI()) == this.project && this.libraryFile.getAbsolutePath().startsWith(file.getAbsolutePath())) {
                this.libraryWithinProject = true;
                FileObject fileObject = FileUtil.toFileObject((File)this.libraryFile);
                if (new File(this.libraryPath).isAbsolute() && fileObject != null) {
                    this.absolutesRelPath = FileUtil.getRelativePath((FileObject)this.project.getProjectDirectory(), (FileObject)fileObject);
                }
            }
        }
    }

    private void rememberConfigurations() {
        FileObject fileObject = this.project.getProjectDirectory().getFileObject("nbproject/private/config.properties");
        if (fileObject != null) {
            try {
                FileSystem fileSystem = FileUtil.createMemoryFileSystem();
                FileUtil.copyFile((FileObject)fileObject, (FileObject)fileSystem.getRoot(), (String)fileObject.getName());
                fileObject = this.project.getProjectDirectory().getFileObject("nbproject/private/configs");
                if (fileObject != null && fileObject.isFolder()) {
                    FileObject fileObject2 = fileSystem.getRoot().createFolder("configs");
                    for (FileObject fileObject3 : fileObject.getChildren()) {
                        FileUtil.copyFile((FileObject)fileObject3, (FileObject)fileObject2, (String)fileObject3.getName());
                    }
                }
                this.configs = fileSystem;
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    private void restoreConfigurations(J2SEProjectOperations j2SEProjectOperations) {
        FileSystem fileSystem = j2SEProjectOperations.configs;
        j2SEProjectOperations.configs = null;
        if (fileSystem != null) {
            try {
                FileObject fileObject;
                FileObject fileObject2 = fileSystem.getRoot().getFileObject("config.properties");
                if (fileObject2 != null && (fileObject = FileUtil.createFolder((FileObject)this.project.getProjectDirectory(), (String)"nbproject/private")) != null) {
                    FileObject[] fileObjectArray = fileObject.getFileObject(fileObject2.getName(), fileObject2.getExt());
                    if (fileObjectArray != null) {
                        fileObjectArray.delete();
                    }
                    FileUtil.copyFile((FileObject)fileObject2, (FileObject)fileObject, (String)fileObject2.getName());
                }
                if ((fileObject2 = fileSystem.getRoot().getFileObject("configs")) != null && (fileObject = FileUtil.createFolder((FileObject)this.project.getProjectDirectory(), (String)"nbproject/private/configs")) != null) {
                    for (FileObject fileObject3 : fileObject2.getChildren()) {
                        FileUtil.copyFile((FileObject)fileObject3, (FileObject)fileObject, (String)fileObject3.getName());
                    }
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }
}

