/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.structure;

import java.util.LinkedList;
import java.util.logging.Level;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.antlr.TokenStreamException;
import org.netbeans.modules.cnd.antlr.TokenStreamRecognitionException;
import org.netbeans.modules.cnd.apt.impl.structure.APTBaseNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTDefineNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTElifNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTElseNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTEndifNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTErrorNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTFileNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTIfNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTIfdefNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTIfndefNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTIncludeNextNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTIncludeNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTStreamNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTTokenBasedNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTUndefineNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTUnknownNode;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.utils.APTTraceUtils;
import org.netbeans.modules.cnd.apt.utils.APTUtils;

public final class APTBuilderImpl {
    private LinkedList<Pair> nodeStack = new LinkedList();

    public APTFile buildAPT(CharSequence charSequence, TokenStream tokenStream) {
        if (tokenStream == null) {
            return null;
        }
        APTFileNode aPTFileNode = new APTFileNode(charSequence);
        try {
            this.buildFileAPT(aPTFileNode, tokenStream);
        }
        catch (TokenStreamRecognitionException tokenStreamRecognitionException) {
            APTUtils.LOG.log(Level.SEVERE, "error on building APT\n {0}", new Object[]{tokenStreamRecognitionException});
        }
        catch (TokenStreamException tokenStreamException) {
            APTUtils.LOG.log(Level.SEVERE, "error on converting token stream to text while building APT\n{0}", new Object[]{tokenStreamException});
            APTUtils.LOG.log(Level.SEVERE, "problem file is {0}", new Object[]{charSequence});
        }
        return aPTFileNode;
    }

    public static APT buildAPTLight(APT aPT) {
        assert (aPT != null);
        assert (APTBuilderImpl.isRootNode(aPT));
        APT aPT2 = APTBuilderImpl.createLightCopy(aPT);
        APT aPT3 = APTBuilderImpl.nextRoot(aPT);
        APT aPT4 = aPT2;
        do {
            APT aPT5;
            APT aPT6;
            if ((aPT6 = APTBuilderImpl.nextRoot(aPT3.getFirstChild())) != null) {
                aPT5 = APTBuilderImpl.buildAPTLight(aPT6);
                assert (aPT5 != null);
                assert (APTBuilderImpl.isRootNode(aPT5));
                aPT4.setFirstChild(aPT5);
            }
            aPT3 = aPT5 = APTBuilderImpl.nextRoot(aPT3.getNextSibling());
            if (aPT5 == null) continue;
            APT aPT7 = APTBuilderImpl.createLightCopy(aPT5);
            assert (aPT7 != null);
            assert (APTBuilderImpl.isRootNode(aPT7));
            aPT4.setNextSibling(aPT7);
            aPT4 = aPT7;
        } while (aPT3 != null);
        assert (aPT2 != null);
        assert (APTBuilderImpl.isRootNode(aPT2));
        return aPT2;
    }

    private void buildFileAPT(APTFileNode aPTFileNode, TokenStream tokenStream) throws TokenStreamException {
        APTToken aPTToken = this.nonRecursiveBuild(aPTFileNode, tokenStream);
        assert (APTUtils.isEOF(aPTToken));
    }

    private APTToken nonRecursiveBuild(APTFileNode aPTFileNode, TokenStream tokenStream) throws TokenStreamException {
        assert (tokenStream != null);
        Pair pair = new Pair(aPTFileNode);
        APTToken aPTToken = (APTToken)tokenStream.nextToken();
        while (!APTUtils.isEOF(aPTToken)) {
            APTBaseNode aPTBaseNode = this.createNode(aPTToken);
            aPTToken = this.initNode(aPTFileNode, aPTBaseNode, (APTToken)tokenStream.nextToken(), tokenStream);
            if (APTUtils.isEndConditionNode(aPTBaseNode.getType())) {
                if (!this.nodeStack.isEmpty()) {
                    pair = this.nodeStack.removeLast();
                } else {
                    APTUtils.LOG.log(Level.SEVERE, "{0}, line {1}: {2} without corresponding #if\n", new Object[]{APTTraceUtils.toFileString(aPTFileNode), aPTToken.getLine(), aPTToken.getText()});
                }
            }
            pair.addChild(aPTBaseNode);
            if (!APTUtils.isStartOrSwitchConditionNode(aPTBaseNode.getType())) continue;
            this.nodeStack.addLast(pair);
            pair = new Pair(aPTBaseNode);
        }
        for (Pair pair2 : this.nodeStack) {
            APTToken aPTToken2 = pair2.active.getToken();
            APTUtils.LOG.log(Level.SEVERE, "{0}, line {1}: {2} without closing #endif\n", new Object[]{APTTraceUtils.toFileString(aPTFileNode), aPTToken2 == null ? -1 : aPTToken2.getLine(), aPTToken2 == null ? Integer.valueOf(-1) : aPTToken2.getText()});
        }
        return aPTToken;
    }

    private APTToken initNode(APTFileNode aPTFileNode, APT aPT, APTToken aPTToken, TokenStream tokenStream) throws TokenStreamException {
        while (!APTUtils.isEOF(aPTToken) && aPT.accept(aPTFileNode, aPTToken)) {
            aPTToken = (APTToken)tokenStream.nextToken();
        }
        if (APTUtils.isEndDirectiveToken(aPTToken.getType())) {
            aPTToken = (APTToken)tokenStream.nextToken();
        }
        return aPTToken;
    }

    private APTBaseNode createNode(APTToken aPTToken) {
        APTTokenBasedNode aPTTokenBasedNode;
        assert (!APTUtils.isEOF(aPTToken));
        int n = aPTToken.getType();
        switch (n) {
            case 17: {
                aPTTokenBasedNode = new APTIfNode(aPTToken);
                break;
            }
            case 15: {
                aPTTokenBasedNode = new APTIfdefNode(aPTToken);
                break;
            }
            case 16: {
                aPTTokenBasedNode = new APTIfndefNode(aPTToken);
                break;
            }
            case 11: {
                aPTTokenBasedNode = new APTIncludeNode(aPTToken);
                break;
            }
            case 12: {
                aPTTokenBasedNode = new APTIncludeNextNode(aPTToken);
                break;
            }
            case 18: {
                aPTTokenBasedNode = new APTElifNode(aPTToken);
                break;
            }
            case 19: {
                aPTTokenBasedNode = new APTElseNode(aPTToken);
                break;
            }
            case 20: {
                aPTTokenBasedNode = new APTEndifNode(aPTToken);
                break;
            }
            case 13: {
                aPTTokenBasedNode = new APTDefineNode(aPTToken);
                break;
            }
            case 14: {
                aPTTokenBasedNode = new APTUndefineNode(aPTToken);
                break;
            }
            case 23: {
                aPTTokenBasedNode = new APTErrorNode(aPTToken);
                break;
            }
            case 21: 
            case 22: 
            case 24: {
                aPTTokenBasedNode = new APTUnknownNode(aPTToken);
                break;
            }
            default: {
                assert (!APTUtils.isPreprocessorToken(n)) : "all preprocessor tokens should be handled above";
                aPTTokenBasedNode = new APTStreamNode(aPTToken);
            }
        }
        assert (aPTTokenBasedNode != null);
        return aPTTokenBasedNode;
    }

    public static APT createLightCopy(APT aPT) {
        assert (aPT != null);
        assert (APTBuilderImpl.isRootNode(aPT));
        APTBaseNode aPTBaseNode = null;
        switch (aPT.getType()) {
            case 2: {
                break;
            }
            case 5: {
                aPTBaseNode = new APTDefineNode((APTDefineNode)aPT);
                break;
            }
            case 6: {
                aPTBaseNode = new APTUndefineNode((APTUndefineNode)aPT);
                break;
            }
            case 7: {
                aPTBaseNode = new APTIfdefNode((APTIfdefNode)aPT);
                break;
            }
            case 8: {
                aPTBaseNode = new APTIfndefNode((APTIfndefNode)aPT);
                break;
            }
            case 9: {
                aPTBaseNode = new APTIfNode((APTIfNode)aPT);
                break;
            }
            case 10: {
                aPTBaseNode = new APTElifNode((APTElifNode)aPT);
                break;
            }
            case 11: {
                aPTBaseNode = new APTElseNode((APTElseNode)aPT);
                break;
            }
            case 12: {
                aPTBaseNode = new APTEndifNode((APTEndifNode)aPT);
                break;
            }
            case 3: {
                aPTBaseNode = new APTIncludeNode((APTIncludeNode)aPT);
                break;
            }
            case 4: {
                aPTBaseNode = new APTIncludeNextNode((APTIncludeNextNode)aPT);
                break;
            }
            case 15: {
                aPTBaseNode = new APTErrorNode((APTErrorNode)aPT);
                break;
            }
            case 1: {
                aPTBaseNode = new APTFileNode((APTFileNode)aPT);
                break;
            }
        }
        return aPTBaseNode;
    }

    private static boolean isRootNode(APT aPT) {
        switch (aPT.getType()) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                return true;
            }
        }
        return false;
    }

    private static APT nextRoot(APT aPT) {
        for (APT aPT2 = aPT; aPT2 != null; aPT2 = aPT2.getNextSibling()) {
            if (!APTBuilderImpl.isRootNode(aPT2)) continue;
            return aPT2;
        }
        return null;
    }

    private static final class Pair {
        final APTBaseNode active;
        APTBaseNode lastChild;

        Pair(APTBaseNode aPTBaseNode) {
            this.active = aPTBaseNode;
        }

        void addChild(APTBaseNode aPTBaseNode) {
            if (this.lastChild == null) {
                this.active.setFirstChild(aPTBaseNode);
            } else {
                this.lastChild.setNextSibling(aPTBaseNode);
            }
            this.lastChild = aPTBaseNode;
        }

        public String toString() {
            return "active:" + this.active + " lastChild:" + this.lastChild;
        }
    }
}

