/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.support;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.cnd.debug.CndTraceFlags;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;

public final class IncludeDirEntry {
    private static final int MANAGER_DEFAULT_CAPACITY;
    private static final int MANAGER_DEFAULT_SLICED_NUMBER;
    private static final IncludeDirStorage storage;
    private final File file;
    private final boolean exists;
    private final boolean isFramework;
    private final CharSequence asCharSeq;

    public IncludeDirEntry(File file, boolean bl, boolean bl2, CharSequence charSequence) {
        this.file = file;
        this.exists = bl;
        this.isFramework = bl2;
        this.asCharSeq = charSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IncludeDirEntry get(String string) {
        Map map;
        CharSequence charSequence = FilePathCache.getManager().getString((CharSequence)string);
        Map map2 = map = IncludeDirEntry.storage.getDelegate(charSequence);
        synchronized (map2) {
            IncludeDirEntry includeDirEntry = (IncludeDirEntry)map.get(charSequence);
            if (includeDirEntry == null) {
                File file = new File(string);
                String string2 = file.getAbsolutePath();
                boolean bl = string2.endsWith("/Frameworks");
                CharSequence charSequence2 = FilePathCache.getManager().getString((CharSequence)string2);
                boolean bl2 = CndFileUtils.isExistingDirectory((File)file, (String)string2);
                includeDirEntry = new IncludeDirEntry(file, bl2, bl, charSequence2);
                map.put(charSequence, includeDirEntry);
            }
            return includeDirEntry;
        }
    }

    public CharSequence getAsSharedCharSequence() {
        return this.asCharSeq;
    }

    public boolean isFramework() {
        return this.isFramework;
    }

    public boolean isExistingDirectory() {
        return this.exists;
    }

    public File getFile() {
        return this.file;
    }

    public String toString() {
        return (this.exists ? "" : "NOT EXISTING ") + this.asCharSeq;
    }

    public String getAsString() {
        return this.file.getPath();
    }

    static void disposeCache() {
        storage.dispose();
    }

    static {
        int n = CndUtils.getConcurrencyLevel();
        if (n <= 4) {
            MANAGER_DEFAULT_SLICED_NUMBER = 32;
            MANAGER_DEFAULT_CAPACITY = 512;
        } else {
            MANAGER_DEFAULT_SLICED_NUMBER = 128;
            MANAGER_DEFAULT_CAPACITY = 128;
        }
        storage = new IncludeDirStorage(MANAGER_DEFAULT_SLICED_NUMBER, MANAGER_DEFAULT_CAPACITY);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IncludeDirStorage {
        private final WeakHashMap<CharSequence, IncludeDirEntry>[] instances;
        private final int segmentMask;

        private IncludeDirStorage(int n, int n2) {
            int n3;
            for (n3 = 1; n3 < n; n3 <<= 1) {
            }
            this.segmentMask = n3 - 1;
            WeakHashMap[] weakHashMapArray = new WeakHashMap[n3];
            for (int i = 0; i < weakHashMapArray.length; ++i) {
                weakHashMapArray[i] = new WeakHashMap(n2);
            }
            this.instances = weakHashMapArray;
        }

        private Map<CharSequence, IncludeDirEntry> getDelegate(CharSequence charSequence) {
            int n = charSequence.hashCode() & this.segmentMask;
            return this.instances[n];
        }

        public final IncludeDirEntry getSharedUID(CharSequence charSequence) {
            return this.getDelegate(charSequence).get(charSequence);
        }

        public final void dispose() {
            for (int i = 0; i < this.instances.length; ++i) {
                if (this.instances[i].size() <= 0) continue;
                if (CndTraceFlags.TRACE_SLICE_DISTIBUTIONS) {
                    System.out.println("Include Dir Cache " + this.instances[i].size());
                    HashMap<Class, Integer> hashMap = new HashMap<Class, Integer>();
                    for (CharSequence charSequence : this.instances[i].keySet()) {
                        if (charSequence == null) continue;
                        this.incCounter(hashMap, charSequence);
                    }
                    for (Map.Entry entry : hashMap.entrySet()) {
                        System.out.println("   " + entry.getValue() + " of " + ((Class)entry.getKey()).getName());
                    }
                }
                this.instances[i].clear();
            }
        }

        private void incCounter(Map<Class, Integer> map, Object object) {
            Integer n = map.get(object.getClass());
            n = n != null ? new Integer(n + 1) : new Integer(1);
            map.put(object.getClass(), n);
        }
    }
}

