/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.utils;

import java.io.File;
import java.util.Iterator;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.support.IncludeDirEntry;
import org.netbeans.modules.cnd.apt.support.ResolvedPath;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APTIncludeUtils {
    private APTIncludeUtils() {
    }

    public static ResolvedPath resolveFilePath(String string, CharSequence charSequence) {
        String string2;
        File file;
        if (charSequence != null && APTIncludeUtils.isExistingFile(file = new File(string2 = new File(((Object)charSequence).toString()).getParent(), string))) {
            String string3 = file.getAbsolutePath();
            return new ResolvedPath(FilePathCache.getManager().getString((CharSequence)string2), APTIncludeUtils.normalize(string3), string3, true, 0);
        }
        return null;
    }

    public static ResolvedPath resolveAbsFilePath(String string) {
        File file;
        if (APTTraceFlags.APT_ABSOLUTE_INCLUDES && (file = new File(string)).isAbsolute() && APTIncludeUtils.isExistingFile(file)) {
            return new ResolvedPath(FilePathCache.getManager().getString((CharSequence)file.getParent()), APTIncludeUtils.normalize(string), string, false, 0);
        }
        return null;
    }

    public static ResolvedPath resolveFilePath(Iterator<IncludeDirEntry> iterator, String string, int n) {
        if (Utilities.isWindows()) {
            string = string.replace('/', File.separatorChar);
        }
        while (iterator.hasNext()) {
            IncludeDirEntry includeDirEntry = iterator.next();
            if (includeDirEntry.isExistingDirectory()) {
                int n2;
                String string2 = CharSequenceKey.toString((CharSequence)includeDirEntry.getAsString(), (char)File.separatorChar, (CharSequence)string);
                if (APTIncludeUtils.isExistingFile(string2)) {
                    return new ResolvedPath(includeDirEntry.getAsSharedCharSequence(), APTIncludeUtils.normalize(string2), string2, false, n);
                }
                if (includeDirEntry.isFramework() && (n2 = string.indexOf(47)) > 0 && APTIncludeUtils.isExistingFile(string2 = includeDirEntry.getAsString() + "/" + string.substring(0, n2) + ".framework/Headers" + string.substring(n2))) {
                    return new ResolvedPath(includeDirEntry.getAsSharedCharSequence(), APTIncludeUtils.normalize(string2), string2, false, n);
                }
            }
            ++n;
        }
        return null;
    }

    private static String normalize(String string) {
        return CndFileUtils.normalizeAbsolutePath((String)string);
    }

    private static boolean isExistingFile(File file) {
        return CndFileUtils.isExistingFile((File)file);
    }

    private static boolean isExistingFile(String string) {
        return CndFileUtils.isExistingFile((String)string);
    }
}

