/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.api;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.impl.SourceAccessor;
import org.netbeans.modules.parsing.impl.SourceCache;
import org.netbeans.modules.parsing.impl.SourceFlags;
import org.netbeans.modules.parsing.impl.TaskProcessor;
import org.netbeans.modules.parsing.impl.event.EventSupport;
import org.netbeans.modules.parsing.impl.indexing.Util;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Parameters;
import org.openide.util.UserQuestionException;

public final class Source {
    private static final Logger LOG = Logger.getLogger(Source.class.getName());
    private static final Map<FileObject, Reference<Source>> instances = new WeakHashMap<FileObject, Reference<Source>>();
    private final String mimeType;
    private final FileObject fileObject;
    private final Document document;
    private final Set<SourceFlags> flags = Collections.synchronizedSet(EnumSet.noneOf(SourceFlags.class));
    private int taskCount;
    private volatile Parser cachedParser;
    private volatile ASourceModificationEvent sourceModificationEvent;
    private final ASourceModificationEvent unspecifiedSourceModificationEvent = new ASourceModificationEvent(this, -1, -1);
    private Map<Class<? extends Scheduler>, ? extends SchedulerEvent> schedulerEvents;
    private SourceCache cache;
    private volatile long eventId;
    private final EventSupport support = new EventSupport(this);

    public static Source create(FileObject fileObject) {
        Parameters.notNull((CharSequence)"fileObject", (Object)fileObject);
        if (!fileObject.isValid() || !fileObject.isData()) {
            return null;
        }
        return Source._get(fileObject.getMIMEType(), fileObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Source create(Document document) {
        Parameters.notNull((CharSequence)"document", (Object)document);
        String string = DocumentUtilities.getMimeType((Document)document);
        if (string == null) {
            throw new NullPointerException("Netbeans documents must have 'mimeType' property: " + document.getClass() + "@" + Integer.toHexString(System.identityHashCode(document)));
        }
        Class<Source> clazz = Source.class;
        synchronized (Source.class) {
            Source source;
            Reference reference = (Reference)document.getProperty(Source.class);
            Source source2 = source = reference == null ? null : (Source)reference.get();
            if (source != null && source.getFileObject() != null && !source.getFileObject().isValid()) {
                source = null;
            }
            if (source == null) {
                FileObject fileObject = Util.getFileObject(document);
                if (fileObject != null) {
                    source = Source._get(string, fileObject);
                } else {
                    if ("text/x-dialog-binding".equals(string)) {
                        LanguagePath languagePath;
                        InputAttributes inputAttributes = (InputAttributes)document.getProperty(InputAttributes.class);
                        Document document2 = (Document)inputAttributes.getValue(languagePath = LanguagePath.get((Language)((Language)MimeLookup.getLookup((String)string).lookup(Language.class))), (Object)"dialogBinding.document");
                        fileObject = document2 != null ? Util.getFileObject(document2) : (FileObject)inputAttributes.getValue(languagePath, (Object)"dialogBinding.fileObject");
                    }
                    source = new Source(string, document, fileObject);
                }
                document.putProperty(Source.class, new WeakReference<Source>(source));
            }
            assert (source != null) : "No Source for " + document;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return source;
        }
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Document getDocument(boolean bl) {
        Object object;
        if (this.document != null) {
            return this.document;
        }
        EditorCookie editorCookie = null;
        try {
            object = DataObject.find((FileObject)this.fileObject);
            editorCookie = (EditorCookie)object.getLookup().lookup(EditorCookie.class);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        if (editorCookie == null) {
            return null;
        }
        object = editorCookie.getDocument();
        if (object == null && bl) {
            try {
                try {
                    object = editorCookie.openDocument();
                }
                catch (UserQuestionException userQuestionException) {
                    userQuestionException.confirmed();
                    object = editorCookie.openDocument();
                }
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, null, iOException);
            }
        }
        return object;
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snapshot createSnapshot() {
        CharSequence[] charSequenceArray;
        block18: {
            charSequenceArray = new CharSequence[]{""};
            Document document = this.getDocument(false);
            try {
                if (document == null) {
                    try {
                        if (!this.fileObject.isValid()) break block18;
                        InputStream inputStream = this.fileObject.getInputStream();
                        try {
                            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, FileEncodingQuery.getEncoding((FileObject)this.fileObject)));
                            try {
                                StringBuilder stringBuilder = new StringBuilder(Math.max(16, (int)this.fileObject.getSize()));
                                boolean bl = false;
                                char[] cArray = new char[1024];
                                int n = -1;
                                while (-1 != (n = bufferedReader.read(cArray, 0, cArray.length))) {
                                    for (int i = 0; i < n; ++i) {
                                        char c = cArray[i];
                                        if (bl && c == '\n') {
                                            stringBuilder.append('\n');
                                            bl = false;
                                            continue;
                                        }
                                        if (c == '\r') {
                                            bl = true;
                                            continue;
                                        }
                                        if (c == '\u2028' || c == '\u2029') {
                                            stringBuilder.append('\n');
                                            bl = false;
                                            continue;
                                        }
                                        bl = false;
                                        stringBuilder.append(c);
                                    }
                                }
                                charSequenceArray[0] = stringBuilder;
                                break block18;
                            }
                            finally {
                                bufferedReader.close();
                            }
                        }
                        finally {
                            inputStream.close();
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    catch (IOException iOException) {
                        LOG.log(Level.WARNING, null, iOException);
                    }
                    break block18;
                }
                final Document document2 = document;
                document2.render(new Runnable(){

                    public void run() {
                        try {
                            int n = document2.getLength();
                            charSequenceArray[0] = n < 0 ? "" : document2.getText(0, n);
                        }
                        catch (BadLocationException badLocationException) {
                            LOG.log(Level.WARNING, null, badLocationException);
                        }
                    }
                });
            }
            catch (OutOfMemoryError outOfMemoryError) {
                charSequenceArray[0] = "";
                LOG.log(Level.INFO, null, outOfMemoryError);
                if (document != null) {
                    LOG.warning("Can't create snapshot of " + document + ", size=" + document.getLength() + ", mimeType=" + this.mimeType);
                }
                LOG.warning("Can't create snapshot of " + this.fileObject + ", size=" + this.fileObject.getSize() + ", mimeType=" + this.mimeType);
            }
        }
        return new Snapshot(charSequenceArray[0], this, MimePath.get((String)this.mimeType), new int[][]{{0, 0}}, new int[][]{{0, 0}});
    }

    public String toString() {
        return super.toString() + "[mimeType=" + this.mimeType + ", fileObject=" + this.fileObject + ", document=" + this.document;
    }

    private Source(String string, Document document, FileObject fileObject) {
        this.mimeType = string;
        this.document = document;
        this.fileObject = fileObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Source _get(String string, FileObject fileObject) {
        assert (string != null);
        assert (fileObject != null);
        Class<Source> clazz = Source.class;
        synchronized (Source.class) {
            Source source;
            Reference<Source> reference = instances.get(fileObject);
            Source source2 = source = reference == null ? null : reference.get();
            if (source == null) {
                source = new Source(string, null, fileObject);
                instances.put(fileObject, new WeakReference<Source>(source));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return source;
        }
    }

    private void assignListeners() {
        this.support.init();
    }

    static {
        SourceAccessor.setINSTANCE(new MySourceAccessor());
    }

    static class ASourceModificationEvent
    extends SourceModificationEvent {
        private int startOffset;
        private int endOffset;

        ASourceModificationEvent(Object object, int n, int n2) {
            super(object);
            this.startOffset = n;
            this.endOffset = n2;
        }

        void add(int n, int n2) {
            this.startOffset = Math.min(this.startOffset, n);
            this.endOffset = Math.min(this.endOffset, n2);
        }

        public String toString() {
            return "SourceModificationEvent " + this.startOffset + ":" + this.endOffset;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MySourceAccessor
    extends SourceAccessor {
        private MySourceAccessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setFlags(Source source, Set<SourceFlags> set) {
            assert (source != null);
            assert (set != null);
            Set set2 = source.flags;
            synchronized (set2) {
                source.flags.addAll(set);
                source.eventId++;
            }
        }

        @Override
        public boolean testFlag(Source source, SourceFlags sourceFlags) {
            assert (source != null);
            assert (sourceFlags != null);
            return source.flags.contains((Object)sourceFlags);
        }

        @Override
        public boolean cleanFlag(Source source, SourceFlags sourceFlags) {
            assert (source != null);
            assert (sourceFlags != null);
            return source.flags.remove((Object)sourceFlags);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean testAndCleanFlags(Source source, SourceFlags sourceFlags, Set<SourceFlags> set) {
            assert (source != null);
            assert (sourceFlags != null);
            assert (set != null);
            Set set2 = source.flags;
            synchronized (set2) {
                boolean bl = source.flags.contains((Object)sourceFlags);
                source.flags.removeAll(set);
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invalidate(Source source, boolean bl) {
            assert (source != null);
            Object object = TaskProcessor.INTERNAL_LOCK;
            synchronized (object) {
                boolean bl2 = source.flags.remove((Object)SourceFlags.INVALID);
                if (bl || bl2) {
                    SourceCache sourceCache = this.getCache(source);
                    assert (sourceCache != null);
                    sourceCache.invalidate();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean invalidate(Source source, long l, Snapshot snapshot) {
            assert (source != null);
            Object object = TaskProcessor.INTERNAL_LOCK;
            synchronized (object) {
                long l2;
                if (snapshot == null) {
                    return !source.flags.contains((Object)SourceFlags.INVALID);
                }
                Object object2 = source.flags;
                synchronized (object2) {
                    l2 = source.eventId;
                }
                if (l != l2) {
                    return false;
                }
                source.flags.remove((Object)SourceFlags.INVALID);
                object2 = this.getCache(source);
                assert (object2 != null);
                ((SourceCache)object2).invalidate();
                return true;
            }
        }

        @Override
        public Parser getParser(Source source) {
            assert (source != null);
            return source.cachedParser;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setParser(Source source, Parser parser) throws IllegalStateException {
            assert (source != null);
            assert (parser != null);
            Object object = TaskProcessor.INTERNAL_LOCK;
            synchronized (object) {
                if (source.cachedParser != null) {
                    throw new IllegalStateException();
                }
                source.cachedParser = parser;
            }
        }

        @Override
        public void assignListeners(Source source) {
            assert (source != null);
            source.assignListeners();
        }

        @Override
        public EventSupport getEventSupport(Source source) {
            assert (source != null);
            return source.support;
        }

        @Override
        public long getLastEventId(Source source) {
            assert (source != null);
            return source.eventId;
        }

        @Override
        public void setSourceModification(Source source, int n, int n2) {
            assert (source != null);
            source.sourceModificationEvent = new ASourceModificationEvent(source, n, n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void parsed(Source source) {
            Object object = TaskProcessor.INTERNAL_LOCK;
            synchronized (object) {
                source.sourceModificationEvent = null;
            }
        }

        @Override
        public SourceModificationEvent getSourceModificationEvent(Source source) {
            assert (source != null);
            ASourceModificationEvent aSourceModificationEvent = source.sourceModificationEvent;
            if (aSourceModificationEvent == null) {
                aSourceModificationEvent = source.unspecifiedSourceModificationEvent;
            }
            return aSourceModificationEvent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSchedulerEvents(Source source, Map<Class<? extends Scheduler>, ? extends SchedulerEvent> map) {
            assert (source != null);
            assert (map != null);
            Object object = TaskProcessor.INTERNAL_LOCK;
            synchronized (object) {
                if (map == null) {
                    throw new IllegalStateException();
                }
                source.schedulerEvents = map;
            }
        }

        @Override
        public SchedulerEvent getSchedulerEvent(Source source, Class<? extends Scheduler> clazz) {
            if (clazz == null) {
                return null;
            }
            if (source.schedulerEvents == null) {
                return null;
            }
            return (SchedulerEvent)source.schedulerEvents.get(clazz);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SourceCache getCache(Source source) {
            assert (source != null);
            Object object = TaskProcessor.INTERNAL_LOCK;
            synchronized (object) {
                if (source.cache == null) {
                    source.cache = new SourceCache(source, null);
                }
                return source.cache;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int taskAdded(Source source) {
            int n;
            assert (source != null);
            Object object = TaskProcessor.INTERNAL_LOCK;
            synchronized (object) {
                n = source.taskCount++;
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int taskRemoved(Source source) {
            assert (source != null);
            Object object = TaskProcessor.INTERNAL_LOCK;
            synchronized (object) {
                return --source.taskCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Source get(FileObject fileObject) {
            assert (fileObject != null);
            Class<Source> clazz = Source.class;
            synchronized (Source.class) {
                Reference reference = (Reference)instances.get(fileObject);
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return reference == null ? null : (Source)reference.get();
            }
        }
    }
}

