/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl;

import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.impl.CurrentEditorTaskScheduler;
import org.netbeans.modules.parsing.spi.CursorMovedSchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;

public class CursorSensitiveScheduler
extends CurrentEditorTaskScheduler {
    private JTextComponent currentEditor;
    private CaretListener caretListener;
    private Document currentDocument;
    private Source source;

    protected void setEditor(JTextComponent jTextComponent) {
        if (this.currentEditor != null) {
            this.currentEditor.removeCaretListener(this.caretListener);
        }
        this.currentEditor = jTextComponent;
        if (jTextComponent != null) {
            if (this.caretListener == null) {
                this.caretListener = new ACaretListener();
            }
            jTextComponent.addCaretListener(this.caretListener);
            Document document = jTextComponent.getDocument();
            if (this.currentDocument == document) {
                return;
            }
            this.currentDocument = document;
            this.source = Source.create(this.currentDocument);
            this.schedule(this.source, new CursorMovedSchedulerEvent(this, jTextComponent.getCaret().getDot(), jTextComponent.getCaret().getMark()){});
        } else {
            this.currentDocument = null;
            this.source = null;
            this.schedule(null, null);
        }
    }

    public String toString() {
        return "CursorSensitiveScheduller";
    }

    protected SchedulerEvent createSchedulerEvent(SourceModificationEvent sourceModificationEvent) {
        JTextComponent jTextComponent = this.currentEditor;
        Caret caret = jTextComponent != null ? jTextComponent.getCaret() : null;
        Source source = this.source;
        if (sourceModificationEvent.getModifiedSource() == source && caret != null) {
            return new CursorMovedSchedulerEvent(this, caret.getDot(), caret.getMark()){};
        }
        return null;
    }

    private class ACaretListener
    implements CaretListener {
        private ACaretListener() {
        }

        public void caretUpdate(CaretEvent caretEvent) {
            CursorSensitiveScheduler.this.schedule(new CursorMovedSchedulerEvent(this, caretEvent.getDot(), caretEvent.getMark()){});
        }
    }
}

