/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.modules.parsing.impl.indexing.CacheFolder;
import org.netbeans.modules.parsing.impl.indexing.Util;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexerFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MIMEResolver;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IndexerCache<T> {
    private static final Logger LOG = Logger.getLogger(IndexerCache.class.getName());
    private static final String ALL_MIME_TYPES = "";
    private static final Collection<? extends String> SLOW_MIME_TYPES = Arrays.asList("text/sh", "text/x-persistence1.0", "text/x-orm1.0", "application/xhtml+xml", "text/x-maven-pom+xml", "text/x-maven-profile+xml", "text/x-maven-settings+xml", "text/x-ant+xml", "text/x-nbeditor-fontcolorsettings", "text/x-nbeditor-keybindingsettings", "text/x-nbeditor-preferences", "text/x-dd-servlet2.2", "text/x-dd-servlet2.3", "text/x-dd-servlet2.4", "text/x-dd-servlet2.5", "text/x-dd-servlet3.0", "text/x-dd-servlet-fragment3.0", "text/x-dd-ejbjar2.0", "text/x-dd-ejbjar2.1", "text/x-dd-ejbjar3.0", "text/x-dd-client1.3", "text/x-dd-client1.4", "text/x-dd-client5.0", "text/x-dd-application1.4", "text/x-dd-application5.0", "text/x-dd-sun-web+xml", "text/x-dd-sun-ejb-jar+xml", "text/x-dd-sun-application+xml", "text/x-dd-sun-app-client+xml", "text/tomcat5+xml", "text/x-tld", "text/x-jsf+xml", "text/x-struts+xml", "application/x-schema+xml", "text/x-wsdl+xml", "text/x-springconfig+xml", "text/x-tmap+xml", "text/x-bpel+xml", "application/xslt+xml", "text/x-jelly+xml", "text/x-h", "application/x-java-archive", "application/x-exe", "application/x-executable+elf", "application/x-object+elf", "application/x-core+elf", "application/x-shobj+elf", "application/x-elf", "text/x-nbeditor-codetemplatesettings", "text/x-nbeditor-macrosettings", "text/x-hibernate-cfg+xml", "text/x-hibernate-mapping+xml", "text/x-hibernate-reveng+xml", "text/x-ruby", "text/x-php5");
    private static IndexerCache<CustomIndexerFactory> instanceCIF = null;
    private static IndexerCache<EmbeddingIndexerFactory> instanceEIF = null;
    private final Class<T> type;
    private final String infoFileName;
    private final Tracker tracker = new Tracker();
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private boolean firstGetData = true;
    private Map<String, Set<IndexerInfo<T>>> infosByName = null;
    private Map<String, Set<IndexerInfo<T>>> infosByMimeType = null;
    private List<IndexerInfo<T>> orderedInfos = null;

    public static synchronized IndexerCache<CustomIndexerFactory> getCifCache() {
        if (instanceCIF == null) {
            instanceCIF = new IndexerCache<CustomIndexerFactory>(CustomIndexerFactory.class){

                @Override
                protected String getIndexerName(CustomIndexerFactory customIndexerFactory) {
                    return customIndexerFactory.getIndexerName();
                }

                @Override
                protected int getIndexerVersion(CustomIndexerFactory customIndexerFactory) {
                    return customIndexerFactory.getIndexVersion();
                }
            };
        }
        return instanceCIF;
    }

    public static synchronized IndexerCache<EmbeddingIndexerFactory> getEifCache() {
        if (instanceEIF == null) {
            instanceEIF = new IndexerCache<EmbeddingIndexerFactory>(EmbeddingIndexerFactory.class){

                @Override
                protected String getIndexerName(EmbeddingIndexerFactory embeddingIndexerFactory) {
                    return embeddingIndexerFactory.getIndexerName();
                }

                @Override
                protected int getIndexerVersion(EmbeddingIndexerFactory embeddingIndexerFactory) {
                    return embeddingIndexerFactory.getIndexVersion();
                }
            };
        }
        return instanceEIF;
    }

    public Collection<? extends IndexerInfo<T>> getIndexers(Set<IndexerInfo<T>> set) {
        Object[] objectArray = this.getData(set);
        List list = (List)objectArray[2];
        return list;
    }

    public Map<String, Set<IndexerInfo<T>>> getIndexersMap(Set<IndexerInfo<T>> set) {
        Object[] objectArray = this.getData(set);
        Map map = (Map)objectArray[1];
        return map;
    }

    public Collection<? extends IndexerInfo<T>> getIndexersFor(String string) {
        Object[] objectArray = this.getData(null);
        Map map = (Map)objectArray[1];
        Set set = (Set)map.get(string);
        return set == null ? Collections.emptySet() : set;
    }

    public Collection<? extends IndexerInfo<T>> getIndexersByName(String string) {
        Object[] objectArray = this.getData(null);
        Map map = (Map)objectArray[0];
        Set set = (Set)map.get(string);
        return set;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    protected abstract String getIndexerName(T var1);

    protected abstract int getIndexerVersion(T var1);

    private IndexerCache(Class<T> clazz) {
        this.type = clazz;
        this.infoFileName = "last-known-" + clazz.getSimpleName() + ".properties";
        EditorSettings.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.tracker, (Object)EditorSettings.getDefault()));
    }

    private void collectIndexerFactoriesRegisteredForAllLanguages(Map<T, Set<String>> map) {
        Lookup.Result result = this.tracker.getLookupData(ALL_MIME_TYPES);
        for (Object e : result.allInstances()) {
            Set<String> set = map.get(e);
            if (set != null) continue;
            set = new HashSet<String>();
            set.add(ALL_MIME_TYPES);
            map.put(e, set);
        }
    }

    private void collectIndexerFactoriesRegisteredForEachParticularLanguage(Map<T, Set<String>> map, Set<String> set) {
        for (String string : set) {
            Lookup.Result result = this.tracker.getLookupData(string);
            for (Object e : result.allInstances()) {
                Set<String> set2 = map.get(e);
                if (set2 == null) {
                    set2 = new HashSet<String>();
                    set2.add(string);
                    map.put(e, set2);
                    continue;
                }
                if (set2.contains(ALL_MIME_TYPES)) continue;
                set2.add(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getData(Set<IndexerInfo<T>> set) {
        boolean bl = false;
        IndexerCache indexerCache = this;
        synchronized (indexerCache) {
            if (this.infosByName == null) {
                boolean bl2;
                Map<String, IndexerInfo<T>> map = this.readLastKnownIndexers();
                Set<String> set2 = null;
                if (this.firstGetData) {
                    this.firstGetData = false;
                    if (set != null) {
                        set2 = new HashSet<String>();
                        for (IndexerInfo<T> object2 : map.values()) {
                            set2.addAll(object2.getMimeTypes());
                        }
                        set2.remove(ALL_MIME_TYPES);
                    }
                }
                if (set2 == null || set2.size() == 0) {
                    set2 = Util.getAllMimeTypes();
                    bl2 = false;
                } else {
                    bl2 = true;
                }
                LinkedHashMap linkedHashMap = new LinkedHashMap();
                this.collectIndexerFactoriesRegisteredForAllLanguages(linkedHashMap);
                this.collectIndexerFactoriesRegisteredForEachParticularLanguage(linkedHashMap, set2);
                HashMap hashMap = new HashMap();
                HashMap hashMap2 = new HashMap();
                ArrayList arrayList = new ArrayList();
                for (Object object : linkedHashMap.keySet()) {
                    Set set3 = (Set)linkedHashMap.get(object);
                    String string = this.getIndexerName(object);
                    IndexerInfo indexerInfo = new IndexerInfo(object, string, this.getIndexerVersion(object), set3);
                    HashSet hashSet = (HashSet)hashMap.get(string);
                    if (hashSet == null) {
                        hashSet = new HashSet();
                        hashMap.put(string, hashSet);
                    }
                    hashSet.add(indexerInfo);
                    for (String string2 : set3) {
                        HashSet hashSet2 = (HashSet)hashMap2.get(string2);
                        if (hashSet2 == null) {
                            hashSet2 = new HashSet();
                            hashMap2.put(string2, hashSet2);
                        }
                        hashSet2.add(indexerInfo);
                    }
                    arrayList.add(indexerInfo);
                }
                Collections.sort(arrayList, new C());
                this.infosByName = Collections.unmodifiableMap(hashMap);
                this.infosByMimeType = Collections.unmodifiableMap(hashMap2);
                this.orderedInfos = Collections.unmodifiableList(arrayList);
                this.writeLastKnownIndexers(this.infosByName);
                HashMap hashMap3 = new HashMap();
                this.diff(map, this.infosByName, hashMap3);
                for (Set set4 : hashMap3.values()) {
                    if (set == null) {
                        bl = true;
                        set = new HashSet<IndexerInfo<T>>();
                    }
                    set.addAll(set4);
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Ordered indexers of {0}: ", this.type.getName());
                    for (IndexerInfo indexerInfo : this.orderedInfos) {
                        LOG.log(Level.FINE, "  {0} {1}: {2}", new Object[]{indexerInfo.getIndexerFactory(), set != null && set.contains(indexerInfo) ? "(modified)" : ALL_MIME_TYPES, indexerInfo.getMimeTypes()});
                    }
                }
                if (bl2) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            IndexerCache.this.resetCache();
                            IndexerCache.this.getData(null);
                        }
                    }, 321);
                }
            }
            if (bl && set.size() > 0) {
                this.pcs.firePropertyChange(this.type.getName(), null, set);
            }
            return new Object[]{this.infosByName, this.infosByMimeType, this.orderedInfos};
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCache() {
        IndexerCache indexerCache = this;
        synchronized (indexerCache) {
            this.infosByName = null;
            this.infosByMimeType = null;
            this.orderedInfos = null;
            LOG.log(Level.FINE, "{0}: resetting indexer cache", this.type.getName());
        }
    }

    private void diff(Map<String, IndexerInfo<T>> map, Map<String, Set<IndexerInfo<T>>> map2, Map<String, Set<IndexerInfo<T>>> map3) {
        for (String string : map2.keySet()) {
            Set<IndexerInfo<T>> set;
            if (!map.containsKey(string)) {
                map3.put(string, map2.get(string));
                continue;
            }
            IndexerInfo<T> indexerInfo = map.get(string);
            Set<IndexerInfo<T>> set2 = map2.get(string);
            for (IndexerInfo<T> indexerInfo2 : set2) {
                if (indexerInfo.getIndexerVersion() == indexerInfo2.getIndexerVersion()) continue;
                set = map3.get(string);
                if (set == null) {
                    set = new HashSet<IndexerInfo<T>>();
                    map3.put(string, set);
                }
                set.add(indexerInfo2);
            }
            for (IndexerInfo<T> indexerInfo2 : set2) {
                if (indexerInfo.getMimeTypes().containsAll(indexerInfo2.getMimeTypes())) continue;
                set = map3.get(string);
                if (set == null) {
                    set = new HashSet<IndexerInfo<T>>();
                    map3.put(string, set);
                }
                set.add(indexerInfo2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, IndexerInfo<T>> readLastKnownIndexers() {
        HashMap<String, IndexerInfo<T>> hashMap = new HashMap<String, IndexerInfo<T>>();
        FileObject fileObject = CacheFolder.getCacheFolder();
        FileObject fileObject2 = fileObject.getFileObject(this.infoFileName);
        if (fileObject2 != null) {
            Properties properties = new Properties();
            try {
                InputStream inputStream = fileObject2.getInputStream();
                try {
                    properties.load(inputStream);
                }
                finally {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                LOG.log(Level.FINE, "Can't read " + fileObject2.getPath() + " file", iOException);
                properties = null;
            }
            if (properties != null) {
                for (Map.Entry entry : properties.entrySet()) {
                    String string = ((String)entry.getKey()).trim();
                    int n = 0;
                    HashSet<String> hashSet = new HashSet<String>();
                    String[] stringArray = ((String)entry.getValue()).trim().split(",");
                    if (stringArray.length > 0) {
                        n = Integer.parseInt(stringArray[0]);
                        if (stringArray.length > 1) {
                            for (int i = 1; i < stringArray.length; ++i) {
                                String string2 = stringArray[i];
                                if (string2.equals("<all>")) {
                                    hashSet.add(ALL_MIME_TYPES);
                                    break;
                                }
                                hashSet.add(string2);
                            }
                        }
                    }
                    if (string.length() > 0 && n != -1 && hashSet.size() > 0) {
                        if (!hashMap.containsKey(string)) {
                            IndexerInfo indexerInfo = new IndexerInfo(null, string, n, hashSet);
                            hashMap.put(string, indexerInfo);
                            continue;
                        }
                        LOG.log(Level.FINE, "Ignoring duplicate indexers data: name={0}, version={1}, mimeTypes={2}", new Object[]{string, n, hashSet});
                        continue;
                    }
                    LOG.log(Level.FINE, "Ignoring incomplete indexer data: name={0}, version={1}, mimeTypes={2}", new Object[]{string, n, hashSet});
                }
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLastKnownIndexers(Map<String, Set<IndexerInfo<T>>> map) {
        Object object;
        Properties properties = new Properties();
        for (String string : map.keySet()) {
            Object object2;
            object = map.get(string);
            int n = -1;
            HashSet<String> hashSet = new HashSet<String>();
            Object object3 = object.iterator();
            while (object3.hasNext()) {
                object2 = (IndexerInfo)object3.next();
                if (n == -1) {
                    n = ((IndexerInfo)object2).getIndexerVersion();
                } else if (n != ((IndexerInfo)object2).getIndexerVersion()) {
                    LOG.warning(((IndexerInfo)object2).getIndexerFactory() + " has different version then other instances of the same factory: version=" + ((IndexerInfo)object2).getIndexerVersion() + ", others=" + n);
                    continue;
                }
                hashSet.addAll(((IndexerInfo)object2).getMimeTypes());
            }
            object3 = new StringBuilder();
            ((StringBuilder)object3).append(n);
            if (hashSet.size() > 0) {
                ((StringBuilder)object3).append(",");
                object2 = hashSet.iterator();
                while (object2.hasNext()) {
                    String string2 = (String)object2.next();
                    if (string2.length() == 0) {
                        ((StringBuilder)object3).append("<all>");
                        break;
                    }
                    ((StringBuilder)object3).append(string2);
                    if (!object2.hasNext()) continue;
                    ((StringBuilder)object3).append(",");
                }
            }
            properties.put(string, ((StringBuilder)object3).toString());
        }
        FileObject fileObject = CacheFolder.getCacheFolder();
        try {
            String string;
            string = FileUtil.createData((FileObject)fileObject, (String)this.infoFileName);
            object = string.getOutputStream();
            try {
                properties.store((OutputStream)object, "Last known indexer " + DateFormat.getDateTimeInstance(2, 2).format(new Date()));
            }
            finally {
                ((OutputStream)object).close();
            }
        }
        catch (IOException iOException) {
            LOG.log(Level.FINE, "Can't write " + this.infoFileName + " file in " + fileObject.getPath(), iOException);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class C
    implements Comparator<IndexerInfo<T>> {
        private final Map<String, Integer> orderByResolvers;

        public C() {
            HashMap<String, Integer> hashMap = null;
            Method method = null;
            try {
                method = MIMEResolver.class.getDeclaredMethod("getMIMETypes", new Class[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (method != null) {
                Collection collection = Lookup.getDefault().lookupAll(MIMEResolver.class);
                hashMap = new HashMap<String, Integer>();
                int n = 0;
                for (MIMEResolver mIMEResolver : collection) {
                    String[] stringArray = null;
                    try {
                        stringArray = (String[])method.invoke((Object)mIMEResolver, new Object[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (stringArray != null) {
                        for (String string : stringArray) {
                            hashMap.put(string, n);
                        }
                    }
                    ++n;
                }
            }
            this.orderByResolvers = hashMap != null && hashMap.size() > 0 ? hashMap : null;
        }

        @Override
        public int compare(IndexerInfo<T> indexerInfo, IndexerInfo<T> indexerInfo2) {
            if (this.orderByResolvers != null) {
                return this.compareByResolvers(indexerInfo, indexerInfo2);
            }
            return this.compareBySlowMimeTypes(indexerInfo, indexerInfo2);
        }

        private int compareByResolvers(IndexerInfo<T> indexerInfo, IndexerInfo<T> indexerInfo2) {
            Collection<String> collection = indexerInfo.getMimeTypes();
            Collection<String> collection2 = indexerInfo2.getMimeTypes();
            boolean bl = collection.contains(IndexerCache.ALL_MIME_TYPES);
            boolean bl2 = collection2.contains(IndexerCache.ALL_MIME_TYPES);
            if (bl && bl2) {
                return 0;
            }
            if (bl) {
                return 1;
            }
            if (bl2) {
                return -1;
            }
            Integer n = this.highestOrder(collection);
            Integer n2 = this.highestOrder(collection2);
            if (n == null && n2 == null) {
                return 0;
            }
            if (n == null) {
                return 1;
            }
            if (n2 == null) {
                return -1;
            }
            return n - n2;
        }

        private int compareBySlowMimeTypes(IndexerInfo<T> indexerInfo, IndexerInfo<T> indexerInfo2) {
            Collection<String> collection = indexerInfo.getMimeTypes();
            Collection<String> collection2 = indexerInfo2.getMimeTypes();
            boolean bl = collection.contains(IndexerCache.ALL_MIME_TYPES);
            boolean bl2 = collection2.contains(IndexerCache.ALL_MIME_TYPES);
            if (bl && bl2) {
                return 0;
            }
            if (bl) {
                return 1;
            }
            if (bl2) {
                return -1;
            }
            boolean bl3 = Util.containsAny(collection, SLOW_MIME_TYPES);
            boolean bl4 = Util.containsAny(collection2, SLOW_MIME_TYPES);
            if (bl3 && bl4) {
                return 0;
            }
            if (bl3) {
                return 1;
            }
            if (bl4) {
                return -1;
            }
            return 0;
        }

        private Integer highestOrder(Collection<? extends String> collection) {
            Integer n = null;
            for (String string : collection) {
                Integer n2 = this.orderByResolvers.get(string);
                if (n2 == null) {
                    n = null;
                    break;
                }
                if (n != null && n >= n2) continue;
                n = n2;
            }
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Tracker
    implements LookupListener,
    PropertyChangeListener,
    Runnable {
        private final Map<String, Lookup.Result<T>> results = new HashMap();
        private final RequestProcessor.Task task = RequestProcessor.getDefault().create((Runnable)this);

        private Tracker() {
        }

        public Lookup.Result<T> getLookupData(String string) {
            Lookup.Result result = this.results.get(string);
            if (result == null) {
                result = MimeLookup.getLookup((String)string).lookupResult(IndexerCache.this.type);
                result.addLookupListener((LookupListener)this);
                this.results.put(string, result);
                LOG.log(Level.FINER, "{0}: listening on MimeLookup for {1}", new Object[]{IndexerCache.this.type.getName(), string});
            }
            return result;
        }

        public void resultChanged(LookupEvent lookupEvent) {
            this.task.schedule(0);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == null || "mime-types".equals(propertyChangeEvent.getPropertyName())) {
                this.task.schedule(123);
            }
        }

        @Override
        public void run() {
            IndexerCache.this.resetCache();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IndexerInfo<T> {
        private final String indexerName;
        private final int indexerVersion;
        private final T indexerFactory;
        private final Set<String> mimeTypes;

        public T getIndexerFactory() {
            return this.indexerFactory;
        }

        public Collection<? extends String> getMimeTypes() {
            return this.mimeTypes;
        }

        public boolean isAllMimeTypesIndexer() {
            return this.mimeTypes.contains(IndexerCache.ALL_MIME_TYPES);
        }

        public String getIndexerName() {
            return this.indexerName;
        }

        public int getIndexerVersion() {
            return this.indexerVersion;
        }

        private IndexerInfo(T t, String string, int n, Set<String> set) {
            this.indexerFactory = t;
            this.indexerName = string;
            this.indexerVersion = n;
            this.mimeTypes = Collections.unmodifiableSet(set);
        }
    }
}

