/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.api.project.rake;

import java.io.File;
import java.util.ArrayList;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ruby.api.project.rake.RakeArtifact;
import org.netbeans.modules.ruby.spi.project.rake.RakeArtifactProvider;
import org.netbeans.modules.ruby.spi.project.rake.RakeArtifactQueryImplementation;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public class RakeArtifactQuery {
    private RakeArtifactQuery() {
    }

    public static RakeArtifact findArtifactFromFile(File file) {
        if (!file.equals(FileUtil.normalizeFile((File)file))) {
            throw new IllegalArgumentException("Parameter file was not normalized. Was " + file + " instead of " + FileUtil.normalizeFile((File)file));
        }
        for (RakeArtifactQueryImplementation rakeArtifactQueryImplementation : Lookup.getDefault().lookupAll(RakeArtifactQueryImplementation.class)) {
            RakeArtifact rakeArtifact = rakeArtifactQueryImplementation.findArtifact(file);
            if (rakeArtifact == null) continue;
            return rakeArtifact;
        }
        return null;
    }

    public static RakeArtifact findArtifactByID(Project project, String string) {
        RakeArtifactProvider rakeArtifactProvider = (RakeArtifactProvider)project.getLookup().lookup(RakeArtifactProvider.class);
        if (rakeArtifactProvider == null) {
            return null;
        }
        RakeArtifact[] rakeArtifactArray = rakeArtifactProvider.getBuildArtifacts();
        for (int i = 0; i < rakeArtifactArray.length; ++i) {
            if (!rakeArtifactArray[i].getID().equals(string)) continue;
            return rakeArtifactArray[i];
        }
        return null;
    }

    public static RakeArtifact[] findArtifactsByType(Project project, String string) {
        RakeArtifactProvider rakeArtifactProvider = (RakeArtifactProvider)project.getLookup().lookup(RakeArtifactProvider.class);
        if (rakeArtifactProvider == null) {
            return new RakeArtifact[0];
        }
        RakeArtifact[] rakeArtifactArray = rakeArtifactProvider.getBuildArtifacts();
        ArrayList<RakeArtifact> arrayList = new ArrayList<RakeArtifact>(rakeArtifactArray.length);
        for (RakeArtifact rakeArtifact : rakeArtifactArray) {
            if (!rakeArtifact.getType().equals(string)) continue;
            arrayList.add(rakeArtifact);
        }
        return arrayList.toArray(new RakeArtifact[arrayList.size()]);
    }
}

