/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.xref.impl;

import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.utils.cache.TextCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ObjectReferenceImpl
implements CsmReference {
    private final CsmUID<CsmObject> targetDelegate;
    private final CsmUID<CsmObject> ownerDelegate;
    private final CsmUID<CsmFile> fileUID;
    private final int startPosition;
    private final int endPosition;
    private final CsmReferenceKind kind;

    ObjectReferenceImpl(CsmUID<CsmObject> csmUID, CsmUID<CsmObject> csmUID2, CsmUID<CsmFile> csmUID3, CsmReferenceKind csmReferenceKind, int n, int n2) {
        this.targetDelegate = csmUID;
        this.ownerDelegate = csmUID2;
        this.fileUID = csmUID3;
        this.startPosition = n;
        this.endPosition = n2;
        this.kind = csmReferenceKind;
    }

    @Override
    public CsmObject getReferencedObject() {
        return (CsmObject)this.targetDelegate.getObject();
    }

    @Override
    public CsmObject getOwner() {
        return (CsmObject)this.ownerDelegate.getObject();
    }

    @Override
    public CsmReferenceKind getKind() {
        return this.kind;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ObjectReferenceImpl objectReferenceImpl = (ObjectReferenceImpl)object;
        if (this.startPosition != objectReferenceImpl.startPosition) {
            return false;
        }
        if (this.endPosition != objectReferenceImpl.endPosition) {
            return false;
        }
        if (!(this.targetDelegate == objectReferenceImpl.targetDelegate || this.targetDelegate != null && this.targetDelegate.equals(objectReferenceImpl.targetDelegate))) {
            return false;
        }
        if (!(this.ownerDelegate == objectReferenceImpl.ownerDelegate || this.ownerDelegate != null && this.ownerDelegate.equals(objectReferenceImpl.ownerDelegate))) {
            return false;
        }
        return this.fileUID == objectReferenceImpl.fileUID || this.fileUID != null && this.fileUID.equals(objectReferenceImpl.fileUID);
    }

    public int getStartOffset() {
        return this.startPosition;
    }

    public int getEndOffset() {
        return this.endPosition;
    }

    public CsmOffsetable.Position getStartPosition() {
        throw new UnsupportedOperationException("use getStartOffset instead");
    }

    public CsmOffsetable.Position getEndPosition() {
        throw new UnsupportedOperationException("use getEndOffset instead");
    }

    public CsmFile getContainingFile() {
        return this._getFile();
    }

    public CharSequence getText() {
        CsmFile csmFile = this.getContainingFile();
        if (csmFile != null) {
            return TextCache.getManager().getString(csmFile.getText(this.getStartOffset(), this.getEndOffset()));
        }
        return "";
    }

    private CsmFile _getFile() {
        CsmFile csmFile = (CsmFile)this.fileUID.getObject();
        return csmFile;
    }

    protected String getOffsetString() {
        return "[" + this.getStartOffset() + "-" + this.getEndOffset() + "]";
    }

    public int hashCode() {
        int n = 5;
        n = 97 * n + this.startPosition;
        n = 97 * n + this.endPosition;
        n = 97 * n + (this.targetDelegate != null ? this.targetDelegate.hashCode() : 0);
        n = 97 * n + (this.ownerDelegate != null ? this.ownerDelegate.hashCode() : 0);
        n = 97 * n + (this.fileUID != null ? this.fileUID.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "Object Reference: " + (this.targetDelegate != null ? this.targetDelegate.toString() : this.getOffsetString());
    }
}

